// compilar: $ gimptool-2.0 --install gimp_pintar_ratlla.c

#include <libgimp/gimp.h>

static void query (void);
static void run   (const gchar      *name,
                   gint              nparams,
                   const GimpParam  *param,
                   gint             *nreturn_vals,
                   GimpParam       **return_vals);

static void pintar_ratlla  (GimpDrawable     *drawable);

GimpPlugInInfo PLUG_IN_INFO =
{
  NULL,
  NULL,
  query,
  run
};

MAIN()

static void
query (void)
{
  static GimpParamDef args[] =
  {
    {
      GIMP_PDB_INT32,
      "run-mode",
      "Run mode"
    },
    {
      GIMP_PDB_IMAGE,
      "image",
      "Input image"
    },
    {
      GIMP_PDB_DRAWABLE,
      "drawable",
      "Input drawable"
    }
  };

  gimp_install_procedure (
    "plug-in-pintar-ratlla",
    "PintarRatlla",
    "Pinta una ratlla amb el pinzell",
    "Joan Quintana (joanillo)",
    "Copyright Joan Quintana",
    "2012",
    "_Pintar Ratlla",
    "RGB*, GRAY*",
    GIMP_PLUGIN,
    G_N_ELEMENTS (args), 0,
    args, NULL);

  gimp_plugin_menu_register ("plug-in-pintar-ratlla",
                             "<Image>/Filters/Blur");
}

static void
run (const gchar      *name,
     gint              nparams,
     const GimpParam  *param,
     gint             *nreturn_vals,
     GimpParam       **return_vals)
{
  static GimpParam  values[1];
  GimpPDBStatusType status = GIMP_PDB_SUCCESS;
  GimpRunMode       run_mode;
  GimpDrawable     *drawable;

  /* Setting mandatory output values */
  *nreturn_vals = 1;
  *return_vals  = values;

  values[0].type = GIMP_PDB_STATUS;
  values[0].data.d_status = status;

  /* Getting run_mode - we won't display a dialog if
   * we are in NONINTERACTIVE mode
   */
  run_mode = param[0].data.d_int32;

  /*  Get the specified drawable  */
  drawable = gimp_drawable_get (param[2].data.d_drawable);

  gimp_progress_init ("Pintant una ratlla...");
	
  pintar_ratlla (drawable);

  gimp_displays_flush ();
  gimp_drawable_detach (drawable);

  return;
}

static void
pintar_ratlla (GimpDrawable *drawable)
{
	gint x1, y1, longitud;
	gchar *name_nou;
	gint width, height;
	gint mask_bpp;
	gint color_bpp;

	x1=20;
	y1=20;

	//Per duplicar un pinzell:
	//name_nou = gimp_brush_duplicate ("Circle (11)"); //Còpia de Circle (11)
	//g_message ("%s",name_nou);

	gimp_brush_get_info ("Circle (11)", &width, &height, &mask_bpp, &color_bpp); //obtinc informació d'aquest pinzell
	//g_message ("%d",width);

	gimp_brushes_set_brush ("Circle Fuzzy (19)"); //escullo aquest pinzell

	//dibuixo
	//1a possibilitat
	//gdouble *strokes;
	//strokes = g_new (gdouble, 8);
	//strokes[0] = 20;
	//strokes[1] = 20;
	//strokes[2] = 40;
	//strokes[3] = 20;
	//strokes[4] = 80;
	//strokes[5] = 80;
	//strokes[6] = 120;
	//strokes[7] = 120;

	//2a possibilitat
	gdouble strokes[8]= {20,20,40,20,80,80,120,140};

	//gimp_pencil(drawable->drawable_id,8,strokes);
	gimp_paintbrush_default(drawable->drawable_id,sizeof(strokes)/sizeof(strokes[0]),strokes);

	//anem a fer un pentagrama
	gimp_brushes_set_brush ("Calligraphic Brush#3"); //escullo aquest pinzell
 	x1=20;
	y1=50;
	longitud = 300;
	gdouble linia_pentagrama[5][4]= {{x1,y1,x1+longitud,y1},{x1,y1+10,x1+longitud,y1+10},{x1,y1+20,x1+longitud,y1+20},{x1,y1+30,x1+longitud,y1+30},{x1,y1+40,x1+longitud,y1+40}};
	gimp_paintbrush_default(drawable->drawable_id,4,linia_pentagrama[0]);
	gimp_paintbrush_default(drawable->drawable_id,4,linia_pentagrama[1]);
	gimp_paintbrush_default(drawable->drawable_id,4,linia_pentagrama[2]);
	gimp_paintbrush_default(drawable->drawable_id,4,linia_pentagrama[3]);
	gimp_paintbrush_default(drawable->drawable_id,4,linia_pentagrama[4]);

	gimp_drawable_flush (drawable);
	gimp_drawable_merge_shadow (drawable->drawable_id, TRUE);
	gimp_drawable_update (drawable->drawable_id,0,0,100,100);

}
