var patt = /^S\/N:\s[0-9]{4}[A-Z]{5}[0-9]{1}(G|L)[0-9]{1}$/

function valida_sn(patt,sn) {
    return patt.test(sn)
}

console.log('S/N: 2022TREFG4G8' + ': ' + valida_sn(patt,'S/N: 2022TREFG4G8'))

function valida_sn_info(sn) {
    var str = 'TRUE';
    //avaluem el format d'esquerra a dreta:
    if (!(/^S\/N:\s/.test(sn))) {
        str = 'FALSE. No comença per S/N: ';
    } else if (!(/^S\/N:\s[0-9]{4}/.test(sn))) {
        str = 'FALSE. 4 números després de S/N';
    } else if (!(/^S\/N:\s[0-9]{4}[A-Z]{5}/.test(sn))) {
        str = 'FALSE. 5 lletres després de 4 números';
    } else if (!(/^S\/N:\s[0-9]{4}[A-Z]{5}[0-9]{1}/.test(sn))) {
        str = 'FALSE. 1 número després de 5 lletres';
    } else if (!(/^S\/N:\s[0-9]{4}[A-Z]{5}[0-9]{1}(G|L)/.test(sn))) {
        str = 'FALSE. (G|L) després de 1 número';
    } else if (!(/^S\/N:\s[0-9]{4}[A-Z]{5}[0-9]{1}(G|L)[0-9]{1}/.test(sn))) {
        str = 'FALSE. 4 números finals';
    } 

    return str;
}


console.log('2022TREFG4G8' + ': ' + valida_sn_info('2022TREFG4G8'));
console.log('S/N: 022TREFG4G8' + ': ' + valida_sn_info('S/N: 022TREFG4G8'));
console.log('S/N: 2022TRE4G8' + ': ' + valida_sn_info('S/N: 2022TRE4G8'));
console.log('S/N: 2022TREASG8' + ': ' + valida_sn_info('S/N: 2022TREASG8'));
console.log('S/N: 2022TREAS48' + ': ' + valida_sn_info('S/N: 2022TREAS48'));
console.log('S/N: 2022TREAS5G' + ': ' + valida_sn_info('S/N: 2022TREAS5G'));
console.log('S/N: 2022TREAS5G4' + ': ' + valida_sn_info('S/N: 2022TREAS5G4'));
