var patt = /^[A-Z]\.[0-9]{1,5}-[1-2][0-9]{3}$/

function valida_diposit_legal(patt,codi) {
    return patt.test(codi)
}

console.log('B.3956-2019' + ': ' + valida_diposit_legal(patt,'B.3956-2019'));
console.log('B.6-2019' + ': ' + valida_diposit_legal(patt,'B.6-2019'));
console.log('B.62019' + ': ' + valida_diposit_legal(patt,'B.62019'));
console.log('B.-2019' + ': ' + valida_diposit_legal(patt,'B.-2019'));
console.log('B3956-2019' + ': ' + valida_diposit_legal(patt,'B3956-2019'));
console.log('.3956-2019' + ': ' + valida_diposit_legal(patt,'.3956-2019'));
console.log('B.3956-3019' + ': ' + valida_diposit_legal(patt,'B.3956-3019'));
console.log();

function valida_diposit_legal_info(codi) {
    var str = 'TRUE';
    //avaluem el format d'esquerra a dreta:
    if (!(/^[A-Z]/.test(codi))) {
        str = 'FALSE. No comença per lletra';
    } else if (!(/^[A-Z]\./.test(codi))) {
        str = 'FALSE. No hi ha punt després de lletra';
    } else if (!(/^[A-Z]\.[0-9]{1,5}/.test(codi))) {
        str = 'FALSE. Després de punt no hi ha de 1 a 5 números';
    } else if (!(/^[A-Z]\.[0-9]{1,5}-/.test(codi))) {
        str = 'FALSE. Després de 1 a 5 números no hi ha el guió';
    } else if (!(/^[A-Z]\.[0-9]{1,5}-[1-2][0-9]{3}$/.test(codi))) {
        str = 'FALSE. Després del guió no hi ha l\'any';
    }

    return str;
}

console.log('3956-2019' + ': ' + valida_diposit_legal_info('3956-2019'));
console.log('B3956-2019' + ': ' + valida_diposit_legal_info('B3956-2019'));
console.log('B.A3956-2019' + ': ' + valida_diposit_legal_info('B.A3956-2019'));
console.log('B.39562019' + ': ' + valida_diposit_legal_info('B.39562019'));
console.log('B.3956-201' + ': ' + valida_diposit_legal_info('B.3956-201'));
console.log('Finalment:')
console.log('B.3956-2019' + ': ' + valida_diposit_legal_info('B.3956-2019'));