//https://www.typescriptlang.org/docs/handbook/classes.html
//$ cd ~/M06_WEC_1819/PHP/UF2/Figura/v1
//$ tsc Figura.ts
//$ node Figura.js

//v1: defineixo la classe Figura, i la classe Poligon com una col·lecció de punts
//v2: el quadrat té long_a, i el rectanble té long_a i long_b
//	un cop tinc definits el quadrat i el rectangle, ja puc definir la col·lecció de punts per al paral·lelogram
//	i també puc calcular el perímetre i la superfície.
//v3: completem rombe i romboide
//		completem el cercle, que no és paral·lelogram

class Point {
    x: number;
    y: number;
    constructor(x:number,y:number){
        this.x=x;
        this.y=y;
    }
}

abstract class Figura {
    punt0: Point;
	perimetre: number;
	superficie: number;
	tipus: string;
    constructor(public name: string, public posx0: number, public posy0: number) {
        this.punt0 = new Point(posx0,posy0);
      	this.perimetre = 50;
    }

    printName(): void {
        console.log("Nom de la figura: " + this.name);
    }

    printTipus(): void {
        console.log("Tipus: " + this.tipus);
    }

    abstract printFigura(context,info): void; // must be implemented in derived classes

}

abstract class Parallelogram extends Figura {

	col_punts = new Array();

    constructor(public name: string, public posx0: number, public posy0: number) {
        super(name, posx0, posy0); // constructors in derived classes must call super()
    }

    printFigura(context, info): void{
        let puntx_ant, punty_ant;
        puntx_ant = this.col_punts[0].x;
        punty_ant = this.col_punts[0].y;
    
        for (let i=1; i<=this.col_punts.length; i++) {
            context.moveTo(puntx_ant, punty_ant);
            if (i==this.col_punts.length){
                context.lineTo(this.col_punts[0].x, this.col_punts[0].y)
            } else {
                context.lineTo(this.col_punts[i].x, this.col_punts[i].y)
                puntx_ant = this.col_punts[i].x;
                punty_ant = this.col_punts[i].y;
            }
            context.stroke();
        }
        if (info==true) {
            context.font = "12px Arial";
            context.fillText('P=' + this.perimetre.toFixed(1) + ',S=' + this.superficie.toFixed(1), this.punt0.x, this.punt0.y);
        }
    }

    printPunts(): void {
    	//iterem tots els punts del paral·lelogram
    	this.col_punts.forEach(function (value) {
    		console.log(value);
		});
    }

    getPunts(): number[] {
    	return this.col_punts;
    }

}

class Quadrat extends Parallelogram {

	long_a: number;

    constructor(public posx0: number, public posy0: number, public a: number) {
        super("Quadrat",posx0, posy0); // constructors in derived classes must call super()
        this.tipus = "quadrat";
        this.long_a = a;
        //col·lecció de punts
        this.col_punts.push(new Point(posx0,posy0));
        this.col_punts.push(new Point(posx0+a,posy0));
        this.col_punts.push(new Point(posx0+a,posy0+a));
        this.col_punts.push(new Point(posx0,posy0+a));

        this.perimetre = 4*a;
        this.superficie = a*a;
    }

}

class Rectangle extends Parallelogram {

	long_a: number;
	long_b: number;

    constructor(public posx0: number, public posy0: number, public a: number, public b: number) {
        super("Rectangle",posx0, posy0); // constructors in derived classes must call super()
        this.tipus = "rectangle";
        this.long_a = a;
        this.long_b = b;
        //col·lecció de punts
        this.col_punts.push(new Point(posx0,posy0));
        this.col_punts.push(new Point(posx0+b,posy0));
        this.col_punts.push(new Point(posx0+b,posy0+a));
        this.col_punts.push(new Point(posx0,posy0+a));

        this.perimetre = 2*a + 2*b;
        this.superficie = a*b;
    }

}

class Rombe extends Parallelogram {

	long_a: number;
	long_h: number; //https://es.wikipedia.org/wiki/Rombo
	private alpha: number;

    constructor(public posx0: number, public posy0: number, public a: number, public h: number) {
        super("Rombe",posx0, posy0); // constructors in derived classes must call super()
        this.tipus = "rombe";
        this.long_a = a;
        this.long_h = h;
        //col·lecció de punts
        this.col_punts.push(new Point(posx0,posy0));
        this.alpha = Math.asin(h/a);
        //console.log(h + '-' + a)
        //console.log("alpha: " + this.alpha + " rad");
        this.col_punts.push(new Point(posx0+a,posy0));
        this.col_punts.push(new Point(posx0+a*(1+Math.cos(this.alpha)),posy0+h));
        this.col_punts.push(new Point(posx0 + a*Math.cos(this.alpha),posy0+h));

        this.perimetre = 4*a;
        this.superficie = a*a*Math.sin(this.alpha);
    }

}

class Romboide extends Parallelogram {

	long_a: number;
	long_b: number;
	long_h: number; //https://es.wikipedia.org/wiki/Romboide
	private alpha: number;

    constructor(public posx0: number, public posy0: number, public a: number, public b: number, public h: number) {
        super("Romboide",posx0, posy0); // constructors in derived classes must call super()
        this.tipus = "romboide";
        this.long_a = a;
        this.long_b = b;
        this.long_h = h;
        //col·lecció de punts
        this.col_punts.push(new Point(posx0,posy0));
        this.alpha = Math.asin(h/b);
        //console.log("alpha: " + this.alpha + " rad");
        this.col_punts.push(new Point(posx0+a,posy0));
        this.col_punts.push(new Point(posx0+a*(1+Math.cos(this.alpha)),posy0+h));
        this.col_punts.push(new Point(posx0+a*Math.cos(this.alpha),posy0+h));

        this.perimetre = 2*(a+b);
        this.superficie = a*h;
    }

}

class Cercle extends Figura {
    centre: Point; //centre
    long_r: number; //radi

	constructor(public posx0: number, public posy0: number, public r: number) {
		super("Cercle", posx0, posy0); // constructors in derived classes must call super()
        this.tipus = "cercle";
		this.centre = new Point(posx0, posy0);
		this.long_r = r;
		this.perimetre = 2*Math.PI*r;
        this.superficie = Math.PI*r*r;
	}

    public getCentre(): Point {
		return this.centre;
    }
    
    public getRadi(): number {
		return this.long_r;
    }

    printFigura(context, info): void {
		context.moveTo(this.punt0.x, this.punt0.y);
		context.arc(this.punt0.x, this.punt0.y, this.long_r/2, 0, 2 * Math.PI, false);
        context.stroke();
        if (info==true) {
            context.font = "12px Arial";
            context.fillText('P=' + this.perimetre.toFixed(1) + ',S=' + this.superficie.toFixed(1), this.punt0.x, this.punt0.y);
        }
    }

}
// ================================================

/*
console.log("JOC DE PROVES");
console.log("===============");
//let quadrat1: Figura;
let quadrat1 = new Quadrat(10, 10, 20);
quadrat1.printName();
quadrat1.printTipus();
console.log(quadrat1.col_punts[0]);
console.log(quadrat1.col_punts[0].x);
//iterem tots els punts del quadrat
quadrat1.getPunts().forEach(function (value) {
    console.log(value);
    //console.log(value.x); //no podem accedir a aquest valor directament??
});
quadrat1.printPunts();
console.log(quadrat1.perimetre);

console.log("");

let rectangle1 = new Rectangle(10, 10, 20, 30);
rectangle1.printName();
rectangle1.printTipus();
console.log(rectangle1.col_punts[0]);
console.log(rectangle1.col_punts[0].x);

//iterem tots els punts del rectangle
rectangle1.getPunts().forEach(function (value) {
    console.log(value);
    //console.log(value.x); //no podem accedir a aquest valor directament??
});
rectangle1.printPunts();
console.log(rectangle1.perimetre);

console.log("");


let rombe1 = new Rombe(0, 0, 30, 25);
rombe1.printName();
rombe1.printTipus();
console.log(rombe1.col_punts[0]);
console.log(rombe1.col_punts[0].x);

//iterem tots els punts del rectangle
rombe1.getPunts().forEach(function (value) {
    console.log(value);
    //console.log(value.x); //no podem accedir a aquest valor directament??
});
rombe1.printPunts();
console.log(rombe1.perimetre);

console.log("");

let romboide1 = new Romboide(0, 0, 30, 25, 5);
romboide1.printName();
romboide1.printTipus();
console.log(romboide1.col_punts[0]);
console.log(romboide1.col_punts[0].x);

//iterem tots els punts del rectangle
romboide1.getPunts().forEach(function (value) {
    console.log(value);
    //console.log(value.x); //no podem accedir a aquest valor directament??
});
romboide1.printPunts();
console.log(romboide1.perimetre);

console.log("");

let cercle1 = new Cercle(30, 30, 10);
cercle1.printName();
cercle1.printTipus();
console.log(cercle1.getCentre());
console.log(cercle1.getRadi());
console.log(cercle1.perimetre);
console.log(cercle1.punt0);
*/