//https://www.typescriptlang.org/docs/handbook/classes.html
//$ cd ~/M06_WEC_1819/PHP/UF2/Figura/v1
//$ tsc Figura.ts
//$ node Figura.js
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
//v1: defineixo la classe Figura, i la classe Poligon com una col·lecció de punts
//v2: el quadrat té long_a, i el rectanble té long_a i long_b
//	un cop tinc definits el quadrat i el rectangle, ja puc definir la col·lecció de punts per al paral·lelogram
//	i també puc calcular el perímetre i la superfície.
//v3: completem rombe i romboide
//		completem el cercle, que no és paral·lelogram
var Point = /** @class */ (function () {
    function Point(x, y) {
        this.x = x;
        this.y = y;
    }
    return Point;
}());
var Figura = /** @class */ (function () {
    function Figura(name, posx0, posy0) {
        this.name = name;
        this.posx0 = posx0;
        this.posy0 = posy0;
        this.punt0 = new Point(posx0, posy0);
        this.perimetre = 50;
    }
    Figura.prototype.printName = function () {
        console.log("Nom de la figura: " + this.name);
    };
    Figura.prototype.printTipus = function () {
        console.log("Tipus: " + this.tipus);
    };
    return Figura;
}());
var Parallelogram = /** @class */ (function (_super) {
    __extends(Parallelogram, _super);
    function Parallelogram(name, posx0, posy0) {
        var _this = _super.call(this, name, posx0, posy0) || this;
        _this.name = name;
        _this.posx0 = posx0;
        _this.posy0 = posy0;
        _this.col_punts = new Array();
        return _this;
    }
    Parallelogram.prototype.printFigura = function (context, info) {
        var puntx_ant, punty_ant;
        puntx_ant = this.col_punts[0].x;
        punty_ant = this.col_punts[0].y;
        for (var i = 1; i <= this.col_punts.length; i++) {
            context.moveTo(puntx_ant, punty_ant);
            if (i == this.col_punts.length) {
                context.lineTo(this.col_punts[0].x, this.col_punts[0].y);
            }
            else {
                context.lineTo(this.col_punts[i].x, this.col_punts[i].y);
                puntx_ant = this.col_punts[i].x;
                punty_ant = this.col_punts[i].y;
            }
            context.stroke();
        }
        if (info == true) {
            context.font = "12px Arial";
            context.fillText('P=' + this.perimetre.toFixed(1) + ',S=' + this.superficie.toFixed(1), this.punt0.x, this.punt0.y);
        }
    };
    Parallelogram.prototype.printPunts = function () {
        //iterem tots els punts del paral·lelogram
        this.col_punts.forEach(function (value) {
            console.log(value);
        });
    };
    Parallelogram.prototype.getPunts = function () {
        return this.col_punts;
    };
    return Parallelogram;
}(Figura));
var Quadrat = /** @class */ (function (_super) {
    __extends(Quadrat, _super);
    function Quadrat(posx0, posy0, a) {
        var _this = _super.call(this, "Quadrat", posx0, posy0) || this;
        _this.posx0 = posx0;
        _this.posy0 = posy0;
        _this.a = a;
        _this.tipus = "quadrat";
        _this.long_a = a;
        //col·lecció de punts
        _this.col_punts.push(new Point(posx0, posy0));
        _this.col_punts.push(new Point(posx0 + a, posy0));
        _this.col_punts.push(new Point(posx0 + a, posy0 + a));
        _this.col_punts.push(new Point(posx0, posy0 + a));
        _this.perimetre = 4 * a;
        _this.superficie = a * a;
        return _this;
    }
    return Quadrat;
}(Parallelogram));
var Rectangle = /** @class */ (function (_super) {
    __extends(Rectangle, _super);
    function Rectangle(posx0, posy0, a, b) {
        var _this = _super.call(this, "Rectangle", posx0, posy0) || this;
        _this.posx0 = posx0;
        _this.posy0 = posy0;
        _this.a = a;
        _this.b = b;
        _this.tipus = "rectangle";
        _this.long_a = a;
        _this.long_b = b;
        //col·lecció de punts
        _this.col_punts.push(new Point(posx0, posy0));
        _this.col_punts.push(new Point(posx0 + b, posy0));
        _this.col_punts.push(new Point(posx0 + b, posy0 + a));
        _this.col_punts.push(new Point(posx0, posy0 + a));
        _this.perimetre = 2 * a + 2 * b;
        _this.superficie = a * b;
        return _this;
    }
    return Rectangle;
}(Parallelogram));
var Rombe = /** @class */ (function (_super) {
    __extends(Rombe, _super);
    function Rombe(posx0, posy0, a, h) {
        var _this = _super.call(this, "Rombe", posx0, posy0) || this;
        _this.posx0 = posx0;
        _this.posy0 = posy0;
        _this.a = a;
        _this.h = h;
        _this.tipus = "rombe";
        _this.long_a = a;
        _this.long_h = h;
        //col·lecció de punts
        _this.col_punts.push(new Point(posx0, posy0));
        _this.alpha = Math.asin(h / a);
        //console.log(h + '-' + a)
        //console.log("alpha: " + this.alpha + " rad");
        _this.col_punts.push(new Point(posx0 + a, posy0));
        _this.col_punts.push(new Point(posx0 + a * (1 + Math.cos(_this.alpha)), posy0 + h));
        _this.col_punts.push(new Point(posx0 + a * Math.cos(_this.alpha), posy0 + h));
        _this.perimetre = 4 * a;
        _this.superficie = a * a * Math.sin(_this.alpha);
        return _this;
    }
    return Rombe;
}(Parallelogram));
var Romboide = /** @class */ (function (_super) {
    __extends(Romboide, _super);
    function Romboide(posx0, posy0, a, b, h) {
        var _this = _super.call(this, "Romboide", posx0, posy0) || this;
        _this.posx0 = posx0;
        _this.posy0 = posy0;
        _this.a = a;
        _this.b = b;
        _this.h = h;
        _this.tipus = "romboide";
        _this.long_a = a;
        _this.long_b = b;
        _this.long_h = h;
        //col·lecció de punts
        _this.col_punts.push(new Point(posx0, posy0));
        _this.alpha = Math.asin(h / b);
        //console.log("alpha: " + this.alpha + " rad");
        _this.col_punts.push(new Point(posx0 + a, posy0));
        _this.col_punts.push(new Point(posx0 + a * (1 + Math.cos(_this.alpha)), posy0 + h));
        _this.col_punts.push(new Point(posx0 + a * Math.cos(_this.alpha), posy0 + h));
        _this.perimetre = 2 * (a + b);
        _this.superficie = a * h;
        return _this;
    }
    return Romboide;
}(Parallelogram));
var Cercle = /** @class */ (function (_super) {
    __extends(Cercle, _super);
    function Cercle(posx0, posy0, r) {
        var _this = _super.call(this, "Cercle", posx0, posy0) || this;
        _this.posx0 = posx0;
        _this.posy0 = posy0;
        _this.r = r;
        _this.tipus = "cercle";
        _this.centre = new Point(posx0, posy0);
        _this.long_r = r;
        _this.perimetre = 2 * Math.PI * r;
        _this.superficie = Math.PI * r * r;
        return _this;
    }
    Cercle.prototype.getCentre = function () {
        return this.centre;
    };
    Cercle.prototype.getRadi = function () {
        return this.long_r;
    };
    Cercle.prototype.printFigura = function (context, info) {
        context.moveTo(this.punt0.x, this.punt0.y);
        context.arc(this.punt0.x, this.punt0.y, this.long_r / 2, 0, 2 * Math.PI, false);
        context.stroke();
        if (info == true) {
            context.font = "12px Arial";
            context.fillText('P=' + this.perimetre.toFixed(1) + ',S=' + this.superficie.toFixed(1), this.punt0.x, this.punt0.y);
        }
    };
    return Cercle;
}(Figura));
// ================================================
/*
console.log("JOC DE PROVES");
console.log("===============");
//let quadrat1: Figura;
let quadrat1 = new Quadrat(10, 10, 20);
quadrat1.printName();
quadrat1.printTipus();
console.log(quadrat1.col_punts[0]);
console.log(quadrat1.col_punts[0].x);
//iterem tots els punts del quadrat
quadrat1.getPunts().forEach(function (value) {
    console.log(value);
    //console.log(value.x); //no podem accedir a aquest valor directament??
});
quadrat1.printPunts();
console.log(quadrat1.perimetre);

console.log("");

let rectangle1 = new Rectangle(10, 10, 20, 30);
rectangle1.printName();
rectangle1.printTipus();
console.log(rectangle1.col_punts[0]);
console.log(rectangle1.col_punts[0].x);

//iterem tots els punts del rectangle
rectangle1.getPunts().forEach(function (value) {
    console.log(value);
    //console.log(value.x); //no podem accedir a aquest valor directament??
});
rectangle1.printPunts();
console.log(rectangle1.perimetre);

console.log("");


let rombe1 = new Rombe(0, 0, 30, 25);
rombe1.printName();
rombe1.printTipus();
console.log(rombe1.col_punts[0]);
console.log(rombe1.col_punts[0].x);

//iterem tots els punts del rectangle
rombe1.getPunts().forEach(function (value) {
    console.log(value);
    //console.log(value.x); //no podem accedir a aquest valor directament??
});
rombe1.printPunts();
console.log(rombe1.perimetre);

console.log("");

let romboide1 = new Romboide(0, 0, 30, 25, 5);
romboide1.printName();
romboide1.printTipus();
console.log(romboide1.col_punts[0]);
console.log(romboide1.col_punts[0].x);

//iterem tots els punts del rectangle
romboide1.getPunts().forEach(function (value) {
    console.log(value);
    //console.log(value.x); //no podem accedir a aquest valor directament??
});
romboide1.printPunts();
console.log(romboide1.perimetre);

console.log("");

let cercle1 = new Cercle(30, 30, 10);
cercle1.printName();
cercle1.printTipus();
console.log(cercle1.getCentre());
console.log(cercle1.getRadi());
console.log(cercle1.perimetre);
console.log(cercle1.punt0);
*/ 
