/***************************************************************************
 Ejemplo4_2
 (C) 2003 by Alberto Garcia Serrano
 Programacin de videojuegos con SDL
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <SDL.h>
#include "SDL_image.h"


int main(int argc, char *argv[]) {

 SDL_Surface *image, *screen;
 SDL_Rect dest;
 SDL_Event event;
 int done = 0;

	atexit(SDL_Quit);

	// Iniciar SDL
	if (SDL_Init(SDL_INIT_VIDEO) < 0) {
		printf("No se pudo iniciar SDL: %s\n",SDL_GetError());
		exit(1);
	}

	// Activamos modo de video
	screen = SDL_SetVideoMode(640,480,24,SDL_HWSURFACE);
	if (screen == NULL) {
		printf("No se puede inicializar el modo grfico: \n",SDL_GetError());
		exit(1);
	}
	
	
	// Cargamos grfico
	image = IMG_Load("teapot.jpg");
    if ( image == NULL ) {
        printf("No pude cargar grfico: %s\n", SDL_GetError());
        exit(1);
    }

	// Definimos donde dibujaremos el grfico 
	// y lo copiamos a la pantalla.
	dest.x = 0;
    dest.y = 0;
    dest.w = image->w;
    dest.h = image->h;
    SDL_BlitSurface(image, NULL, screen, &dest);

	// Mostramos la pantalla
	SDL_Flip(screen);

	// liberar superficie
    SDL_FreeSurface(image);

	// Esperamos la pulsacin de una tecla para salir
	while(done == 0) {
		while ( SDL_PollEvent(&event) ) {
			if ( event.type == SDL_KEYDOWN ) 
				done = 1;
		}
    }

	return 0;
}