/*****************************************
 Ejemplo3_5
 (C) 2003 by Alberto Garcia Serrano
 Programacin de videojuegos con SDL
 *****************************************/

#include <stdlib.h>
#include <sdl.h>

SDL_Surface* superficie;
SDL_Event event;
SDL_CD *cdrom;
int pista = 0;
int done;

int main(int argc, char* argv[]) {

	// Inicializamos SDL
	if (SDL_Init(SDL_INIT_VIDEO|SDL_INIT_CDROM)<0) {
		printf("No se pudo inicializar SDL.\n");
		exit(1);
	}

	// Inicializamos modo de video 
	if ( (superficie = SDL_SetVideoMode(640,480,0,SDL_ANYFORMAT)) == NULL) {
		printf("No se pudo inicializar la ventana.\n");
		exit(1);
	}

	// abrimos el primer CDROM del sistema
	if((cdrom = SDL_CDOpen(0))<0) {
		printf("No puedo abrir el dispositivo\n");
		exit(1);
	}

	// Status cd CD
	SDL_CDStatus(cdrom);

	// iniciamos la reproduccin de la primera pista del CD
	if ((SDL_CDPlay(cdrom, cdrom->track[pista].offset, cdrom->track[pista].length)) < 0) {
		printf("No puedo reproducir el CD\n");
		exit(1);
	}

	// esperamos a que cierren la aplicacin
	done = 0;
	while (!done) {
		if(SDL_PollEvent(&event)==0)
			if(event.type == SDL_QUIT) done=1;
	}

	// detenemos la reproduccin y cerramos el CDROM
	SDL_CDStop(cdrom);
	SDL_CDClose(cdrom);
	return(0);
}
