/***************************************************************************
 Ejemplo3_3
 (C) 2003 by Alberto Garcia Serrano
 Programacin de videojuegos con SDL
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <SDL.h>


int main(int argc, char *argv[]) {

 SDL_Surface *image, *screen;
 SDL_Rect dest;
 SDL_Event event;
 Sint16 joyx,joyy;
 SDL_Joystick *joystick;
 int done = 0;
 int x,y,button;

	atexit(SDL_Quit);

	// Iniciar SDL
	if (SDL_Init(SDL_INIT_VIDEO|SDL_INIT_JOYSTICK) < 0) {
		printf("No se pudo iniciar SDL: %s\n",SDL_GetError());
		exit(1);
	}

	// Activamos modo de video
	screen = SDL_SetVideoMode(640,480,24,SDL_HWSURFACE);
	if (screen == NULL) {
		printf("No se puede inicializar el modo grfico: \n",SDL_GetError());
		exit(1);
	}
	

	// Activa el Joystick
	if (SDL_NumJoysticks() >= 1) {
		joystick = SDL_JoystickOpen(0);
		SDL_JoystickEventState(SDL_ENABLE);
	}

	
	// Cargamos grfico
	image = SDL_LoadBMP("nave.bmp");
    if ( image == NULL ) {
        printf("No pude cargar grfico: %s\n", SDL_GetError());
        exit(1);
    }

	// Definimos color para la transparencia
	SDL_SetColorKey(image,SDL_SRCCOLORKEY|SDL_RLEACCEL,SDL_MapRGB(image->format,255,0,0));


	x = y = 100;
	button = 0;



	while(done == 0) {

		// Borramos la pantalla
		dest.x=0;
		dest.y=0;
		dest.w=640;
		dest.h=480;
		SDL_FillRect(screen,&dest,SDL_MapRGB(screen->format,0,0,0));

		// Definimos donde dibujaremos el grfico 
		// y lo copiamos a la pantalla.
		dest.x = x;
		dest.y = y;
		dest.w = image->w;
		dest.h = image->h;
		SDL_BlitSurface(image, NULL, screen, &dest);

		// Mostramos la pantalla
		SDL_Flip(screen);

		// lectura directa del joystick
		joyx = SDL_JoystickGetAxis(joystick, 0);
		joyy = SDL_JoystickGetAxis(joystick, 1);

		if (joyy < -10) {y-=5;}
		if (joyy > 10) {y+=5;}
		if (joyx < -10) {x-=5;}
		if (joyx > 10) {x+=5;}
		

		// Lectura de eventos
		while ( SDL_PollEvent(&event) ) {
			
			// salir del programa si se pulsa el boton del joystick
			if ( event.type == SDL_JOYBUTTONDOWN) {
				done = 1;
			}
			
			// salir del programa si se pulsa una tecla 
			// o se cierra la ventana
			if ( event.type == SDL_KEYDOWN || event.type == SDL_QUIT) 
				done = 1;
		}
    }

	// liberar superficie
    SDL_FreeSurface(image);

	// cerramos el joystick
	if (SDL_JoystickOpened(0)) {
		SDL_JoystickClose(joystick);
	}

	return 0;
}