/***************************************************************************
 - 1945 -
 (C) 2003 by Alberto Garcia Serrano
 Programacin de videojuegos con SDL
 ***************************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <SDL.h>
#include "SDL_mixer.h"
#include "SDL_ttf.h"
#include "csprite.h"


// mapa

#define MAXTILES 10
#define MAXMAP 400

char mapa[401];

SDL_Surface *screen;
SDL_Rect rect;
CFrame fnave;
CFrame fmalo1_1;
CFrame fmalo1_2;
CFrame fmalo1_3;
CFrame fmalo1_4;
CFrame fmalo1_5;
CFrame fmalo2;
CFrame fmalo3;
CFrame bala;
CFrame ex1;
CFrame ex2;
CFrame ex3;
CFrame ex4;
CFrame ex5;
CFrame ex6;
CFrame ex7;
CFrame dis;
CFrame dis2;
CFrame vida;
CFrame pant;
CFrame frsuelo[MAXTILES];
CFrame flevel;
CSprite slevel(1);
CSprite suelo[MAXTILES];
CSprite pantalla(1);
CSprite explode(12);
CSprite nave(1);
CSprite malo2(1);
CSprite malo3(1);
CSprite malo1(5);
CSprite mibala(1);
CSprite dispene(2);
CSprite life(1);
int ciclos,leveltime;
int indice, indice_in;
int nexplosiones=7,nmalos=6,nbalas=6,ndispenemigos=7,mibalax[7],mibalay[7];
int done=0,estado=0, conjefe=0, level=1, score=0;
Uint32 ini_milisegundos, fin_milisegundos, frametime;
Sint16 joyx,joyy;
Mix_Music *musica;
Mix_Chunk *explosion,*disparo;
SDL_Joystick *joystick;
TTF_Font *fuente;
SDL_Surface *ttext;
SDL_Color bgcolor,fgcolor;
SDL_Rect rectangulo;
FILE *f;

struct minave {
	int activo,x,y,vidas,time;
} jugador;

struct naveenemiga {
	int activo,x,y,dx,dy,tipo,estado,impactos,nframe;		
} enemigo[7];

struct explosion {
	int activo,x,y,nframe;
} exp[8];

struct disparo {
	int activo,x,y,dx,dy,estado,time;
} disp[8];



int dx=2,dy=2;

void creaexplosion(int);
void creadispenemigo(int);
void ResetTimeBase(void);
void creajefe(void);
void LoadLevel(int);
int CurrentTime(void);


void DrawScene(SDL_Surface *screen) {
int i,j,t,x,y;
char msg[30];

	// movimiento del scenario (scroll)
	indice_in+=2;
	if (indice_in>=64) {
		indice_in=0;
		indice-=10;
	}
	
	if (indice <= 0) {
		indice=MAXMAP-100; // si llegamos al final, empezamos de nuevo.
		indice_in=0;
	}

	//dibujar escenario
	for (i=0 ; i<10 ; i++) {
		for (j=0 ; j<10 ; j++) {
			t=mapa[indice+(i*10+j)];
			// calculo de la posicin del tile
			x=j*64;
			y=(i-1)*64+indice_in;
			
			// dibujamos el tile
			suelo[t].setx(x);
			suelo[t].sety(y);
			suelo[t].draw(screen);
		}
	}


	// Dibuja nave	
	if (jugador.activo==1) {
		nave.setx(jugador.x);
		nave.sety(jugador.y);
		nave.draw(screen);
	}

	if (jugador.activo==2 && jugador.time%2==0) {
		nave.setx(jugador.x);
		nave.sety(jugador.y);
		nave.draw(screen);
	}


	// Dibuja enemigo
	for (i=0 ; i<=nmalos ; i++) {
		if (enemigo[i].activo==1) {
			if (enemigo[i].tipo==0) {
				malo1.setx(enemigo[i].x);
				malo1.sety(enemigo[i].y);
				malo1.selframe(enemigo[i].nframe);
				malo1.draw(screen);
				// ha colisionado con la nave?
				if (malo1.colision(nave) == TRUE && jugador.activo==1) {
					jugador.vidas--;
					creaexplosion(255);
					jugador.time=30;
					jugador.activo=0;
				}

			}
		
			if (enemigo[i].tipo==1) {
				malo2.setx(enemigo[i].x);
				malo2.sety(enemigo[i].y);
				malo2.draw(screen);
				// ha colisionado con la nave?
				if (malo2.colision(nave) == TRUE && jugador.activo==1) {
					jugador.vidas--;
					creaexplosion(255);
					jugador.time=30;
					jugador.activo=0;					
				}

			}

			if (enemigo[i].tipo==3) {
				malo3.setx(enemigo[i].x);
				malo3.sety(enemigo[i].y);
				malo3.draw(screen);
				// ha colisionado con la nave?
				if (malo3.colision(nave) == TRUE && jugador.activo==1) {
					jugador.vidas--;
					creaexplosion(255);
					jugador.time=30;
					jugador.activo=0;					
				}			
			}

		}
	}


	// Dibujamos las explosiones
	for (i=0 ; i<=nexplosiones; i++) {
		if (exp[i].activo==1) {
			explode.selframe(exp[i].nframe);
			explode.setx(exp[i].x);
			explode.sety(exp[i].y);
			explode.draw(screen);
			exp[i].nframe=exp[i].nframe+1;
			if (exp[i].nframe>=7) {
				exp[i].activo=0;
			}
		}
	}
	
	// Dibujamos los disparos
	for (i=0 ; i<=nbalas ; i++) {
		if (mibalax[i]) {
			mibala.setx(mibalax[i]);
			mibala.sety(mibalay[i]);
			mibala.draw(screen);
		
			// hay colisin con alguna nave?
			for (int j=0 ; j<=nmalos ; j++) {
				if (enemigo[j].activo==1) {


					switch (enemigo[j].tipo) {
					
					case 0: 
						// comprobamos impacto con nave tipo 0
						malo1.setx(enemigo[j].x);
						malo1.sety(enemigo[j].y);
						if (mibala.colision(malo1) == TRUE) {
							// Le hemos dado
							creaexplosion(j);
							enemigo[j].activo=0;
							mibalax[i]=0;
							score=score+10;
						}
						break;

					case 1:
						// comprobamos impacto con nave tipo 1
						malo2.setx(enemigo[j].x);
						malo2.sety(enemigo[j].y);
						if (mibala.colision(malo2)) {
							// Le hemos dado
							creaexplosion(j);
							enemigo[j].activo=0;
							mibalax[i]=0;
							score=score+10;
						}
						break;

					case 3:
						// comprobamos impacto con nave tipo 3
						malo3.setx(enemigo[j].x);
						malo3.sety(enemigo[j].y);
						if (mibala.colision(malo3)) {
							// Le hemos dado
							enemigo[j].impactos++;
							mibalax[i]=0;
							// 100 impactos para destruir al jefe
							if (enemigo[j].impactos >=100 ) {  
								creaexplosion(j);
								enemigo[j].activo=0;
								score=score+100;
								conjefe=2;		// el jefe ha muerto
								leveltime=100;	// tiempo hasta el cambio de nivel
								level++;
							}
						}
						break;

					}

				}
			}


		}
	}


	// Dibujamos los disparos enemigos
	for (i=0 ; i<=ndispenemigos ; i++) {
		if (disp[i].activo==1) {
			dispene.setx(disp[i].x);
			dispene.sety(disp[i].y);
			// parpadeo del disparo cada 5 ciclos
			disp[i].time++;
			if (disp[i].time>=5) {
				disp[i].time=0;
				if (disp[i].estado==0) {
					dispene.selframe(1);
					disp[i].estado=1;
				} else {
					dispene.selframe(0);
					disp[i].estado=0;
				}
			}
			dispene.draw(screen);

			// nos han dado?
			if (dispene.colision(nave) && jugador.activo==1) {
				jugador.vidas--;
				creaexplosion(255);
				jugador.time=30;
				jugador.activo=0;
			}
		}
	}

	// Dibuja las vidas del jugador
	for (i=1 ; i<=jugador.vidas ; i++) {
		life.setx(10+(i*22));
		life.sety(5);
		life.draw(screen);
	}

	// dibuja la puntuacin
	sprintf(msg,"%d",score);
	ttext = TTF_RenderText_Shaded(fuente,msg,fgcolor,bgcolor);
	rectangulo.y=5;
	rectangulo.x=530;
	rectangulo.w=ttext->w;
	rectangulo.h=ttext->h;
	SDL_SetColorKey(ttext,SDL_SRCCOLORKEY|SDL_RLEACCEL, SDL_MapRGB(ttext->format,255,0,0));
	SDL_BlitSurface(ttext,NULL,screen,&rectangulo);

	// Muestra el nivel en el que estamos jugando
	if ((leveltime>=1) && leveltime--%2) {
		sprintf(msg,"Level %d",level);
		ttext = TTF_RenderText_Shaded(fuente,msg,fgcolor,bgcolor);
		rectangulo.y=240;
		rectangulo.x=310;
		rectangulo.w=ttext->w;
		rectangulo.h=ttext->h;
		SDL_SetColorKey(ttext,SDL_SRCCOLORKEY|SDL_RLEACCEL, SDL_MapRGB(ttext->format,255,0,0));
		SDL_BlitSurface(ttext,NULL,screen,&rectangulo);
	}


	// Mostramos todo el frame
	SDL_Flip(screen);
}


void muevenaves() {

int i;

	// Esperamos a que el jugador est preparado para seguir jugando
	// despues de perder una vida.
	if (jugador.activo==2) {
		jugador.time--;
		if (jugador.time<=0) {
			jugador.time=0;
			jugador.activo=1;
		}
	}

	
	// decrementamos el contador de tiempo de nuestra nave en el caso
	// de haber sido destruidos. Si el tiempo ha pasado, el jugador continua.
	if (jugador.activo==0) {
		jugador.time--;

		if (jugador.time<=0) {
			jugador.time=50;
			if (jugador.vidas==0)
				estado=0;
			
			jugador.activo=2;
			jugador.x=320;
			jugador.y=400;
		}
	}


	// Actualizamos la posicin de las balas
	for (i=0 ; i<=nbalas ; i++) {
		if (mibalax[i]) {
			mibalay[i]=(mibalay[i])-10;
			
			// ha salido la bala de la pantalla?
			if (mibalay[i]<=10) {
				mibalax[i]=mibalay[i]=0;
			}

		}		
	}



	// Animacin (interna) de los sprites
	for (i=0 ; i<=nmalos ; i++) {
		if (enemigo[i].activo == 1) {
			
			// Animacin del enemigo tipo 0 (loop)
			if (enemigo[i].tipo == 0 && enemigo[i].estado == 1) {
				if (enemigo[i].nframe < malo1.frames()) 
					enemigo[i].nframe++;
			}
		}
	}



	// Movimiento de los enemigos
	for (i=0 ; i<=nmalos ; i++) {
		if (enemigo[i].activo == 1) {
			enemigo[i].x=enemigo[i].x+enemigo[i].dx;
			enemigo[i].y=enemigo[i].y+enemigo[i].dy;
			
			// Movimiento enemigo tipo 0
			if (enemigo[i].tipo == 0) {
				
				if (enemigo[i].estado==0 && enemigo[i].y>240) {
					creadispenemigo(i);
					enemigo[i].dy=-3;
					enemigo[i].dx=0;
					enemigo[i].estado=1;
				}

			}

			// Movimiento del jefe
			if (enemigo[i].tipo == 3) {
				// reglas para el movimiento lateral.
				if (enemigo[i].x>500) enemigo[i].dx=-3;
				if (enemigo[i].x<20) enemigo[i].dx=3;
			
				// un disparo cada 30 ciclos
				if (!(ciclos%30)) {
					creadispenemigo(i);
				}

			}


			// sali la nave de la pantalla?
			if (enemigo[i].y>480 || enemigo[i].y<-50)
				enemigo[i].activo=0;
		}
	}



	// Movimiento de las balas enemigas
	for (i=0 ; i<=ndispenemigos ; i++) {
		if (disp[i].activo==1) {
			disp[i].x=disp[i].x+disp[i].dx;
			disp[i].y=disp[i].y+disp[i].dy;

			// ha salido de la pantalla?
			if (disp[i].y>480)
					disp[i].activo=0;
		}
	}

}


void creadisparo() {

	int libre=-1;

	// Hay alguna bala libre?
	for (int i=0 ; i<=nbalas ; i++) {
		if (mibalax[i]==0)
			libre=i;
	}

	// Hay una bala
	if (libre>=0) {
		mibalax[libre]=nave.getx();
		mibalay[libre]=nave.gety()-15;
	}

	// sonido del disparo
	Mix_PlayChannel(-1,disparo,0);
}



void creaenemigo() {
	int libre=-1;

	// Hay algn enemigo libre?
	for (int i=0 ; i<=nmalos ; i++) {
		if (enemigo[i].activo==0)
			libre=i;
	}

	// Hay un enemigo dispuesto
	if (libre>=0) {
		enemigo[libre].activo=1;
		enemigo[libre].nframe=0;
		enemigo[libre].x=rand();	// Pos.X aleatoria
		if (enemigo[libre].x > 640)
			enemigo[libre].x=(int)enemigo[libre].x % 640;
		enemigo[libre].tipo=rand();	// tipo de enemigo aleatorio
		if (enemigo[libre].tipo >= 2)
			enemigo[libre].tipo=(int)enemigo[libre].tipo % 2; // 2 tipos de enemigos (0,1)
		
		// tipo caza
		if (enemigo[libre].tipo==0) {
			enemigo[libre].y=-30;
			enemigo[libre].dx=0;
			enemigo[libre].dy=5;
			enemigo[libre].estado=0;
		}
		
		// tipo kamikaze
		if (enemigo[libre].tipo==1) {
			enemigo[libre].y=-30;
			if (enemigo[libre].x>nave.getx()) {
				enemigo[libre].dx=-3;
			} else {
				enemigo[libre].dx=3;
			}
			enemigo[libre].dy=5;
			enemigo[libre].estado=0;
		}

	}
}



void creajefe() {
	int libre=1;

	enemigo[libre].activo=1;
	enemigo[libre].tipo=3;
	enemigo[libre].y=100;
	if (enemigo[libre].x>nave.getx()) {
		enemigo[libre].dx=-3;
	} else {
		enemigo[libre].dx=3;
	}
	enemigo[libre].dy=0;
	enemigo[libre].estado=0;
	enemigo[libre].impactos=0;

}



void creaexplosion(int j) {
		
	int libre=-1;

	for(int i=0; i<=nexplosiones; i++) {
		if (exp[i].activo==0)
			libre=i;
	}

	if (libre>=0) {
		if (j!=255) { // si j = 255 la explosin es para el jugador
			exp[libre].activo=1;
			exp[libre].nframe=1;
			exp[libre].x=enemigo[j].x;
			exp[libre].y=enemigo[j].y;
		} else {
			exp[libre].activo=1;
			exp[libre].nframe=1;
			exp[libre].x=jugador.x;
			exp[libre].y=jugador.y;		
		}
	}

	// sonido de explosion
	Mix_PlayChannel(-1,explosion,0);
}


void creadispenemigo(int j) {
	int libre=-1;

	for(int i=0; i<=ndispenemigos; i++) {
		if (disp[i].activo==0)
			libre=i;
	}

	if (libre>=0) {
		disp[libre].activo=1;
		if (enemigo[j].x>nave.getx()) {
			disp[libre].dx=-3;
		} else {
			disp[libre].dx=3;
		}
		disp[libre].dy=3;
		disp[libre].x=enemigo[j].x+30;
		disp[libre].y=enemigo[j].y+20;
		disp[libre].estado=0;
		disp[libre].time=0;
	}
}


void InitEstados() {

int i;

	jugador.activo=1;
	jugador.vidas=3;
	jugador.x=320;
	jugador.y=400;

	// Inicializamos el array de balas
	for (i=0 ; i<=nbalas ; i++) {
		mibalax[i]=0;
		mibalay[i]=0;
	}

	// Inicializamos el array de enemigos
	for (i=0 ; i<=nmalos ; i++) {
		enemigo[i].activo=0;
	}

	// Inicializamos el array de explosiones
	for (i=0; i<=nexplosiones ; i++) {
		exp[i].activo=0;
	}

	// Inicializamos el array de disparos enemigos
	for(i=0; i<=ndispenemigos; i++) {
		disp[i].activo=0;
	}

	// inicializa colores para el texto
	fgcolor.r=200;
	fgcolor.g=200;
	fgcolor.b=10;

	bgcolor.r=255;
	bgcolor.g=0;
	bgcolor.b=0;

	// Posicin inicial en el mapa
	indice=MAXMAP-100;
	indice_in=0;

	ciclos=0;
	conjefe=0;
}



void LoadLevel(int l) {

	InitEstados(); 

	leveltime=100;

	// Cargar mapa (10x40)
	char tmplevel[50];
	int i, c, ntiles;

	sprintf(tmplevel,"levels/level%d/map.map",l);
	if((f=fopen(tmplevel,"r")) != NULL) {
		c=fread(mapa,MAXMAP,1,f);
		fclose(f);
	}

	// Cargar tiles del suelo
	sprintf(tmplevel,"levels/level%d/level.dsc",l);
	if((f=fopen(tmplevel,"r")) != NULL) {
		fgets(tmplevel,255,f);
		ntiles=atoi(tmplevel);
		fclose(f);
	}
	
	for (i=0 ; i<=ntiles ; i++) {
		sprintf(tmplevel,"levels/level%d/tile%d.bmp",l,i);
		frsuelo[i].load(tmplevel);
		suelo[i].addframe(frsuelo[i]);

	}


}




void inicializa() {
	// carga la funte de letra
	fuente = TTF_OpenFont("ariblk.ttf",20);
		
	// Activa el Joystick
	if (SDL_NumJoysticks() >= 1) {
		joystick = SDL_JoystickOpen(0);
		SDL_JoystickEventState(SDL_ENABLE);
	}
	
	// carga la musica y los sonidos
	musica = Mix_LoadMUS("sounds/rwvalkyr.mid");
	explosion = Mix_LoadWAV("sounds/explosion.wav");
	disparo = Mix_LoadWAV("sounds/disparo.wav");
}




void finaliza() {

	// destruimos la fuente de letra
	TTF_CloseFont(fuente);

	// destrimos la musica
	Mix_FreeMusic(musica);

	// cerramos el joystick
	if (SDL_JoystickOpened(0)) {
		SDL_JoystickClose(joystick);
	}

}



int InitSprites() {

int i;

	// Inicializamos el generador de nmeros aleatorios
	srand( (unsigned)time( NULL ) );
	
	// Inicializamos el array de balas
	for (i=0 ; i<=nbalas ; i++) {
		mibalax[i]=0;
		mibalay[i]=0;
	}


	// Inicializamos el array de enemigos
	for (i=0 ; i<=nmalos ; i++) {
		enemigo[i].activo=0;
	}

	// Inicializamos el array de explosiones
	for (i=0; i<=nexplosiones ; i++) {
		exp[i].activo=0;
	}


	pant.load("pics/pantalla.bmp");
	pantalla.addframe(pant);

	ex1.load("pics/explode1.bmp");
	explode.addframe(ex1);

	ex2.load("pics/explode2.bmp");
	explode.addframe(ex2);

	ex3.load("pics/explode3.bmp");
	explode.addframe(ex3);

	ex4.load("pics/explode4.bmp");
	explode.addframe(ex4);

	ex5.load("pics/explode5.bmp");
	explode.addframe(ex5);

	ex6.load("pics/explode6.bmp");
	explode.addframe(ex6);

	ex7.load("pics/explode7.bmp");
	explode.addframe(ex7);

	dis.load("pics/dispene.bmp");
	dispene.addframe(dis);

	dis2.load("pics/dispene2.bmp");
	dispene.addframe(dis2);

	fnave.load("pics/minave.bmp");
	nave.addframe(fnave);

	fmalo1_1.load("pics/enemy1_1.bmp");
	malo1.addframe(fmalo1_1);

	fmalo1_2.load("pics/enemy1_2.bmp");
	malo1.addframe(fmalo1_2);

	fmalo1_3.load("pics/enemy1_3.bmp");
	malo1.addframe(fmalo1_3);
	
	fmalo1_4.load("pics/enemy1_4.bmp");
	malo1.addframe(fmalo1_4);

	fmalo1_5.load("pics/enemy1_5.bmp");
	malo1.addframe(fmalo1_5);

	fmalo2.load("pics/nave2.bmp");
	malo2.addframe(fmalo2);

	fmalo3.load("pics/gordo.bmp");
	malo3.addframe(fmalo3);
	
	bala.load("pics/balas.bmp");
	mibala.addframe(bala);

	vida.load("pics/life.bmp");
	life.addframe(vida);

	return 0;

}



void ResetTimeBase() {

	ini_milisegundos=SDL_GetTicks();
}


int CurrentTime() {

	fin_milisegundos=SDL_GetTicks();
	return fin_milisegundos-ini_milisegundos;
}




int main(int argc, char *argv[]) {

SDL_Event event;
Uint8 *keys;
int salir=0;

	if (SDL_Init(SDL_INIT_VIDEO|SDL_INIT_AUDIO|SDL_INIT_JOYSTICK) < 0) {
		printf("No se pudo iniciar SDL: %s\n",SDL_GetError());
		return 1;
	}

	screen = SDL_SetVideoMode(640,480,24,SDL_HWSURFACE);
	if (screen == NULL) {
		printf("No se puede inicializar el modo grfico: \n",SDL_GetError());
		return 1;
	}

	atexit(SDL_Quit);

	if (Mix_OpenAudio(MIX_DEFAULT_FREQUENCY,MIX_DEFAULT_FORMAT,1,4096) < 0) {
		printf("No se pudo iniciar SDL_Mixer: %s\n",Mix_GetError());
		return 1;
	}

	atexit(Mix_CloseAudio);

	if (TTF_Init() < 0) {
		printf("No se pudo iniciar SDL_ttf: %s\n",SDL_GetError());
		return 1;
	}

	atexit(TTF_Quit);

	inicializa(); 
	InitSprites();

	while (done == 0) {
		
		switch (estado) {

		case 0:

			InitEstados();
			pantalla.setx(0);
			pantalla.sety(0);
			pantalla.draw(screen);

			SDL_Flip(screen);

			// desactivamos la msica (si estaba activada)
			Mix_HaltMusic();

			while (estado==0 && done==0) {

				while (SDL_PollEvent(&event)) {
					
					if (event.type == SDL_QUIT) {done=1;}
					
					if (event.type == SDL_KEYDOWN || event.type == SDL_JOYBUTTONDOWN) {
						
						if (event.key.keysym.sym == SDLK_ESCAPE) {
							done=1;
						} else {
							score=0;
							estado=1;

							LoadLevel(1);

							// Activamos la msica
							Mix_PlayMusic(musica,-1);

						}
					
					}
									
				}
			}

			break;

		case 1:

			// Inicializamos el timer para control de tiempo.
			ResetTimeBase();

			ciclos++;

			// cada 20 ciclos se crea un enemigo
			if ((!(ciclos % 20)) && conjefe==0) {
				creaenemigo();
			}

			// final de fase?
			if (ciclos>=5000 && conjefe==0) {
				// creamos la nave jefe.
				creajefe();
				conjefe=1;
			}


			// tiempo desde que se destruye al jefe
			// hasta que cambiamos de nivel.
			if ((conjefe == 2) && (leveltime-- <= 0)) {
				if (level>2) level=1;
				LoadLevel(level);
			}

			muevenaves();
			DrawScene(screen);

			// vida extra?
			if (score % 2000 == 0 && score > 0) {
				score+=10;
				jugador.vidas++;
			}


			// consultamos el estado del teclado
			keys=SDL_GetKeyState(NULL);

			// consultamos el estado del joystick
			SDL_JoystickUpdate();
			
			joyx = SDL_JoystickGetAxis(joystick, 0);
			joyy = SDL_JoystickGetAxis(joystick, 1);

			if ((keys[SDLK_UP] || joyy < -10) && (jugador.y > 0)) {jugador.y=jugador.y-(5);}
			if ((keys[SDLK_DOWN] || joyy > 10) && (jugador.y < 460)) {jugador.y=jugador.y+(5);}
			if ((keys[SDLK_LEFT] || joyx < -10) && (jugador.x > 0)) {jugador.x=jugador.x-(5);}
			if ((keys[SDLK_RIGHT] || joyx > 10) && (jugador.x < 620)) {jugador.x=jugador.x+(5);}
			if (keys[SDLK_LSHIFT] && jugador.activo!=0) {creadisparo();}


			while (SDL_PollEvent(&event)) {
				
				// evento del boton del joystick
				if (event.type ==SDL_JOYBUTTONDOWN && jugador.activo != 0) {
					creadisparo();
				}

				// evento de cierre del programa
				if (event.type == SDL_QUIT) {done=0;}
				
				// evento pulsacin de tecla
				if (event.type == SDL_KEYDOWN) {
					
					if (event.key.keysym.sym == SDLK_ESCAPE) {estado=0;}
	
				}
								
			}

			// Esperamos a que transcurran al menos 30 ms para
			// generar el siguiente frame, y evitar as
			// que el juego se acelere en mquinas muy rpidas.

			do {
				frametime=CurrentTime();	
			} while (frametime<30);
				
			break;
		}
	}

	finaliza();

	return 0;
}