-- inserir_servei(id_cambrer,id_taula): ha d'inserir un registre en la taula servei, amb la data del sistema. El preu es deixa NULL (es calcularà a posteriori). El valor id_servei s'agafa a partir de la seqüència corresponent. És el procediment que s'executa quan el cambrer comença a prendre nota a una taula.
-- inserir_detall_servei(id_servei,id_plat,quantitat): insereix un registre en la taula DETALL_SERVEI. És el procediment que s'executa quan el cambrer pren nota de què menjaran els comensals.
-- calcular_servei(id_servei): s'executa quan hem de generar el ticket, per saber quan ha de pagar la taula pel servei. S'ha de fer un UPDATE de SERVEI.preu
-- mostra_servei(id_servei): mostrar tots els plats que s'han de servir a la taula (de l'últim servei que s'ha demanat en aquesta taula)
-- resum_cambrer(id_cambrer,dia): mostrar un informe de tots els serveis que ha fet un cambrer en un dia. Informar de què ha facturat a cada servei, i el total del dia.
-- informe_mensual(mes,any): per al mes indicat, fer un informe del que han facturat tots els cambrers, ordenats de major a menor. 


CREATE OR REPLACE FUNCTION inserir_servei(v_id_cambrer integer, v_id_taula integer) RETURNS integer AS $$
DECLARE
   vid_cambrer CAMBRER.id_cambrer%TYPE;
   vid_taula TAULA.id_taula%TYPE;
	vid_servei SERVEI.id_servei%TYPE;
BEGIN
   SELECT id_cambrer into vid_cambrer FROM CAMBRER WHERE id_cambrer=v_id_cambrer;
   SELECT id_taula into vid_taula FROM TAULA WHERE id_taula=v_id_taula;
   INSERT INTO SERVEI VALUES(nextval('seq_servei'),v_id_cambrer,v_id_taula,now(),NULL);
   SELECT currval('seq_servei') INTO vid_servei;
	RETURN vid_servei;
END;
$$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION inserir_detall_servei(v_id_servei integer, v_id_plat integer,v_quantitat integer) RETURNS VOID AS $$
DECLARE
   vid_servei SERVEI.id_servei%TYPE;
   vid_plat CARTA.id_plat%TYPE;
   vquantitat DETALL_SERVEI.quantitat%TYPE;
BEGIN
   IF (v_quantitat<1) THEN 
      raise exception 'quantitat negativa';
   END IF;
   SELECT id_servei into vid_servei FROM SERVEI WHERE id_servei=v_id_servei;
	IF NOT FOUND THEN
		raise exception 'servei no trobat';
	END IF;
   SELECT id_plat into vid_plat FROM CARTA WHERE id_plat=v_id_plat;
	IF NOT FOUND THEN
		raise exception 'plat no trobat';
	END IF;
   INSERT INTO DETALL_SERVEI VALUES(v_id_servei,v_id_plat,v_quantitat);
END;
$$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION calcular_servei(v_id_servei integer) RETURNS real AS $$
DECLARE
   vid_servei SERVEI.id_servei%TYPE;
   vtotal SERVEI.preu%TYPE;
BEGIN
   SELECT id_servei into vid_servei FROM SERVEI WHERE id_servei=v_id_servei;
	IF NOT FOUND THEN
		raise exception 'servei no trobat';
	END IF;
   SELECT SUM(preu*quantitat) into vtotal FROM DETALL_SERVEI DS, CARTA C WHERE DS.id_plat=C.id_plat GROUP BY id_servei having id_servei=v_id_servei;
   UPDATE SERVEI SET preu=vtotal WHERE id_servei=v_id_servei;
   RAISE NOTICE 'Total: %',vtotal;
   RETURN vtotal;
END;
$$ LANGUAGE plpgsql;



CREATE OR REPLACE FUNCTION mostra_servei(v_id_servei integer) RETURNS void AS $$
DECLARE
   vtotal SERVEI.preu%TYPE;
   c_plats CURSOR FOR SELECT plat,tipus,preu,quantitat FROM DETALL_SERVEI DS, CARTA C WHERE DS.id_plat=C.id_plat and id_servei=v_id_servei;
   vr_plats RECORD;
   cad varchar(1024);
BEGIN
   cad:='<table border="1"><tr><td>id_cambrer</td><td>nom</td><td>total</td></tr>';
   OPEN c_plats;

   FETCH c_plats INTO vr_plats;
   WHILE FOUND LOOP
      cad := cad || '<tr><td>' || vr_plats.plat|| '</td><td>' || vr_plats.preu || '</td><td>' || vr_plats.quantitat || '</td></tr>';
		-- RAISE NOTICE '%',cad;

      FETCH c_plats INTO vr_plats;
   END LOOP;
   cad := cad || '</table>';

   SELECT SUM(preu*quantitat) into vtotal FROM DETALL_SERVEI DS, CARTA C WHERE DS.id_plat=C.id_plat GROUP BY id_servei having id_servei=v_id_servei;
   cad := cad || '<b>Total:</b> '|| vtotal || ' euros';
	RAISE NOTICE '%',cad;
   RETURN;
END;
$$ LANGUAGE plpgsql;



CREATE OR REPLACE FUNCTION resum_cambrer(v_id_cambrer integer,dia char) RETURNS void AS $$
DECLARE
   c_cambrer CURSOR FOR SELECT C.id_cambrer,id_servei,nom,preu FROM CAMBRER C,SERVEI S WHERE C.id_cambrer=S.id_cambrer and c.id_cambrer=v_id_cambrer and to_char(dia_hora,'DD/MM/YYYY')=dia;
   vr_cambrer RECORD;
   cad varchar(1024);
BEGIN
   cad := '<table border="1"><tr><td>id_cambrer</td><td>id_servei</td><td>nom</td><td>preu</td></tr>';
   OPEN c_cambrer;
   FETCH c_cambrer INTO vr_cambrer;
   WHILE FOUND LOOP
	cad := cad || '<tr><td>' || vr_cambrer.id_cambrer || '</td><td>' || vr_cambrer.id_servei || '</td><td>' || vr_cambrer.nom || '</td><td>' || vr_cambrer.preu || '</td></tr>';
	FETCH c_cambrer INTO vr_cambrer;
   END LOOP;
   cad:= cad || '</table>';
   RAISE NOTICE '%',cad;
   RETURN;
END;
$$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION informe_mensual(v_mes integer,v_any integer) RETURNS void AS $$
DECLARE
   c_informe CURSOR FOR SELECT C.id_cambrer,nom,SUM(preu) as total FROM CAMBRER C, SERVEI S WHERE C.id_cambrer=S.id_cambrer and to_number(to_char(dia_hora,'MM'),'99')=v_mes and to_number(to_char(dia_hora,'YYYY'),'9999')=v_any GROUP BY C.id_cambrer,nom;
   vr_informe RECORD;
   cad varchar(1024);
BEGIN
   cad := '<table border="1"><tr><td>id_cambrer</td><td>nom</td><td>total</td></tr>';
   OPEN c_informe;
   FETCH c_informe INTO vr_informe;
   WHILE FOUND LOOP
      cad := cad || '<tr><td>' || vr_informe.id_cambrer || '</td><td>' || vr_informe.nom || '</td><td>' || vr_informe.total || '</td></tr>';
      FETCH c_informe INTO vr_informe;
   END LOOP;
   cad:= cad || '</table>';
   RAISE NOTICE '%',cad;
   RETURN;
END;
$$ LANGUAGE plpgsql;


REM *********** JOC DE PROVES ****************************

select inserir_servei(1,1);

REM substituir el primer argument pel id_servei actual
select inserir_detall_servei(1,1,1);
select inserir_detall_servei(1,2,2);
select inserir_detall_servei(1,4,2);
select inserir_detall_servei(1,5,1);
select inserir_detall_servei(1,11,3);
select inserir_detall_servei(1,15,1);
select inserir_detall_servei(1,16,1);
select inserir_detall_servei(1,17,1);
select inserir_detall_servei(1,19,1);
select inserir_detall_servei(1,20,1);


select calcular_servei(1);
select mostra_servei(1);

select inserir_servei(3,2);

select inserir_detall_servei(2,2,1);
select inserir_detall_servei(2,3,2);
select inserir_detall_servei(2,7,1);
select inserir_detall_servei(2,8,1);
select inserir_detall_servei(2,11,1);
select inserir_detall_servei(2,12,2);
select inserir_detall_servei(2,15,3);
select inserir_detall_servei(2,19,2);
select inserir_detall_servei(2,20,1);

select calcular_servei(2);
select mostra_servei(2);

select resum_cambrer(1,'30/10/2009');
select resum_cambrer(3,'30/10/2009');

select informe_mensual(10,2009);

