import 'ol/ol.css';
import Feature from 'ol/Feature';
import Map from 'ol/Map';
import Overlay from 'ol/Overlay';
import View from 'ol/View';
import Point from 'ol/geom/Point';
import {Tile as TileLayer, Vector as VectorLayer} from 'ol/layer';
import TileJSON from 'ol/source/TileJSON';
import VectorSource from 'ol/source/Vector';
import {Icon, Style} from 'ol/style';
import {fromLonLat} from 'ol/proj'; //necessari per fer la transformació de coordenades
import Stamen from 'ol/source/Stamen';

var iconFeature1 = new Feature({
  geometry: new Point(fromLonLat([-9.0335,38.6308])), //longitud,latitud
  name: 'Lisboa',
  country: 'Portugal'
});

var iconFeature2 = new Feature({
  geometry: new Point(fromLonLat([12.5611,52.3198])),
  name: 'Berlín',
  country: 'Alemanya'
});

var iconFeature3 = new Feature({
  geometry: new Point(fromLonLat([36.7779,-1.3008])),
  name: 'Nairobi',
  country: 'Kènia'
});

var iconFeature4 = new Feature({
  geometry: new Point(fromLonLat([131.357,38.061])),
  name: 'Tokio',
  country: 'Japó'
});

var iconFeature5 = new Feature({
  geometry: new Point(fromLonLat([-43.4491,-22.8814])),
  name: 'Rio',
  country: 'Brasil'
});

var iconFeature6 = new Feature({
  geometry: new Point(fromLonLat([32.893,54.706])),
  name: 'Moscú',
  country: 'Rússia'
});

var iconFeature7 = new Feature({
  geometry: new Point(fromLonLat([12.055,59.908])),
  name: 'Oslo',
  country: 'Noruega'
});

var iconFeature8 = new Feature({
  geometry: new Point(fromLonLat([-110.119,39.409])),
  name: 'Denver',
  country: 'U.S.A'
});

var iconFeature9 = new Feature({
  geometry: new Point(fromLonLat([23.703,61.204])),
  name: 'Helsinki',
  country: 'Finlàndia'
});

var iconFeature10 = new Feature({
  geometry: new Point(fromLonLat([17.022,59.832])),
  name: 'Estocolmo',
  country: 'Suècia'
});

var iconFeature11 = new Feature({
  geometry: new Point(fromLonLat([5.234,43.670])),
  name: 'Marsella',
  country: 'França'
});

var iconFeature12 = new Feature({
  geometry: new Point(fromLonLat([-73.136,4.963])),
  name: 'Bogotá',
  country: 'Colòmbia'
});

var iconFeatures = [iconFeature1,iconFeature2,iconFeature3,iconFeature4,iconFeature5,iconFeature6,iconFeature7,iconFeature8,iconFeature9,iconFeature10,iconFeature11,iconFeature12]

var iconStyle = new Style({
  image: new Icon({
    anchor: [0.5,20],
    anchorXUnits: 'fraction',
    anchorYUnits: 'pixels',
    src: 'data/icon_cp_25.png'
  })
});

for (let i=0; i<iconFeatures.length;i++) {
  iconFeatures[i].setStyle(iconStyle);
}

var vectorSource = new VectorSource({
  features: iconFeatures
});


var vectorLayer = new VectorLayer({
  source: vectorSource
});

var map = new Map({
  layers: [
    new TileLayer({
      source: new Stamen({
        layer: 'toner'
      })
    }),
    vectorLayer
  ],
  target: 'map',
  view: new View({
    center: fromLonLat([-9.0335,38.6308]),
    zoom: 1
  })
});


var element = document.getElementById('popup');

var popup = new Overlay({
  element: element,
  positioning: 'bottom-center',
  stopEvent: false,
  offset: [0, -30]
});
map.addOverlay(popup);


// display popup on click
map.on('click', function(evt) {
  //alert(evt.pixel)
  var feature = map.forEachFeatureAtPixel(evt.pixel,
    function(feature) {
      return feature;
    });
  if (feature) {
    var coordinates = feature.getGeometry().getCoordinates();

    //alert(feature.get('name'))
    switch(feature.get('name')) {
      case 'Lisboa':
        var win1 = window.open("https://ca.wikipedia.org/wiki/Lisboa", '_blank');
        var win2 = window.open("https://la-casa-de-papel.fandom.com/es/wiki/Raquel_Murillo", '_blank');
        break;
      case 'Berlín':
        var win1 = window.open("https://ca.wikipedia.org/wiki/Berlín", '_blank');
        var win2 = window.open("https://la-casa-de-papel.fandom.com/es/wiki/Berl%C3%ADn", '_blank');
        break;
      case 'Toquio':
        var win1 = window.open("https://la-casa-de-papel.fandom.com/es/wiki/Tokio", '_blank');
        var win2 = window.open("https://ca.wikipedia.org/wiki/T%C3%B2quio", '_blank');
        break;
      case 'Rio':
        var win1 = window.open("https://ca.wikipedia.org/wiki/Rio_de_Janeiro", '_blank');
        var win2 = window.open("https://la-casa-de-papel.fandom.com/es/wiki/R%C3%ADo", '_blank');
        break;
      case 'Moscú':
        var win1 = window.open("https://ca.wikipedia.org/wiki/Moscú", '_blank');
        var win2 = window.open("https://la-casa-de-papel.fandom.com/es/wiki/Mosc%C3%BA", '_blank');
        break;
      case 'Nairobi':
        var win1 = window.open("https://ca.wikipedia.org/wiki/Nairobi", '_blank');
        var win2 = window.open("https://la-casa-de-papel.fandom.com/es/wiki/Nairobi", '_blank');
        break;
      case 'Oslo':
        var win1 = window.open("https://ca.wikipedia.org/wiki/Oslo", '_blank');
        var win2 = window.open("https://la-casa-de-papel.fandom.com/es/wiki/Oslo", '_blank');
        break;
      case 'Denver':
        var win1 = window.open("https://ca.wikipedia.org/wiki/Denver", '_blank');
        var win2 = window.open("https://la-casa-de-papel.fandom.com/es/wiki/Denver", '_blank');
        break;
      case 'Helsinki':
        var win1 = window.open("https://ca.wikipedia.org/wiki/Hèlsinki", '_blank');
        var win2 = window.open("https://la-casa-de-papel.fandom.com/es/wiki/Helsinki", '_blank');
        break;
      case 'Estocolmo':
        var win1 = window.open("https://ca.wikipedia.org/wiki/Estocolm", '_blank');
        var win2 = window.open("https://la-casa-de-papel.fandom.com/es/wiki/M%C3%B3nica_Gaztambide", '_blank');
        break;
      default:
        var win1 = window.open("https://ca.wikipedia.org/wiki/La_casa_de_papel", '_blank');
    }

  }
});

// display popup on click
map.on('pointermove', function(evt) {
  var feature = map.forEachFeatureAtPixel(evt.pixel,
    function(feature) {
      return feature;
    });
  if (feature) {
    var coordinates = feature.getGeometry().getCoordinates();
    popup.setPosition(coordinates);
    $(element).popover({
      placement: 'top',
      html: true,
      content: "<b>" + feature.get('name') + "</b><br />" + feature.get('country')
    });
    $(element).popover('show');
  } else {
    $(element).popover('destroy');
  }
});
var iconFeature2 = new Feature({
  geometry: new Point(fromLonLat([12.5611,52.3198])),
  name: 'Berlin',
  country: 'Alemanya'
});