//sorry, comments and variable names are still in Catalan, but I think the code is self-explanatory
//joanillo_arcade_frontend: frontend per a l'emulardor mame4all (emulador arcade), pensat per al projecte PiMAME / PiPlay que funciona en la Raspberry Pi. L'aplicatiu s'ha de compilar en la Raspberry Pi.
// g++ -o joanillo_arcade_frontend joanillo_arcade_frontend-1.0.0.cpp `sdl-config  --cflags --libs` -lSDL_image -lSDL_ttf -lSDL_gfx

#include <iostream>
#include <string>
#include <fstream> //library for input and output
//http://stackoverflow.com/questions/3749660/how-to-resize-array-in-c
#include <vector> //les matrius no es poden redimensionar dinàmicament a C++. Per això serveixen els vectors
#include <sstream> 
#include <ctime>

#include <SDL.h>
#include <SDL_image.h>
#include "SDL_ttf.h"
#include "SDL_rotozoom.h"

#define SCREEN_WIDTH 1024 //valor per defecte, abans d'avariguar la resolució de la pantalla
#define SCREEN_HEIGHT 768
#define DEPTH 16


// Configuració laptop
#define PAGINACIO 13
#define LLISTA_ROMS_X 50
#define LLISTA_ROMS_Y 180
#define CAPCALERA1_Y 50
#define CAPCALERA1_W 800
#define CAPCALERA1_H 60
#define CAPCALERA2_Y 100
#define CAPCALERA2_W 800
#define LOGO_Y 750
#define PEU_X 150
#define LLISTA_ROMS_W 250
#define LLISTA_ROMS_H 40
#define ROMPNG_WH 500
#define ROMPNG_X 300
#define WAIT_TIME 120 //2 minuts
#define MAME_PATH "/usr/games/mame"

/*
// Configuració RPi (Bartop)
#define PAGINACIO 11
#define LLISTA_ROMS_X 20
#define LLISTA_ROMS_Y 180
#define CAPCALERA1_Y 50
#define CAPCALERA1_W 800
#define CAPCALERA1_H 60
#define CAPCALERA2_Y 100
#define CAPCALERA2_W 800
#define LOGO_Y 650
#define PEU_X 120
#define LLISTA_ROMS_W 250
#define LLISTA_ROMS_H 40
#define ROMPNG_WH 450
#define ROMPNG_X 270
#define WAIT_TIME 120 //2 minuts
#define MAME_PATH "/home/pi/emulators/mame4all-pi/mame"
*/

using namespace std;

void actualitzar_llista ();
void actualitzar_llista2 ();
void canvi_fav_cat ();
void carregar_subcapcalera_rompng ();

int inicialitzarSDL();
void handleKey(SDL_KeyboardEvent key);

void resizeImage( SDL_Surface*& img, const double newwidth, const double newheight );

vector<string> vector_roms_global[4];
vector<string> vector_roms;
vector<string> vector_roms_total;
int rom_actual;
int rom_pag_actual;

string favorit[6] = { "All favourites", "Bad", "Good", "Very good", "Prefered", "Undefined"};
string categoria[15] = { "All categories", "Adventure", "Application", "Breakout", "Driving", "Fighting", "FP-Shooter", "Gallery", "Maze", "Misc", "Pinball", "Platform", "Shooter", "Sports", "Undefined"};
int favorit_actual;
int categoria_actual;

string mame_path;

int currentResWidth, currentResHeight;
SDL_Surface *screen;
SDL_Surface *srf_capcalera, *srf_subcapcalera, *srf_logo, *srf_peu1, *srf_peu2, *srf_rompng;
SDL_Surface *srf_rom[PAGINACIO];
SDL_Rect rectangle;
SDL_Rect rect_capcalera, rect_subcapcalera, rect_logo, rect_peu1, rect_peu2, rect_rompng;
SDL_Rect rect_rom[PAGINACIO];
SDL_Event event;
TTF_Font *font1, *font2;
SDL_Color fgcolor_negre, fgcolor_blanc, fgcolor_blau;
Uint32 color_fons_taronja, color_fons_negre;
int keypress;

clock_t start;
double diff;

char SOFTWARE[] = "joanillo_arcade_frontend";
char DATE[] = "juliol";
char YEAR[] = "2014";
char AUTHOR[] = "Joan Quintana Compte (joanillo)";
char LICENSE[] = "GPL v.3";
char WEB[] = "joanqc@gmail.com - www.joanillo.org";
char VERSION[] = "v1.0.0";

int main () {

	system("clear");

	cout << SOFTWARE << " " << VERSION << endl;
	cout << "Created by " << AUTHOR << endl;
	cout << "Licensed under " << LICENSE << endl << endl;

	mame_path = MAME_PATH;
	int w=0;
	ifstream in("resources/romlist.txt"); 
	string s;

	int total_favorit[sizeof(favorit) / sizeof(string)]; //All favourites, Bad, Good, Very good, Prefered, Undefined
	for (int i=0; i<sizeof(favorit) / sizeof(string); i++) {
		total_favorit[i] = 0;
	}

	int total_categoria[sizeof(categoria) / sizeof(string)]; //"All categories", "Adventure", "Application", "Breakout", "Driving", "Fighting", "FP-Shooter", "Gallery", "Maze", "Misc", "Pinball", "Platform", "Shooter", "Sports", "Undefined"
	for (int i=0; i<sizeof(categoria) / sizeof(string); i++) {
		total_categoria[i] = 0;
	}

	while(getline(in, s))
		w=w+1; //first count the number of lines in the file for the array

	string linia[w]; //make an array big enough for the file

	ifstream in1("resources/romlist.txt");
	for(int i = 0; i < w ; i++) {
		getline(in1, linia[i]);
		size_t lasttab=linia[i].find_last_of('\t');
		size_t secondtab=linia[i].find_last_of('\t',lasttab-1);
		size_t firsttab=linia[i].find_last_of('\t',secondtab-1);
		vector_roms_global[0].push_back(linia[i].substr(0, firsttab).c_str());
		vector_roms_global[1].push_back(linia[i].substr(firsttab+1,secondtab-firsttab-1).c_str());
		vector_roms_global[2].push_back(linia[i].substr(secondtab+1,lasttab-secondtab-1).c_str());
		vector_roms_global[3].push_back(linia[i].substr(lasttab+1).c_str());

		for (int j=1; j<sizeof(favorit) / sizeof(string); j++) {
			total_favorit[0]++; //all favourites
			if (vector_roms_global[2][i].compare(favorit[j]) == 0) total_favorit[j]++;
		}

		for (int j=1; j<sizeof(categoria) / sizeof(string); j++) {
			total_categoria[0]++; //all categories
			if (vector_roms_global[3][i].compare(categoria[j]) == 0) total_categoria[j]++;
		}

		//cout << i + 1 << " " << vector_roms_global[0][i] << " " << vector_roms_global[1][i] << " " << vector_roms_global[2][i] << " " << vector_roms_global[3][i] << endl;

		vector_roms.push_back(vector_roms_global[0][i]);
		vector_roms_total.push_back(vector_roms_global[1][i]+". "+vector_roms_global[2][i]+". "+vector_roms_global[3][i]);
	}

	cout << endl;
	in1.close();

	/* --------------------------------------------------------------- */

	/* === SDL === */
	currentResWidth = SCREEN_WIDTH;
	currentResHeight = SCREEN_HEIGHT;

	if (inicialitzarSDL()<0)
	{
		cout << "Problema en inicialitzar SDL" << endl;
		return -1;
	}

	// càrrega de la font
	font1 = TTF_OpenFont("/usr/share/fonts/truetype/500fonts/VideoPhreak.ttf",40);
	font2 = TTF_OpenFont("/usr/share/fonts/truetype/500fonts/VideoPhreak.ttf",30);

	// inicialitzem els colors per al text.
	fgcolor_negre.r = 0;
	fgcolor_negre.g = 0;
	fgcolor_negre.b = 0;

	fgcolor_blanc.r = 255;
	fgcolor_blanc.g = 255;
	fgcolor_blanc.b = 255;

	fgcolor_blau.r = 0;
	fgcolor_blau.g = 0;
	fgcolor_blau.b = 255;

	rectangle.x = 0;
	rectangle.y = 0;
	rectangle.w=screen->w;
	rectangle.h=screen->h;

	color_fons_taronja = SDL_MapRGB (screen->format, 255, 124, 8); //taronja (#ff7c08)
	color_fons_negre = SDL_MapRGB (screen->format, 0, 0, 0);

	//1a capçalera
	srf_capcalera = TTF_RenderUTF8_Blended(font1, (favorit[favorit_actual] + ". " + categoria[categoria_actual]).c_str(), fgcolor_blau );
	rect_capcalera.x = LLISTA_ROMS_X;
	rect_capcalera.y = CAPCALERA1_Y;
	rect_capcalera.w = CAPCALERA1_W;
	rect_capcalera.h = CAPCALERA1_H;

	SDL_FillRect (screen, &rectangle, color_fons_taronja);
	SDL_FillRect (screen, &rect_capcalera, color_fons_taronja);
	SDL_BlitSurface(srf_capcalera,NULL,screen,&rect_capcalera);

	//logo
	srf_logo = IMG_Load("resources/Raspberry_Pi_Logo_petit.png");
	rect_logo.x = LLISTA_ROMS_X;
	rect_logo.y = LOGO_Y;
	rect_logo.w = srf_logo->w;
	rect_logo.h = srf_logo->h;
	SDL_BlitSurface(srf_logo,NULL,screen,&rect_logo);

	// peu1 i peu2
	srf_peu1 = TTF_RenderUTF8_Blended(font1, "PyPlay Arcade Machine Emulator", fgcolor_negre );
	rect_peu1.x = PEU_X;	
	rect_peu1.y = LOGO_Y;
	rect_peu1.w = srf_peu1->w;
	rect_peu1.h = srf_peu1->h;
	
	srf_peu2 = TTF_RenderUTF8_Blended(font1, "Joanillo Arcade Frontend (www.joanillo.org)", fgcolor_negre );
	rect_peu2.x = PEU_X;	
	rect_peu2.y = LOGO_Y+50;
	rect_peu2.w = srf_peu2->w;
	rect_peu2.h = srf_peu2->h;

	SDL_FillRect (screen, &rect_peu1, color_fons_taronja);
	SDL_BlitSurface(srf_peu1,NULL,screen,&rect_peu1);
	SDL_BlitSurface(srf_peu1,NULL,screen,&rect_peu1);
	SDL_BlitSurface(srf_peu2,NULL,screen,&rect_peu2);
	/* --------------------------------------------------------------- */
	//llistem tots (llegim fitxer de preferències!!)
	favorit_actual = 0;
	categoria_actual = 0;
	
	string favorit_pref, categoria_pref;
	ifstream in2("resources/preferences.txt", fstream::in);
	getline(in2, favorit_pref);
	getline(in2, categoria_pref);
	for (int i=0; i<sizeof(favorit) / sizeof(string); i++) {
		if (favorit[i].compare(favorit_pref) == 0) favorit_actual = i;
	}
	for (int i=0; i<sizeof(categoria) / sizeof(string); i++) {
		if (categoria[i].compare(categoria_pref) == 0) categoria_actual = i;
	}
	in2.close();
	canvi_fav_cat ();

	start = clock(); //començo a comptar el rellotge

	//bucle principal. El bucle principal és molt petit i bàsic perquè aquesta aplicació funciona controlada pels events del teclat, i no cal fer càlculs en el bucle principal.
	while(keypress!=2) 
	{
		while(SDL_PollEvent(&event)) 
		{      
			switch (event.type) 
			{
				case SDL_QUIT:
					start = clock(); //començo a comptar el rellotge
					keypress = 2;
					break;
				case SDL_KEYDOWN:
					start = clock(); //començo a comptar el rellotge
					handleKey(event.key);
					break;
			}
		}

		diff = ( std::clock() - start ) / (double)CLOCKS_PER_SEC;
		if (diff > WAIT_TIME) {
			SDL_Quit();
			//system("/home/joan/arthropoda/presentaciosdl/presentaciosdl");	
			system((mame_path + " " + vector_roms_global[0][rand() % vector_roms_global[0].size()]).c_str()); //agafem aleatòriament una de les 1000 i pico ROMs
			if (inicialitzarSDL()<0)
			{
				cout << "Problema en inicialitzar SDL" << endl;
				//return -1;
			}

			SDL_FillRect (screen, &rectangle, color_fons_taronja);
			SDL_FillRect (screen, &rect_capcalera, color_fons_taronja);
			SDL_BlitSurface(srf_capcalera,NULL,screen,&rect_capcalera);
			actualitzar_llista();
			start = clock(); //començo a comptar el rellotge
		}

	}
	
	// destruim la font de la lletra
	TTF_CloseFont(font1);
	TTF_CloseFont(font2);

	// alliberem les superfícies
	SDL_FreeSurface(srf_capcalera);
	SDL_FreeSurface(srf_subcapcalera);
	SDL_FreeSurface(srf_logo);
	SDL_FreeSurface(srf_peu1);
	SDL_FreeSurface(srf_peu2);
	SDL_FreeSurface(srf_rompng);
	SDL_FreeSurface(screen);

	//guardem les preferències
	ofstream in3("resources/preferences.txt", fstream::out);
	for (int i=0; i<sizeof(favorit) / sizeof(string); i++) {
		if (favorit_actual == i) in3 << favorit[i] << endl;
	}
	for (int i=0; i<sizeof(categoria) / sizeof(string); i++) {
		if (categoria_actual == i) in3 << categoria[i];
	}
	in3.close();

	SDL_Quit();
	return 0;
}

int inicialitzarSDL() {
	if (SDL_Init(SDL_INIT_VIDEO | SDL_INIT_AUDIO) < 0) {
		printf("No s'ha pogut inicialitzar SDL: %s\n",SDL_GetError());
		return -1;
	}

	SDL_EnableKeyRepeat (SDL_DEFAULT_REPEAT_DELAY, SDL_DEFAULT_REPEAT_INTERVAL);
	
	const SDL_VideoInfo* screenInfo = SDL_GetVideoInfo();
	currentResWidth = (int)screenInfo->current_w;
	currentResHeight = (int)screenInfo->current_h;

	//cout << "screen width: " << currentResWidth  << endl;
	//cout << "screen height: " << currentResHeight  << endl << endl;

	if (!(screen = SDL_SetVideoMode(currentResWidth, currentResHeight, DEPTH, SDL_FULLSCREEN|SDL_SWSURFACE)))
	{
		SDL_Quit();
		return -1;
	}

	// Inicialitzem SDL_ttf
	if (TTF_Init() < 0) {
		printf("No s'ha pogut inicialitzar SDL_ttf: %s\n",SDL_GetError());
		SDL_Quit();
		return -1;
	}

	//SDL_ShowCursor( SDL_DISABLE ); //cursor invisible
	return 0;
}

void handleKey(SDL_KeyboardEvent key) {
	switch(key.keysym.sym) {
	case SDLK_UP:
		if(key.state == SDL_PRESSED) {
			if (rom_actual > 0) {
				rom_actual--;
				if (rom_pag_actual > 0) {
					rom_pag_actual--;
				}
				//cout << rom_actual << " " << rom_pag_actual << " " << vector_roms[rom_actual] << endl;
				actualitzar_llista();
			}
			break;
		}
	case SDLK_DOWN:
		if(key.state == SDL_PRESSED) {
			if (rom_actual < vector_roms.size()-1) {
				rom_actual++;
				if (rom_pag_actual < PAGINACIO-1) {
					rom_pag_actual++;
				}
				//cout << rom_actual << " " << rom_pag_actual << " " << vector_roms[rom_actual] << endl;
				actualitzar_llista();
			}
			break;
		}
	case SDLK_LEFT:
		if(key.state == SDL_PRESSED) {
			if ( (rom_actual - rom_pag_actual - PAGINACIO) >= 0 ) { //l'anterior pàgina és sencera. cas 0
				rom_actual = rom_actual - PAGINACIO;
				//rom_pag_actual no canvia
				//cout << rom_actual << " " << rom_pag_actual << " " << vector_roms[rom_actual] << endl;
				actualitzar_llista();
			} else if (rom_actual - rom_pag_actual > 0 ) { //l'anterior pàgina NO és sencera
				if (rom_actual >= PAGINACIO) { //cas 1
					rom_actual = rom_actual - PAGINACIO;
					rom_pag_actual = rom_actual;
				} else { //cas 2
					rom_pag_actual = 0;
					rom_actual = 0;
				}
				//cout << rom_actual << " " << rom_pag_actual << " " << vector_roms[rom_actual] << endl;
				actualitzar_llista2();
			} else { //l'anterior pàgina estaria buida. Situo el cursor en la primera ROM. cas 3
				rom_pag_actual = 0;
				rom_actual = 0;
				//cout << rom_actual << " " << rom_pag_actual << " " << vector_roms[rom_actual] << endl;
				actualitzar_llista2();
			}

			break;
		}
	case SDLK_RIGHT:
		if(key.state == SDL_PRESSED) {
			if ( rom_actual + PAGINACIO + (PAGINACIO - rom_pag_actual) < vector_roms.size()+1 ) { //la següent pàgina és sencera. cas 0
				rom_actual = rom_actual + PAGINACIO;
				//rom_pag_actual no canvia
				//cout << rom_actual << " " << rom_pag_actual << " " << vector_roms[rom_actual] << endl;
				actualitzar_llista();
			} else if (rom_actual - rom_pag_actual + PAGINACIO < vector_roms.size()) {
				if (rom_actual + PAGINACIO <= vector_roms.size()-1) { //cas 1 *****
					rom_actual = rom_actual + PAGINACIO;
					//rom_pag_actual no canvia
				} else { //cas 2
					rom_pag_actual = rom_pag_actual - (rom_actual + PAGINACIO - vector_roms.size())-1;
					rom_actual = vector_roms.size()-1;
				}
				//cout << rom_actual << " " << rom_pag_actual << " " << vector_roms[rom_actual] << endl;
				actualitzar_llista2();
			} else { //la següent pàgina estaria buida. Situo el cursor en la última ROM. cas 3
				rom_pag_actual = vector_roms.size() - (rom_actual - rom_pag_actual) - 1;
				rom_actual =  vector_roms.size()-1;
				//cout << rom_actual << " " << rom_pag_actual << " " << vector_roms[rom_actual] << endl;
				actualitzar_llista2();
			}	

			break;
		}
	case SDLK_0: //per sortir de l'aplicatiu, s'haurà de clicar dues vegades. Si clico primer SDLK_0 i després SDLK_3, serà shutdown
		if(key.state == SDL_PRESSED) {
			keypress++;
			break;
		}
	case SDLK_2:
		if(key.state == SDL_PRESSED) {
			//sortim de SDL (que no del programa), llencem un aplicatiu extern, i quan aquest acaba s'ha de tornar a inicialitzar SDL i refrescar la pantalla
			SDL_Quit();
			//system("/home/joan/arthropoda/presentaciosdl/presentaciosdl");
			system((mame_path + " " + vector_roms[rom_actual]).c_str());
			if (inicialitzarSDL()<0)
			{
				cout << "Problema en inicialitzar SDL" << endl;
				//return -1;
			}

			SDL_FillRect (screen, &rectangle, color_fons_taronja);
			SDL_FillRect (screen, &rect_capcalera, color_fons_taronja);
			SDL_BlitSurface(srf_capcalera,NULL,screen,&rect_capcalera);
			actualitzar_llista();
			start = clock(); //començo a comptar el rellotge

			break;
		}
	case SDLK_3: //FAV
		if(key.state == SDL_PRESSED) {
			if (keypress == 0) { //per apagar la màquina amb shutdown, s'ha d'apretar primer SDLK_0
				favorit_actual++;
				if (favorit_actual == sizeof(favorit) / sizeof(string) ) favorit_actual = 0;
				canvi_fav_cat();
			} else {
				SDL_Quit();
				cout << "sudo /sbin/shutdown -h now" << endl;
				system("sudo /sbin/shutdown -h now"); //a la RP es pot executar com a sudo sense que demani password.
			}
			break;
		}
	case SDLK_4: //CAT
		if(key.state == SDL_PRESSED) {

			categoria_actual++;
			if (categoria_actual == sizeof(categoria) / sizeof(string) ) categoria_actual = 0;
			canvi_fav_cat();
			break;
		}
	}
}

void actualitzar_llista ()  {

	carregar_subcapcalera_rompng();

	//cout << "rom_actual:" << rom_actual << " rom_pag_actual:" << rom_pag_actual << " PAGINACIO:" << PAGINACIO << " cap_avall:" << cap_avall << " cap_amunt:" << cap_amunt << endl;
	for (int i=0; i < PAGINACIO; i++) {
		if (i < vector_roms.size() - rom_actual + rom_pag_actual) {
			if ((rom_pag_actual < PAGINACIO) && (rom_actual-rom_pag_actual <= 0)) {
				if (i == rom_pag_actual) {
					srf_rom[i] = TTF_RenderUTF8_Blended(font2, vector_roms[i].c_str(), fgcolor_blanc );
				} else {
					srf_rom[i] = TTF_RenderUTF8_Blended(font2, vector_roms[i].c_str(), fgcolor_negre );
				}
			} else if ((rom_pag_actual == PAGINACIO-1) && (rom_actual-rom_pag_actual > 0)) {
				if (i == rom_pag_actual) {
					srf_rom[i] = TTF_RenderUTF8_Blended(font2, vector_roms[rom_actual - rom_pag_actual + i].c_str(), fgcolor_blanc );
				} else {
					srf_rom[i] = TTF_RenderUTF8_Blended(font2, vector_roms[rom_actual - rom_pag_actual + i ].c_str(), fgcolor_negre );
				}
			} else if ((rom_pag_actual < PAGINACIO) && (rom_actual-rom_pag_actual > 0)) {
				if (i == rom_pag_actual) {
					srf_rom[i] = TTF_RenderUTF8_Blended(font2, vector_roms[rom_actual - rom_pag_actual + i].c_str(), fgcolor_blanc );
				} else {
					srf_rom[i] = TTF_RenderUTF8_Blended(font2, vector_roms[rom_actual - rom_pag_actual + i].c_str(), fgcolor_negre );
				} 
			}
		} else {
			srf_rom[i] = TTF_RenderUTF8_Blended(font2, "", fgcolor_blanc );
		}

		rect_rom[i].x = LLISTA_ROMS_X;
		rect_rom[i].y = LLISTA_ROMS_Y + LLISTA_ROMS_H*i;
		rect_rom[i].w = LLISTA_ROMS_W;
		rect_rom[i].h = LLISTA_ROMS_H;

		if (i == rom_pag_actual) {
			SDL_FillRect (screen, &rect_rom[i], color_fons_negre);
		} else {
			SDL_FillRect (screen, &rect_rom[i], color_fons_taronja);			
		}
		SDL_BlitSurface(srf_rom[i],NULL,screen,&rect_rom[i]);
	}

	SDL_UpdateRect(screen,0,0,0,0);
}

void actualitzar_llista2 ()  {

	carregar_subcapcalera_rompng();

	for (int i=0; i < PAGINACIO; i++) {
		if (i < vector_roms.size() - rom_actual + rom_pag_actual) {
			if (i == rom_pag_actual) {
				srf_rom[i] = TTF_RenderUTF8_Blended(font2, vector_roms[rom_actual - rom_pag_actual + i].c_str(), fgcolor_blanc );
			} else {
				srf_rom[i] = TTF_RenderUTF8_Blended(font2, vector_roms[rom_actual - rom_pag_actual + i].c_str(), fgcolor_negre );
			} 
		} else {
			srf_rom[i] = TTF_RenderUTF8_Blended(font2, "", fgcolor_blanc );
		}
		rect_rom[i].x = LLISTA_ROMS_X;
		rect_rom[i].y = LLISTA_ROMS_Y + LLISTA_ROMS_H*i;
		rect_rom[i].w = LLISTA_ROMS_W;
		rect_rom[i].h = LLISTA_ROMS_H;
		if (i == rom_pag_actual) {
			SDL_FillRect (screen, &rect_rom[i], color_fons_negre);
		} else {
			SDL_FillRect (screen, &rect_rom[i], color_fons_taronja);			
		}
		SDL_BlitSurface(srf_rom[i],NULL,screen,&rect_rom[i]);
	}
	SDL_UpdateRect(screen,0,0,0,0);
}

void canvi_fav_cat () {
	rom_pag_actual = 0;
	rom_actual = 0;
	vector_roms.resize(0);
	vector_roms_total.resize(0);
	for(int i = 0; i < vector_roms_global[0].size() ; i++) {
		if ((favorit_actual == 0) && (categoria_actual == 0)) {
			vector_roms.push_back(vector_roms_global[0][i]);
			vector_roms_total.push_back(vector_roms_global[1][i]+". "+vector_roms_global[2][i]+". "+vector_roms_global[3][i]);
		} else if ((favorit_actual == 0) && (categoria_actual > 0)) {
			if (vector_roms_global[3][i].compare(categoria[categoria_actual]) == 0) {
				vector_roms.push_back(vector_roms_global[0][i]);
				vector_roms_total.push_back(vector_roms_global[1][i]+". "+vector_roms_global[2][i]+". "+vector_roms_global[3][i]);
			}
		} else if ((favorit_actual > 0) && (categoria_actual == 0)) {
			if (vector_roms_global[2][i].compare(favorit[favorit_actual]) == 0) {
				vector_roms.push_back(vector_roms_global[0][i]);
				vector_roms_total.push_back(vector_roms_global[1][i]+". "+vector_roms_global[2][i]+". "+vector_roms_global[3][i]);
			}
		} else {
			if ( (vector_roms_global[2][i].compare(favorit[favorit_actual]) == 0)  && (vector_roms_global[3][i].compare(categoria[categoria_actual]) == 0)) {
				vector_roms.push_back(vector_roms_global[0][i]);
				vector_roms_total.push_back(vector_roms_global[1][i]+". "+vector_roms_global[2][i]+". "+vector_roms_global[3][i]);
			}
		}
	}

	stringstream ss; //no era tan fàcil convertir un número a string. Per utilitzar stringstream es necessita <sstream> 
	ss <<  vector_roms.size();
	string str = ss.str();

	if (vector_roms_total.size() == 0) vector_roms_total.push_back("No ROMs");
	if (vector_roms.size() == 0) vector_roms.push_back("No ROMs");

	//1a capçalera
	srf_capcalera = TTF_RenderUTF8_Blended(font1, (favorit[favorit_actual] + ". " + categoria[categoria_actual] + " (" +  str + " ROMs)").c_str(), fgcolor_blau );
	rect_capcalera.x = LLISTA_ROMS_X;
	rect_capcalera.y = CAPCALERA1_Y;
	rect_capcalera.w = CAPCALERA1_W;
	rect_capcalera.h = CAPCALERA1_H;

	SDL_FillRect (screen, &rectangle, color_fons_taronja);
	SDL_FillRect (screen, &rect_capcalera, color_fons_taronja);
	SDL_BlitSurface(srf_capcalera,NULL,screen,&rect_capcalera);
	SDL_BlitSurface(srf_logo,NULL,screen,&rect_logo);
	SDL_BlitSurface(srf_peu1,NULL,screen,&rect_peu1);
	SDL_BlitSurface(srf_peu2,NULL,screen,&rect_peu2);

	actualitzar_llista();
}

void resizeImage( SDL_Surface*& img, const double newwidth, const double newheight )
{
// Zoom function uses doubles for rates of scaling, rather than
// exact size values. This is how we get around that:
double zoomx = newwidth  / (float)img->w;
double zoomy = newheight / (float)img->h;
 
// This function assumes no smoothing, so that any colorkeys wont bleed.
SDL_Surface* sized = zoomSurface( img, zoomx, zoomy, SMOOTHING_OFF );
 
// Copy transparency data.
//matchColorKeys( img, sized );
 
// The original picture is no longer needed.
SDL_FreeSurface( img );
 
// Set it instead to the new image.
img =  sized;
}

void carregar_subcapcalera_rompng () {

	SDL_FillRect (screen, &rect_subcapcalera, color_fons_taronja);

	// 2a capçalera
	srf_subcapcalera = TTF_RenderUTF8_Blended(font1, vector_roms_total[rom_actual].c_str(), fgcolor_blau );
	rect_subcapcalera.x = LLISTA_ROMS_X;	
	rect_subcapcalera.y = CAPCALERA2_Y;
	rect_subcapcalera.w = CAPCALERA2_W;
	rect_subcapcalera.h = CAPCALERA1_H;
	SDL_BlitSurface(srf_subcapcalera,NULL,screen,&rect_subcapcalera);

	//rom png
	string str1 = "rom_images_800/";
	string str2 = "rom_images_300/";
	string str3 = ".png";

	if (vector_roms[rom_actual].compare("No ROMs") == 0) {
		srf_rompng = IMG_Load((str1+"norom"+str3).c_str());
		resizeImage (srf_rompng, ROMPNG_WH, ROMPNG_WH);
	} else {
		srf_rompng = IMG_Load((str1+vector_roms[rom_actual]+str3).c_str());
		if(!srf_rompng) { //si no carrego la imatge de 800 px, carregaré la imatge de 300 px, que hauré d'ampliar amb resizeImage
		    //printf("IMG_Load: %s\n", IMG_GetError());
			srf_rompng = IMG_Load((str2+vector_roms[rom_actual]+str3).c_str());
			if(!srf_rompng) { 
				srf_rompng = IMG_Load((str1+"norom"+str3).c_str());
				resizeImage (srf_rompng, ROMPNG_WH, ROMPNG_WH);
			} else {
				resizeImage (srf_rompng, ROMPNG_WH, ROMPNG_WH);
			}
		} else {
			resizeImage (srf_rompng, ROMPNG_WH, ROMPNG_WH); //redueixo la imatge de 800 a 500 px.
		}
	}

	rect_rompng.x = ROMPNG_X;	
	rect_rompng.y = LLISTA_ROMS_Y;
	rect_rompng.w = ROMPNG_WH;
	rect_rompng.h = ROMPNG_WH;
	SDL_FillRect (screen, &rect_rompng, color_fons_taronja);
	SDL_BlitSurface(srf_rompng,NULL,screen,&rect_rompng);	

}