
#ifndef INCLUDED_LlegirAmbFiducials3_H
#define INCLUDED_LlegirAmbFiducials3_H

#include "TuioListener.h"
#include "TuioClient.h"
#include "TuioObject.h"
#include "TuioCursor.h"
#include "TuioPoint.h"
#include <list>
#include <math.h>

#include <SDL.h>
#include <SDL_thread.h>

using namespace TUIO;

class LlegirAmbFiducials3 : public TuioListener { 
	
public:
	LlegirAmbFiducials3(int port);
	~LlegirAmbFiducials3() {
		tuioClient->disconnect();
		delete tuioClient;
	}
	
	void addTuioObject(TuioObject *tobj);
	void updateTuioObject(TuioObject *tobj);
	void removeTuioObject(TuioObject *tobj);
	
	void addTuioCursor(TuioCursor *tcur);
	void updateTuioCursor(TuioCursor *tcur);
	void removeTuioCursor(TuioCursor *tcur);
	
	void refresh(TuioTime frameTime);
	
	void run();
	TuioClient *tuioClient;
	
private:
	void drawObject(int num_obj);
	void drawObjects();
	void drawString(char *str);
	void processEvents();
	SDL_Surface *window;
	bool verbose, running;
	
	int width, height;
	int screen_width, screen_height;
	int window_width, window_height;
};

#endif /* INCLUDED_LlegirAmbFiducials3_H */
