
#include "LlegirAmbFiducials3.h"
#include <SDL.h>
#include <SDL_ttf.h>

SDL_Color bgcolor,fgcolor;
SDL_Rect rectangle1, rectangle2;
SDL_Surface *screen,*ttext1,*ttext2;
TTF_Font *font;
char msg1[40], msg2[40];
SDL_Event event;
const char* const list[] = {"nena", "cotxe", "arbre", "ocell"};
int primer, segon;
int comptador;
int aaa;
		
void LlegirAmbFiducials3::addTuioObject(TuioObject *tobj) {
	if (verbose)
		std::cout << "add obj " << tobj->getSymbolID() << " (" << tobj->getSessionID() << ") "<< tobj->getX() << " " << tobj->getY() << " " << tobj->getAngle() << std::endl;
		comptador++;
		aaa=1;
		if (comptador==1) primer=tobj->getSymbolID();
		if (comptador==2) segon=tobj->getSymbolID();

}

void LlegirAmbFiducials3::updateTuioObject(TuioObject *tobj) {

	if (verbose) 	
		std::cout << "set obj " << tobj->getSymbolID() << " (" << tobj->getSessionID() << ") "<< tobj->getX() << " " << tobj->getY() << " " << tobj->getAngle() 
		<< " " << tobj->getMotionSpeed() << " " << tobj->getRotationSpeed() << " " << tobj->getMotionAccel() << " " << tobj->getRotationAccel() << std::endl;

}

void LlegirAmbFiducials3::removeTuioObject(TuioObject *tobj) {

	if (verbose)
		std::cout << "del obj " << tobj->getSymbolID() << " (" << tobj->getSessionID() << ")" << std::endl;
}

void LlegirAmbFiducials3::addTuioCursor(TuioCursor *tcur) {
	
	if (verbose) 
		std::cout << "add cur " << tcur->getCursorID() << " (" <<  tcur->getSessionID() << ") " << tcur->getX() << " " << tcur->getY() << std::endl;

}

void LlegirAmbFiducials3::updateTuioCursor(TuioCursor *tcur) {

	if (verbose) 	
		std::cout << "set cur " << tcur->getCursorID() << " (" <<  tcur->getSessionID() << ") " << tcur->getX() << " " << tcur->getY() 
					<< " " << tcur->getMotionSpeed() << " " << tcur->getMotionAccel() << " " << std::endl;
}

void LlegirAmbFiducials3::removeTuioCursor(TuioCursor *tcur) {
	
	if (verbose)
		std::cout << "del cur " << tcur->getCursorID() << " (" <<  tcur->getSessionID() << ")" << std::endl;
}

void LlegirAmbFiducials3::refresh(TuioTime frameTime) {
	//
}


void LlegirAmbFiducials3::drawObject(int num_obj) {
	//std::cout << num_obj << "\n";

	//primer hem d'esborrar la pantalla (esborrem els dos rectangles)
	SDL_FillRect(screen,&rectangle1,SDL_MapRGB(screen->format,0,0,0));
	SDL_FillRect(screen,&rectangle2,SDL_MapRGB(screen->format,0,0,0));

	sprintf(msg1,"%s",list[num_obj]);
	ttext1 = TTF_RenderText_Shaded(font,msg1,fgcolor,bgcolor);
		
	rectangle1.y=100;
	rectangle1.x=100;
	rectangle1.w=ttext1->w;
	rectangle1.h=ttext1->h;

	// Usamos color rojo para la transparencia del fondo
	SDL_SetColorKey(ttext1,SDL_SRCCOLORKEY|SDL_RLEACCEL, SDL_MapRGB(ttext1->format,255,0,0));

	// Volcamos la superficie a la pantalla
	SDL_BlitSurface(ttext1,NULL,screen,&rectangle1);
	SDL_Flip(screen);
}

void LlegirAmbFiducials3::drawObjects() {
	SDL_Delay(1000); //fem una espera

		
	//primer hem d'esborrar la pantalla (esborrem els dos rectangles)
	SDL_FillRect(screen,&rectangle1,SDL_MapRGB(screen->format,0,0,0));
	SDL_FillRect(screen,&rectangle2,SDL_MapRGB(screen->format,0,0,0));

	sprintf(msg1,"%s","el pere de la cullera macarro fregit");
	sprintf(msg2,"%s","panxa de granota i amb el cul cosit");
	sprintf(msg1,"%s",list[primer]);
	sprintf(msg2,"%s",list[segon]);
	ttext1 = TTF_RenderText_Shaded(font,msg1,fgcolor,bgcolor);
	ttext2 = TTF_RenderText_Shaded(font,msg2,fgcolor,bgcolor);
		
	rectangle1.y=100;
	rectangle1.x=100;
	rectangle1.w=ttext1->w;
	rectangle1.h=ttext1->h;

	rectangle2.y=300;
	rectangle2.x=100;
	rectangle2.w=ttext2->w;
	rectangle2.h=ttext2->h;

	// Usamos color rojo para la transparencia del fondo
	SDL_SetColorKey(ttext1,SDL_SRCCOLORKEY|SDL_RLEACCEL, SDL_MapRGB(ttext1->format,255,0,0));
	SDL_SetColorKey(ttext2,SDL_SRCCOLORKEY|SDL_RLEACCEL, SDL_MapRGB(ttext2->format,255,0,0));

	// Volcamos la superficie a la pantalla
	SDL_BlitSurface(ttext1,NULL,screen,&rectangle1);
	SDL_BlitSurface(ttext2,NULL,screen,&rectangle2);
	SDL_Flip(screen);

}


void LlegirAmbFiducials3::processEvents()
{
    SDL_Event event;

    while( SDL_PollEvent( &event ) ) {

        switch( event.type ) {
		case SDL_KEYDOWN:
			if( event.key.keysym.sym == SDLK_ESCAPE ){
				running = false;
				TTF_CloseFont(font);
			    	SDL_FreeSurface(ttext1);
			    	SDL_FreeSurface(ttext2);
				SDL_Quit();
			} else if( event.key.keysym.sym == SDLK_v ){
				verbose = !verbose;	
			} 

			break;
		case SDL_QUIT:
			running = false;
			TTF_CloseFont(font);
			SDL_FreeSurface(ttext1);
			SDL_FreeSurface(ttext2);
			SDL_Quit();
			break;
        }
    }
}

LlegirAmbFiducials3::LlegirAmbFiducials3(int port) {

	verbose = false;
	window_width = 640;
	window_height = 480;
	screen_width = 1024;
	screen_height = 768;

	tuioClient = new TuioClient(port);
	tuioClient->addTuioListener(this);
	tuioClient->connect();

	if (!tuioClient->isConnected()) {
		SDL_Quit();
		exit(1);
	}
	
	if (SDL_Init(SDL_INIT_VIDEO) < 0) {
		std::cerr << "SDL could not be initialized: " <<  SDL_GetError() << std::endl;
		SDL_Quit();
		exit (1);
	}
	screen = SDL_SetVideoMode(640,480,24,SDL_HWSURFACE|SDL_DOUBLEBUF);
	if (screen == NULL) {
		std::cerr << "Could not open window: " << SDL_GetError() << std::endl;
		SDL_Quit();
		exit (1);
	}
	if (TTF_Init() < 0) {
		printf("CouldSDL_ttf could not be initialized: %s\n",SDL_GetError());
		exit (1);
	}
	font = TTF_OpenFont("ariblk.ttf",20);

	// inicialitza els colors per al text
	fgcolor.r=200;
	fgcolor.g=200;
	fgcolor.b=10;

	bgcolor.r=255;
	bgcolor.g=0;
	bgcolor.b=0;


}

void LlegirAmbFiducials3::run() {
	running=true;
	comptador=0;
	aaa=0;
	while (running) {
		if (comptador==1 && aaa==1) {
			drawObject(primer);
			aaa=0;
		}
		else if (comptador==2 && aaa==1) {
			drawObject(segon);
			aaa=0;
			drawObjects();
			comptador=0;
			primer=-1;
			segon=-1;
		}
		processEvents();
		SDL_Delay(40);;
	} 
}

int main(int argc, char* argv[])
{
	if( argc >= 2 && strcmp( argv[1], "-h" ) == 0 ){
        	std::cout << "usage: LlegirAmbFiducials3 [port]\n";
        	return 0;
	}

	int port = 3333;
	if( argc >= 2 ) port = atoi( argv[1] );
	
    	//const size_t len = sizeof(list) / sizeof(list[0]);
    	//for (size_t i = 0; i < len; ++i) {
        //	std::cout << list[i] << "\n";
    	//}

 	//const vector<string> v(list, list + len);
 	//copy(v.begin(), v.end(), ostream_iterator<string>(cout, "\n"));


	LlegirAmbFiducials3 *app = new LlegirAmbFiducials3(port);
	app->run();
	delete(app);

	return 0;
}


