
#ifndef INCLUDED_LlegirAmbFiducials2_H
#define INCLUDED_LlegirAmbFiducials2_H

#include "TuioListener.h"
#include "TuioClient.h"
#include "TuioObject.h"
#include "TuioCursor.h"
#include "TuioPoint.h"
#include <list>
#include <math.h>

#include <SDL.h>
#include <SDL_thread.h>

#ifdef __APPLE__
#include <OpenGL/gl.h>
#include <OpenGL/glu.h>
#include <GLUT/glut.h>
#else
#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>
#endif

using namespace TUIO;

class LlegirAmbFiducials2 : public TuioListener { 
	
public:
	LlegirAmbFiducials2(int port);
	~LlegirAmbFiducials2() {
		tuioClient->disconnect();
		delete tuioClient;
	}
	
	void addTuioObject(TuioObject *tobj);
	void updateTuioObject(TuioObject *tobj);
	void removeTuioObject(TuioObject *tobj);
	
	void addTuioCursor(TuioCursor *tcur);
	void updateTuioCursor(TuioCursor *tcur);
	void removeTuioCursor(TuioCursor *tcur);
	
	void refresh(TuioTime frameTime);
	
	void run();
	TuioClient *tuioClient;
	
private:
	void drawObjects();
	void drawString(char *str);
	void processEvents();
	void toggleFullscreen();
	SDL_Surface *window;
	bool verbose, fullscreen, running;
	
	int width, height;
	int screen_width, screen_height;
	int window_width, window_height;
};

#endif /* INCLUDED_LlegirAmbFiducials2_H */
