#include "LlegirAmbFiducials1.h"
#include <stdio.h>
#include <stdlib.h>
#include <SDL.h>
#include <SDL_ttf.h>
	
bool running=true;
	
void TuioDump::addTuioObject(TuioObject *tobj) {
	std::cout << "add obj " << tobj->getSymbolID() << " (" << tobj->getSessionID() << ") "<< tobj->getX() << " " << tobj->getY() << " " << tobj->getAngle() << std::endl;
}

void TuioDump::updateTuioObject(TuioObject *tobj) {
	std::cout << "set obj " << tobj->getSymbolID() << " (" << tobj->getSessionID() << ") "<< tobj->getX() << " " << tobj->getY() << " " << tobj->getAngle() 
				<< " " << tobj->getMotionSpeed() << " " << tobj->getRotationSpeed() << " " << tobj->getMotionAccel() << " " << tobj->getRotationAccel() << std::endl;
}

void TuioDump::removeTuioObject(TuioObject *tobj) {
	std::cout << "del obj " << tobj->getSymbolID() << " (" << tobj->getSessionID() << ")" << std::endl;
}

void TuioDump::addTuioCursor(TuioCursor *tcur) {
	std::cout << "add cur " << tcur->getCursorID() << " (" <<  tcur->getSessionID() << ") " << tcur->getX() << " " << tcur->getY() << std::endl;
}

void TuioDump::updateTuioCursor(TuioCursor *tcur) {
	std::cout << "set cur " << tcur->getCursorID() << " (" <<  tcur->getSessionID() << ") " << tcur->getX() << " " << tcur->getY() 
				<< " " << tcur->getMotionSpeed() << " " << tcur->getMotionAccel() << " " << std::endl;
}

void TuioDump::removeTuioCursor(TuioCursor *tcur) {
	std::cout << "del cur " << tcur->getCursorID() << " (" <<  tcur->getSessionID() << ")" << std::endl;
}

void  TuioDump::refresh(TuioTime frameTime) {
	//std::cout << "refresh " << frameTime.getTotalMilliseconds() << std::endl;
}



int main(int argc, char* argv[])
{

SDL_Color bgcolor,fgcolor;
SDL_Rect rectangulo;
SDL_Surface *screen,*ttext;
TTF_Font *fuente;
const char texto[14]="Hola Mundo...";
char msg[14];
SDL_Event event;
int done = 0;

	//------------------------------
	if( argc >= 2 && strcmp( argv[1], "-h" ) == 0 ){
        	std::cout << "usage: TuioDump [port]\n";
        	return 0;
	}

	int port = 3333;
	if( argc >= 2 ) port = atoi( argv[1] );

	TuioDump dump;
	TuioClient client(port);
	client.addTuioListener(&dump);
	client.connect(true);
	//--------------------------------

	// Inicializamos SDL
	if (SDL_Init(SDL_INIT_VIDEO) < 0) {
		printf("No se pudo iniciar SDL: %s\n",SDL_GetError());
		return 1;
	}

	// Inicializamos modo de video
	screen = SDL_SetVideoMode(640,480,24,SDL_HWSURFACE|SDL_DOUBLEBUF);
	if (screen == NULL) {
		printf("No se puede inicializar el modo gráfico: \n",SDL_GetError());
		return 1;
	}

	atexit(SDL_Quit);


	// Inicializamos SDL_ttf
	if (TTF_Init() < 0) {
		printf("No se pudo iniciar SDL_ttf: %s\n",SDL_GetError());
		return 1;
	}

	atexit(TTF_Quit);

	// carga la funte de letra
	fuente = TTF_OpenFont("ariblk.ttf",20);
	//fuente = TTF_OpenFont("/usr/share/fonts/truetype/freefont/FreeMono.ttf",20); 

	// inicializa colores para el texto
	fgcolor.r=200;
	fgcolor.g=200;
	fgcolor.b=10;

	bgcolor.r=255;
	bgcolor.g=0;
	bgcolor.b=0;

	sprintf(msg,"%s",texto);
	ttext = TTF_RenderText_Shaded(fuente,msg,fgcolor,bgcolor);
	rectangulo.y=100;
	rectangulo.x=100;
	rectangulo.w=ttext->w;
	rectangulo.h=ttext->h;


	// Usamos color rojo para la transparencia del fondo
	SDL_SetColorKey(ttext,SDL_SRCCOLORKEY|SDL_RLEACCEL, SDL_MapRGB(ttext->format,255,0,0));

	// Volcamos la superficie a la pantalla
	SDL_BlitSurface(ttext,NULL,screen,&rectangulo);
	SDL_Flip(screen);

	// destruimos la fuente de letra
	TTF_CloseFont(fuente);

	// liberar superficie
	SDL_FreeSurface(ttext);

		while ( SDL_PollEvent(&event) ) {
			if ( event.type == SDL_KEYDOWN ) 
				SDL_Quit();
				done = 1;
		}

	return 0;
}


