#include "LlegirAmbFiducials.h"
#include <SDL.h>
#include <SDL_ttf.h>

#include <vector>
#include <iostream>
#include <time.h>

#include <stdio.h>
#include <stdlib.h>

using namespace std;
using std::vector;

#define HEIGHT 66 //número de combinacions amb els fiducials que tinc
#define WIDTH 3 //número de frases per cada combinació. Roten de forma aleatòria
#define DEPTH 2 //cada frase es divideix en dos.

SDL_Color fgcolor;
SDL_Rect rectangle1, rectangle2;
SDL_Surface *screen,*ttext1,*ttext2;
TTF_Font *font;
char msg1[40], msg2[40];
SDL_Event event;
const char* const llista[] = {"DOFÍ", "COTXE", "NEN", "CADIRA", "CACTUS", "NENA", "TRICICLE", "CONILL", "ÀNEC", "TAMBOR", "GOS", "PINGÜÍ"};
int primer, segon;
int comptador;
int aaa;
int ind;
		
	
  vector<vector<vector<char *> > > array3D;
  int randfrase;

void LlegirAmbFiducials::addTuioObject(TuioObject *tobj) {
	if (verbose)
		std::cout << "add obj " << tobj->getSymbolID() << " (" << tobj->getSessionID() << ") "<< tobj->getX() << " " << tobj->getY() << " " << tobj->getAngle() << std::endl;
		comptador++;
		aaa=1;
		if (comptador==1) primer=tobj->getSymbolID();
		if (comptador==2) segon=tobj->getSymbolID();
		if (primer==segon) {
			aaa=0;
			comptador=1;
			segon=-1;	
		}

}

void LlegirAmbFiducials::updateTuioObject(TuioObject *tobj) {

	if (verbose) 	
		std::cout << "set obj " << tobj->getSymbolID() << " (" << tobj->getSessionID() << ") "<< tobj->getX() << " " << tobj->getY() << " " << tobj->getAngle() 
		<< " " << tobj->getMotionSpeed() << " " << tobj->getRotationSpeed() << " " << tobj->getMotionAccel() << " " << tobj->getRotationAccel() << std::endl;

}

void LlegirAmbFiducials::removeTuioObject(TuioObject *tobj) {

	if (verbose)
		std::cout << "del obj " << tobj->getSymbolID() << " (" << tobj->getSessionID() << ")" << std::endl;
}

void LlegirAmbFiducials::addTuioCursor(TuioCursor *tcur) {
	
	if (verbose) 
		std::cout << "add cur " << tcur->getCursorID() << " (" <<  tcur->getSessionID() << ") " << tcur->getX() << " " << tcur->getY() << std::endl;

}

void LlegirAmbFiducials::updateTuioCursor(TuioCursor *tcur) {

	if (verbose) 	
		std::cout << "set cur " << tcur->getCursorID() << " (" <<  tcur->getSessionID() << ") " << tcur->getX() << " " << tcur->getY() 
					<< " " << tcur->getMotionSpeed() << " " << tcur->getMotionAccel() << " " << std::endl;
}

void LlegirAmbFiducials::removeTuioCursor(TuioCursor *tcur) {
	
	if (verbose)
		std::cout << "del cur " << tcur->getCursorID() << " (" <<  tcur->getSessionID() << ")" << std::endl;
}

void LlegirAmbFiducials::refresh(TuioTime frameTime) {
	//
}


void LlegirAmbFiducials::drawObject(int num_obj) {
	//std::cout << num_obj << "\n";

	//primer hem d'esborrar la pantalla (esborrem els dos rectangles)
	SDL_FillRect(screen,&rectangle1,SDL_MapRGB(screen->format,0,0,0));
	SDL_FillRect(screen,&rectangle2,SDL_MapRGB(screen->format,0,0,0));

	sprintf(msg1,"%s",llista[num_obj]);
	ttext1 = TTF_RenderUTF8_Blended(font,msg1,fgcolor);
		
	rectangle1.y=100;
	rectangle1.x=100;
	rectangle1.w=ttext1->w;
	rectangle1.h=ttext1->h;

	// Usamos color rojo para la transparencia del fondo
	SDL_SetColorKey(ttext1,SDL_SRCCOLORKEY|SDL_RLEACCEL, SDL_MapRGB(ttext1->format,255,0,0));

	// Volcamos la superficie a la pantalla
	SDL_BlitSurface(ttext1,NULL,screen,&rectangle1);
	SDL_Flip(screen);
}

void LlegirAmbFiducials::drawObjects() {
	SDL_Delay(1000); //fem una espera

	/* initialize random seed: */
	srand ( time(NULL) );
	randfrase = rand() % 3;
		
	//primer hem d'esborrar la pantalla (esborrem els dos rectangles)
	SDL_FillRect(screen,&rectangle1,SDL_MapRGB(screen->format,0,0,0));
	SDL_FillRect(screen,&rectangle2,SDL_MapRGB(screen->format,0,0,0));

	if ((primer==0 && segon==1)||(primer==1 && segon==0)) ind=0;
	if ((primer==0 && segon==2)||(primer==2 && segon==0)) ind=1;
	if ((primer==0 && segon==3)||(primer==3 && segon==0)) ind=2;
	if ((primer==0 && segon==4)||(primer==4 && segon==0)) ind=3;
	if ((primer==0 && segon==5)||(primer==5 && segon==0)) ind=4;
	if ((primer==0 && segon==6)||(primer==6 && segon==0)) ind=5;
	if ((primer==0 && segon==7)||(primer==7 && segon==0)) ind=6;
	if ((primer==0 && segon==8)||(primer==8 && segon==0)) ind=7;
	if ((primer==0 && segon==9)||(primer==9 && segon==0)) ind=8;
	if ((primer==0 && segon==10)||(primer==10 && segon==0)) ind=9;
	if ((primer==0 && segon==11)||(primer==11 && segon==0)) ind=10;
	if ((primer==1 && segon==2)||(primer==2 && segon==1)) ind=11;
	if ((primer==1 && segon==3)||(primer==3 && segon==1)) ind=12;
	if ((primer==1 && segon==4)||(primer==4 && segon==1)) ind=13;
	if ((primer==1 && segon==5)||(primer==5 && segon==1)) ind=14;
	if ((primer==1 && segon==6)||(primer==6 && segon==1)) ind=15;
	if ((primer==1 && segon==7)||(primer==7 && segon==1)) ind=16;
	if ((primer==1 && segon==8)||(primer==8 && segon==1)) ind=17;
	if ((primer==1 && segon==9)||(primer==9 && segon==1)) ind=18;
	if ((primer==1 && segon==10)||(primer==10 && segon==1)) ind=19;
	if ((primer==1 && segon==11)||(primer==11 && segon==1)) ind=20;
	if ((primer==2 && segon==3)||(primer==3 && segon==2)) ind=21;
	if ((primer==2 && segon==4)||(primer==4 && segon==2)) ind=22;
	if ((primer==2 && segon==5)||(primer==5 && segon==2)) ind=23;
	if ((primer==2 && segon==6)||(primer==6 && segon==2)) ind=24;
	if ((primer==2 && segon==7)||(primer==7 && segon==2)) ind=25;
	if ((primer==2 && segon==8)||(primer==8 && segon==2)) ind=26;
	if ((primer==2 && segon==9)||(primer==9 && segon==2)) ind=27;
	if ((primer==2 && segon==10)||(primer==10 && segon==2)) ind=28;
	if ((primer==2 && segon==11)||(primer==11 && segon==2)) ind=29;
	if ((primer==3 && segon==4)||(primer==4 && segon==3)) ind=30;
	if ((primer==3 && segon==5)||(primer==5 && segon==3)) ind=31;
	if ((primer==3 && segon==6)||(primer==6 && segon==3)) ind=32;
	if ((primer==3 && segon==7)||(primer==7 && segon==3)) ind=33;
	if ((primer==3 && segon==8)||(primer==8 && segon==3)) ind=34;
	if ((primer==3 && segon==9)||(primer==9 && segon==3)) ind=35;
	if ((primer==3 && segon==10)||(primer==10 && segon==3)) ind=36;
	if ((primer==3 && segon==11)||(primer==11 && segon==3)) ind=37;
	if ((primer==4 && segon==5)||(primer==5 && segon==4)) ind=38;
	if ((primer==4 && segon==6)||(primer==6 && segon==4)) ind=39;
	if ((primer==4 && segon==7)||(primer==7 && segon==4)) ind=40;
	if ((primer==4 && segon==8)||(primer==8 && segon==4)) ind=41;
	if ((primer==4 && segon==9)||(primer==9 && segon==4)) ind=42;
	if ((primer==4 && segon==10)||(primer==10 && segon==4)) ind=43;
	if ((primer==4 && segon==11)||(primer==11 && segon==4)) ind=44;
	if ((primer==5 && segon==6)||(primer==6 && segon==5)) ind=45;
	if ((primer==5 && segon==7)||(primer==7 && segon==5)) ind=46;
	if ((primer==5 && segon==8)||(primer==8 && segon==5)) ind=47;
	if ((primer==5 && segon==9)||(primer==9 && segon==5)) ind=48;
	if ((primer==5 && segon==10)||(primer==10 && segon==5)) ind=49;
	if ((primer==5 && segon==11)||(primer==11 && segon==5)) ind=50;
	if ((primer==6 && segon==7)||(primer==7 && segon==6)) ind=51;
	if ((primer==6 && segon==8)||(primer==8 && segon==6)) ind=52;
	if ((primer==6 && segon==9)||(primer==9 && segon==6)) ind=53;
	if ((primer==6 && segon==10)||(primer==10 && segon==6)) ind=54;
	if ((primer==6 && segon==11)||(primer==11 && segon==6)) ind=55;
	if ((primer==7 && segon==8)||(primer==8 && segon==7)) ind=56;
	if ((primer==7 && segon==9)||(primer==9 && segon==7)) ind=57;
	if ((primer==7 && segon==10)||(primer==10 && segon==7)) ind=58;
	if ((primer==7 && segon==11)||(primer==11 && segon==7)) ind=59;
	if ((primer==8 && segon==9)||(primer==9 && segon==8)) ind=60;
	if ((primer==8 && segon==10)||(primer==10 && segon==8)) ind=61;
	if ((primer==8 && segon==11)||(primer==11 && segon==8)) ind=62;
	if ((primer==9 && segon==10)||(primer==10 && segon==9)) ind=63;
	if ((primer==9 && segon==11)||(primer==11 && segon==9)) ind=64;
	if ((primer==10 && segon==11)||(primer==11 && segon==10)) ind=65;

	sprintf(msg1,"%s",array3D[ind][randfrase][0]);
	sprintf(msg2,"%s",array3D[ind][randfrase][1]);

	ttext1 = TTF_RenderUTF8_Blended(font,msg1,fgcolor);
	ttext2 = TTF_RenderUTF8_Blended(font,msg2,fgcolor);	

	rectangle1.y=100;
	rectangle1.x=100;
	rectangle1.w=ttext1->w;
	rectangle1.h=ttext1->h;

	rectangle2.y=300;
	rectangle2.x=100;
	rectangle2.w=ttext2->w;
	rectangle2.h=ttext2->h;

	// Usamos color rojo para la transparencia del fondo
	SDL_SetColorKey(ttext1,SDL_SRCCOLORKEY|SDL_RLEACCEL, SDL_MapRGB(ttext1->format,255,0,0));
	SDL_SetColorKey(ttext2,SDL_SRCCOLORKEY|SDL_RLEACCEL, SDL_MapRGB(ttext2->format,255,0,0));

	// Volcamos la superficie a la pantalla
	SDL_BlitSurface(ttext1,NULL,screen,&rectangle1);
	SDL_BlitSurface(ttext2,NULL,screen,&rectangle2);
	SDL_Flip(screen);

}


void LlegirAmbFiducials::processEvents()
{
    SDL_Event event;

    while( SDL_PollEvent( &event ) ) {

        switch( event.type ) {
		case SDL_KEYDOWN:
			if( event.key.keysym.sym == SDLK_ESCAPE ){
				running = false;
				TTF_CloseFont(font);
			    	SDL_FreeSurface(ttext1);
			    	SDL_FreeSurface(ttext2);
				SDL_Quit();
			} else if( event.key.keysym.sym == SDLK_v ){
				verbose = !verbose;	
			} 

			break;
		case SDL_QUIT:
			running = false;
			TTF_CloseFont(font);
			SDL_FreeSurface(ttext1);
			SDL_FreeSurface(ttext2);
			SDL_Quit();
			break;
        }
    }
}

LlegirAmbFiducials::LlegirAmbFiducials(int port) {

	verbose = false;
	window_width = 640;
	window_height = 480;
	screen_width = 1024;
	screen_height = 768;

	tuioClient = new TuioClient(port);
	tuioClient->addTuioListener(this);
	tuioClient->connect();

	if (!tuioClient->isConnected()) {
		SDL_Quit();
		exit(1);
	}
	
	if (SDL_Init(SDL_INIT_VIDEO) < 0) {
		std::cerr << "SDL could not be initialized: " <<  SDL_GetError() << std::endl;
		SDL_Quit();
		exit (1);
	}
	//screen = SDL_SetVideoMode(640,480,24,SDL_HWSURFACE|SDL_DOUBLEBUF);
	screen = SDL_SetVideoMode(1600, 900, 24, SDL_HWSURFACE|SDL_DOUBLEBUF|SDL_FULLSCREEN);


	if (screen == NULL) {
		std::cerr << "Could not open window: " << SDL_GetError() << std::endl;
		SDL_Quit();
		exit (1);
	}

	SDL_WarpMouse(1600,900); //el cursor queda amagat a la cantonada dreta-inferior

	if (TTF_Init() < 0) {
		printf("CouldSDL_ttf could not be initialized: %s\n",SDL_GetError());
		exit (1);
	}
	//font = TTF_OpenFont("ariblk.ttf",70);
	font = TTF_OpenFont("/usr/share/fonts/truetype/freefont/FreeSans.ttf",70);
	// inicialitza els colors per al text
	fgcolor.r=225;
	fgcolor.g=225;
	fgcolor.b=180;

}

void LlegirAmbFiducials::run() {
	running=true;
	comptador=0;
	aaa=0;
	primer=-1;
	segon=-1;

	while (running) {
		if (comptador==1 && aaa==1) {
			drawObject(primer);
			aaa=0;
		}
		else if (comptador==2 && aaa==1) {
			drawObject(segon);
			aaa=0;
			drawObjects();
			comptador=0;
			primer=-1;
			segon=-1;
		}
		processEvents();
		SDL_Delay(40);;
	} 
}

int main(int argc, char* argv[])
{
	if( argc >= 2 && strcmp( argv[1], "-h" ) == 0 ){
        	std::cout << "usage: LlegirAmbFiducials [port]\n";
        	return 0;
	}

	int port = 3333;
	if( argc >= 2 ) port = atoi( argv[1] );

	// Set up sizes. (HEIGHT x WIDTH)
	array3D.resize(HEIGHT);
	for (int i = 0; i < HEIGHT; ++i) {
		array3D[i].resize(WIDTH);

	for (int j = 0; j < WIDTH; ++j)
		array3D[i][j].resize(DEPTH);
	}

	//xuleta
	/*
	0: DOFÍ
	1: COTXE
	2: NEN
	3: CADIRA
	4: CACTUS
	5: NENA
	6: TRICICLE
	7: CONILL
	8: ÀNEC
	9: TAMBOR
	10: GOS
	11: PINGÜÍ

	0-1 0
	0-2 1
	0-3 2
	0-4 3
	0-5 4
	0-6 5
	0-7 6
	0-8 7
	0-9 8
	0-10 9
	0-11 10
	1-2 11
	1-3 12
	1-4 13
	1-5 14
	1-6 15
	1-7 16
	1-8 17
	1-9 18
	1-10 19
	1-11 20
	2-3 21
	2-4 22
	2-5 23
	2-6 24
	2-7 25
	2-8 26
	2-9 27
	2-10 28
	2-11 29
	3-4 30
	3-5 31
	3-6 32
	3-7 33
	3-8 34
	3-9 35
	3-10 36
	3-11 37
	4-5 38
	4-6 39
	4-7 40
	4-8 41
	4-9 42
	4-10 43
	4-11 44
	5-6 45
	5-7 46
	5-8 47
	5-9 48
	5-10 49
	5-11 50
	6-7 51
	6-8 52
	6-9 53
	6-10 54
	6-11 55
	7-8 56
	7-9 57
	7-10 58
	7-11 59
	8-9 60
	8-10 61
	8-11 62
	9-10 63
	9-11 64
	10-11 65
	*/

	//array3D[2][1][0] = (char *)"LA NENA SAP QUE LA MERLA, LA GRALLA"; //no passar d'aquesta longitud
	//array3D[2][1][1] = (char *)"I EL CORB SÓN OCELLS DE COLOR NEGRE"; //no passar d'aquesta longitud

	//DOFÍ-COTXE
	array3D[0][0][0] = (char *)"EL DISSABTE ANIREM AL ZOO EN COTXE";
	array3D[0][0][1] = (char *)"PERQUÈ VOLEM VEURE ELS DOFINS";
	array3D[0][1][0] = (char *)"EL COTXE DEL PARE DEL MEU AMIC";
	array3D[0][1][1] = (char *)"TÉ ENGANXAT UN DOFÍ AL DARRERE";
	array3D[0][2][0] = (char *)"HE LLEGIT PER INTERNET QUE UN COTXE";
	array3D[0][2][1] = (char *)"HA ATROPELLAT UN DOFÍ. NO POT SER!!";
	//DOFÍ-NEN
	array3D[1][0][0] = (char *)"EL NEN, SEMPRE QUE VA AL ZOO.";
	array3D[1][0][1] = (char *)"NO ES VOL PERDRE ELS DOFINS";
	array3D[1][1][0] = (char *)"SE D'UN NEN QUE VA CAURE AL MAR";
	array3D[1][1][1] = (char *)"I UN DOFI EL VA TOCAR AMB EL MUSELL";
	array3D[1][2][0] = (char *)"EL DOFI ES DEIXAVA ACARICIAR";
	array3D[1][2][1] = (char *)"PEL NEN. ELS AGRADA MOLT";
	//DOFÍ-CADIRA
	array3D[2][0][0] = (char *)"EL DOFÍ NEDA PER L'AIGUA, I PER";
	array3D[2][0][1] = (char *)"TANT NO POT SEURE A LA CADIRA";
	array3D[2][1][0] = (char *)"EL CUIDADOR DELS DOFINS ELS DONAVA";
	array3D[2][1][1] = (char *)"PEIXETS ASSEGUT A LA CADIRA";
	array3D[2][2][0] = (char *)"M'AGRADA PORTAR-ME UNA CADIRA A LA";
	array3D[2][2][1] = (char *)"PLATJA I VEURE DE LLUNY ELS DOFINS";
	//DOFÍ-CACTUS
	array3D[3][0][0] = (char *)"A CLASSE DE PLASTIC M'HAN FET";
	array3D[3][0][1] = (char *)"DIBUIXAR UN DOFÍ I UN CACTUS";
	array3D[3][1][0] = (char *)"ELS DOFINS VIUEN AL MAR, I ELS";
	array3D[3][1][1] = (char *)"CACTUS CREIXEN AL DESERT";
	array3D[3][2][0] = (char *)"ALS DOFINS ELS AGRADA MOLT L'AIGUA";
	array3D[3][2][1] = (char *)"I ELS CACTUS VOLEN CLIMA SEC";
	//DOFÍ-NENA
	array3D[4][0][0] = (char *)"UNA NENA DE LA CLASSE M'HA CONVIDAT";
	array3D[4][0][1] = (char *)"AL ZOO. VOL VEURE ELS DOFINS";
	array3D[4][1][0] = (char *)"LES NENES HAN VOTAT PER DOFINS,";
	array3D[4][1][1] = (char *)"I ELS NENS HAN VOTAT SPIDERMANS";
	array3D[4][2][0] = (char *)"LES NENES ES PENTINEN, I ELS DOFINS";
	array3D[4][2][1] = (char *)"NO PERQUÈ NO TENEN NI UN SOL PÈL";
	//DOFÍ-TRICICLE
	array3D[5][0][0] = (char *)"ELS DOFINS NO TENEN CAMES, I PER";
	array3D[5][0][1] = (char *)"TANT NO SABEN ANAR EN TRICICLE";
	array3D[5][1][0] = (char *)"TINC UNA ENGANXINA D'UN DOFÍ. ME";
	array3D[5][1][1] = (char *)"LA POSARÉ AL TRICICLE";
	array3D[5][2][0] = (char *)"VAIG TAN RÀPID AMB EL TRICICLE QUE";
	array3D[5][2][1] = (char *)"PODRIA FER UNA CURSA AMB UN DOFÍ";
	//DOFÍ-CONILL
	array3D[6][0][0] = (char *)"ELS DOFINS VIUEN AL MAR,";
	array3D[6][0][1] = (char *)"I ELS CONILLS A LA MUNTANYA";
	array3D[6][1][0] = (char *)"M'AGRADA LA CARN DE CONILL, I LA";
	array3D[6][1][1] = (char *)"DE DOFÍ NO HO SÉ PERQUÈ NO ES VEN";
	array3D[6][2][0] = (char *)"DOFINS I CONILLS SÓN MOLT RÀPIDS.";
	array3D[6][2][1] = (char *)"UNS NEDEN I ELS ALTRES CORREN";
	//DOFÍ-ÀNEC
	array3D[7][0][0] = (char *)"EL DOFÍ SAP FER UN SOROLL QUE A";
	array3D[7][0][1] = (char *)"VEGADES SEMBLA EL D'UN ÀNEC";
	array3D[7][1][0] = (char *)"ELS DOFINS SÓN MAMÍFERS QUE VIUEN";
	array3D[7][1][1] = (char *)"A L'AIGUA. ELS ÀNECS SÓN OCELLS";
	array3D[7][2][0] = (char *)"DOFINS I ÀNECS S'ASSEMBLEN COM";
	array3D[7][2][1] = (char *)"GATS I GOSSOS: GENS NI MICA";
	//DOFÍ-TAMBOR
	array3D[8][0][0] = (char *)"CADA COP QUE EL MONITOR TOCAVA";
	array3D[8][0][1] = (char *)"EL TAMBOR EL DOFÍ FEIA UN SALT";
	array3D[8][1][0] = (char *)"EL DOFÍ HA APRÈS A SALTAR I TOCAR";
	array3D[8][1][1] = (char *)"AMB LA CUA UN TAMBOR QUE HAN PENJAT";
	array3D[8][2][0] = (char *)"EL TAMBOR DE JOGUINA TÉ MOLTS";
	array3D[8][2][1] = (char *)"DIBUIXOS D'ANIMALS: DOFINS, TIGRES";
	//DOFÍ-GOS
	array3D[9][0][0] = (char *)"AL GOS NO LI AGRADA GENS L'AIGUA,";
	array3D[9][0][1] = (char *)"I EL GAT NEDA COM UN DOFÍ";
	array3D[9][1][0] = (char *)"ELS GOSSOS VAN PER TERRA, I ELS";
	array3D[9][1][1] = (char *)"DOFINS VAN PER L'AIGUA";
	array3D[9][2][0] = (char *)"EL GOS ES QUEDA EMBADALIT MIRANT";
	array3D[9][2][1] = (char *)"LA TELE, VEIENT COM NEDA EL DOFI";
	//DOFÍ-PINGÜÍ
	array3D[10][0][0] = (char *)"ELS DOFINS I ELS PINGÜINS SÓN";
	array3D[10][0][1] = (char *)"ANIMALS QUE NEDEN MOLT BÉ";
	array3D[10][1][0] = (char *)"AL PINGÜÍ LI AGRADA L'AIGUA MOLT";
	array3D[10][1][1] = (char *)"FREDA, I EL DOFÍ LA VOL CALENTA";
	array3D[10][2][0] = (char *)"ELS PINGÜINS TENEN PÈL, I ELS";
	array3D[10][2][1] = (char *)"DOFINS UNA PELL QUE PATINA";
	//COTXE-NEN
	array3D[11][0][0] = (char *)"EL NEN NO PARA DE DEMANAR UN COTXE";
	array3D[11][0][1] = (char *)"PER REIS. SEGUR QUE LI'N PORTEN UN";
	array3D[11][1][0] = (char *)"AL NEN LI AGRADEN ELS COTXES DE";
	array3D[11][1][1] = (char *)"COLOR VERMELL, I AL SEU COSI BLAUS";
	array3D[11][2][0] = (char *)"AL NEN LI AGRADEN LES NINES, I A";
	array3D[11][2][1] = (char *)"LA SEVA GERMANA ELS COTXES";
	//COTXE-CADIRA
	array3D[12][0][0] = (char *)"M'AGRADA FER PASSAR EL COTXE PER";
	array3D[12][0][1] = (char *)"SOTA LA CADIRA. ES MOLT DIVERTIT!!";
	array3D[12][1][0] = (char *)"HE ENCLASTAT EL COTXE CONTRA LA";
	array3D[12][1][1] = (char *)"CADIRA I SE LI HA TRENCAT LA PORTA";
	array3D[12][2][0] = (char *)"HE MUNTAT UN TOBOGAN PER FER BAIXAR";
	array3D[12][2][1] = (char *)"EL COTXE DES DE DALT LA CADIRA.";
	//COTXE-CACTUS
	array3D[13][0][0] = (char *)"ESTAVA JUGANT AMB EL COTXE, I M'HE";
	array3D[13][0][1] = (char *)"PUNXAT EL CUL AMB EL CACTUS";
	array3D[13][1][0] = (char *)"EL COTXE HA PASSAT PER SOBRE DEL";
	array3D[13][1][1] = (char *)"CACTUS I SE LI HA PUNXAT UNA RODA";
	array3D[13][2][0] = (char *)"HE MUNTAT AMB ELS TESTS DE CACTUS";
	array3D[13][2][1] = (char *)"UN CIRCUIT PER ALS MEUS COTXES";
	//COTXE-NENA
	array3D[14][0][0] = (char *)"EL PARE DE LA NENA";
	array3D[14][0][1] = (char *)"TÉ UN COTXE DE COLOR VERMELL";
	array3D[14][1][0] = (char *)"A LA NENA LI AGRADA POSAR-SE AL";
	array3D[14][1][1] = (char *)"VOLANT DEL COTXE AMB EL SEU PARE";
	array3D[14][2][0] = (char *)"PER L'ANIVERSARI LA NENA HA";
	array3D[14][2][1] = (char *)"DEMANAT UN COTXE DE BOMBERS";
	//COTXE-TRICICLE
	array3D[15][0][0] = (char *)"EL COTXE TÉ QUATRE RODES, EN CANVI";
	array3D[15][0][1] = (char *)"EL TRICICLE EN TÉ TRES DE RODES";
	array3D[15][1][0] = (char *)"QUAN ERA PETIT TENIA UN TRICICLE,I";
	array3D[15][1][1] = (char *)"ARA QUE SÓC GRAN VAIG EN COTXE";
	array3D[15][2][0] = (char *)"LA CITROËN HA CONSTRUÏT UN TRICICLE";
	array3D[15][2][1] = (char *)"QUE VA MÉS RÀPID QUE ELS COTXES";
	//COTXE-CONILL
	array3D[16][0][0] = (char *)"EL CONDUCTOR DEL COTXE VA TREPITJAR";
	array3D[16][0][1] = (char *)"LA CUA DEL CONILL. QUIN MAL!";
	array3D[16][1][0] = (char *)"ELS CONILLS PODEN CÓRRER MÉS RÀPID";
	array3D[16][1][1] = (char *)"QUE UN COTXE.I LES LLEBRES MOLT MÉS";
	array3D[16][2][0] = (char *)"AL REMOLC DEL COTXE HI VA UN GOS";
	array3D[16][2][1] = (char *)"QUE LI AGRADA EMPAITAR CONILLS";
	//COTXE-ÀNEC
	array3D[17][0][0] = (char *)"ANAVA AMB COTXE QUAN DE COP I VOLTA";
	array3D[17][0][1] = (char *)"HA PASSAT UN ÀNEC DAVANT DEL VIDRE";
	array3D[17][1][0] = (char *)"PAPA! ATURA EL COTXE, QUE VULL";
	array3D[17][1][1] = (char *)"VEURE COM NEDEN ELS ÀNECS AL LLAC";
	array3D[17][2][0] = (char *)"ALS ÀNECS DE LA GRANJA HAN TROBAT";
	array3D[17][2][1] = (char *)"UN BON AMAGATALL SOTA EL COTXE";
	//COTXE-TAMBOR
	array3D[18][0][0] = (char *)"EL NEN SEMPRE PORTA UN TAMBOR A";
	array3D[18][0][1] = (char *)"DINS EL COTXE, I AIXÍ S'ENTRETÉ";
	array3D[18][1][0] = (char *)"AQUELL COTXE FA TAN DE SOROLL QUE";
	array3D[18][1][1] = (char *)"SEMBLA UN EXÈRCIT DE TAMBORS!";
	array3D[18][2][0] = (char *)"ELS TAMBORERS DE LA FESTA MAJOR";
	array3D[18][2][1] = (char *)"PORTAVEN EL COTXE A REBENTAR";
	//COTXE-GOS
	array3D[19][0][0] = (char *)"EL GOS SEMPRE ES MAREJA QUAN EL";
	array3D[19][0][1] = (char *)"FAN PUJAR DALT DEL COTXE";
	array3D[19][1][0] = (char *)"EL COTXE PORTA UN REMOLC AL DARRERE";
	array3D[19][1][1] = (char *)"I AIXÍ EL GOS VA MOLT CÒMODE";
	array3D[19][2][0] = (char *)"EL GOS DEL CAÇADOR SURT DEL COTXE";
	array3D[19][2][1] = (char *)"I COMENÇA A EMPAITAR CONILLS";
	//COTXE-PINGÜÍ
	array3D[20][0][0] = (char *)"EL NEN TÉ UN PINGÜÍ DE PELUIX QUE";
	array3D[20][0][1] = (char *)"EL DISTREU EN EL COTXE";
	array3D[20][1][0] = (char *)"EL MEU PARE PORTA EN EL COTXE UN";
	array3D[20][1][1] = (char *)"ADHESIU D'UN PINGÜÍ DE COLOR NEGRE";
	array3D[20][2][0] = (char *)"MOLTS PINGÜINS ESTAVEN AL CAMÍ";
	array3D[20][2][1] = (char *)"I ELS COTXES S'HAVIEN D'ESPERAR";
	//NEN-CADIRA
	array3D[21][0][0] = (char *)"EL NEN NO SEIA BÉ A LA CADIRA I EL";
	array3D[21][0][1] = (char *)"PARE S'ENFADAVA DE VALENT";
	array3D[21][1][0] = (char *)"NEN! SEU BÉ A LA CADIRA O ET FARÀS";
	array3D[21][1][1] = (char *)"MAL! AQUESTA CADIRA ESTÀ COIXA!";
	array3D[21][2][0] = (char *)"EL NEN TENIA A LA SEVA HABITACIÓ";
	array3D[21][2][1] = (char *)"UNA CADIRA BLAVA, I LA NENA VERDA";
	//NEN-CACTUS
	array3D[22][0][0] = (char *)"EL NEN ÉS UN DESPISTAT, I S'HA";
	array3D[22][0][1] = (char *)"PUNXAT EL CUL AMB EL CACTUS";
	array3D[22][1][0] = (char *)"LA MARE HA TRET EL CACTUS DEL MIG";
	array3D[22][1][1] = (char *)"PERQUÈ EL NEN NO ES FACI MAL";
	array3D[22][2][0] = (char *)"EL NEN HA APRÈS A L'ESCOLA QUE HI";
	array3D[22][2][1] = (char *)"HA CACTUS DE MOLTES MIDES I FORMES";
	//NEN-NENA
	array3D[23][0][0] = (char *)"AL NEN LI AGRADA JUGAR A CUINETES,";
	array3D[23][0][1] = (char *)"I LA NENA SEMPRE VOL JUGAR A PILOTA";
	array3D[23][1][0] = (char *)"EL NEN I LA NENA VAN ANAR A VEURE";
	array3D[23][1][1] = (char *)"ELS PASTORETS AMB ELS PARES";
	array3D[23][2][0] = (char *)"EL NEN FA P5, I LA NENA JA FA";
	array3D[23][2][1] = (char *)"SEGON. QUE GRANS QUE ES FAN!!";
	//NEN-TRICICLE
	array3D[24][0][0] = (char *)"EL JOC PREFERIT DEL NEN ÉS EL";
	array3D[24][0][1] = (char *)"TRICICLE QUE LI VAN PORTAR ELS REIS";
	array3D[24][1][0] = (char *)"ELS NENS SEMPRE APRENEN A ANAR AMB";
	array3D[24][1][1] = (char *)"TRICICLE ABANS QUE AMB BICICLETA";
	array3D[24][2][0] = (char *)"EL NEN HA DIBUIXAT UN TRICICLE AMB";
	array3D[24][2][1] = (char *)"DUES RODES. NO POT SER!";
	//NEN-CONILL
	array3D[25][0][0] = (char *)"EL NEN TÉ UN CONILL DE PELUIX, QUE";
	array3D[25][0][1] = (char *)"LI FA COMPANYIA PER ANAR A DORMIR";
	array3D[25][1][0] = (char *)"ELS NENS VAN VISITAR UNA GRANJA DE";
	array3D[25][1][1] = (char *)"CONILLS, I VAN ACARICIAR-LOS";
	array3D[25][2][0] = (char *)"EL NEN ESTAVA BUSCANT BOLETS, I DE";
	array3D[25][2][1] = (char *)"COP I VOLTA VA SORTIR UN CONILL";
	//NEN-ÀNEC
	array3D[26][0][0] = (char *)"ELS DIBUIXOS QUE LI AGRADEN MÉS AL";
	array3D[26][0][1] = (char *)"NEN SÓN ELS DE L'ÀNEC DONALD";
	array3D[26][1][0] = (char *)"EL NEN ESTAVA APRENENT A PARLAR, I";
	array3D[26][1][1] = (char *)"DEIA QUAC!, COM FAN ELS ÀNECS";
	array3D[26][2][0] = (char *)"NEN! VÉS AMB COMPTE AMB AQUEST ÀNEC";
	array3D[26][2][1] = (char *)"QUE ET POT MOSSEGAR EL DIT";
	//NEN-TAMBOR
	array3D[27][0][0] = (char *)"EL NEN NO PARAVA DE TOCAR EL";
	array3D[27][0][1] = (char *)"TAMBOR. QUINA PALLISSA!!";
	array3D[27][1][0] = (char *)"EL NEN HA DEMANAT UN TAMBOR PER";
	array3D[27][1][1] = (char *)"REIS. ELS PARES ESTAN ESPANTATS!";
	array3D[27][2][0] = (char *)"EL TAMBORER DEL BRUC ERA UN NEN";
	array3D[27][2][1] = (char *)"QUE TENIA DOTZE ANYS.";
	//NEN-GOS
	array3D[28][0][0] = (char *)"AL NEN NO LI AGRADEN ELS GOSSOS QUE";
	array3D[28][0][1] = (char *)"BORDEN. PERÒ EL MEU NO BORDA";
	array3D[28][1][0] = (char *)"ELS GOSSOS SABEN QUE NO PODEN";
	array3D[28][1][1] = (char *)"LLEPAR ELS NENS A LA CARA.";
	array3D[28][2][0] = (char *)"EL GOS HA FET UNA LLEPADA";
	array3D[28][2][1] = (char *)"LLEFISCOSA AL NEN. QUIN FÀSTIC!";
	//NEN-PINGÜÍ
	array3D[29][0][0] = (char *)"ELS NENS DE L'ESCOLA VAN ANAR AL";
	array3D[29][0][1] = (char *)"ZOO I VAN DIBUIXAR UN PINGÜÍ";
	array3D[29][1][0] = (char *)"EL NEN TÉ UN LLIBRE DE PINGÜINS";
	array3D[29][1][1] = (char *)"QUE EXPLICA COM VIUEN A L'ANTÀRTIDA";
	array3D[29][2][0] = (char *)"EL NEN HA APRÈS A L'ESCOLA QUE ELS";
	array3D[29][2][1] = (char *)"PINGÜINS SÓN OCELLS QUE NO VOLEN";
	//CADIRA-CACTUS
	array3D[30][0][0] = (char *)"AMAGA AQUEST CACTUS A SOTA DE LA";
	array3D[30][0][1] = (char *)"CADIRA, I AIXÍ NO ENS PUNXAREM";
	array3D[30][1][0] = (char *)"HE CANVIAT LES PLANTES DE LLOC. EL";
	array3D[30][1][1] = (char *)"CACTUS L'HE POSAT SOBRE DE LA CADIRA";
	array3D[30][2][0] = (char *)"FAIG UNA BROMA AL PAPA. POSO EL";
	array3D[30][2][1] = (char *)"CACTUS A LA CADIRA PERQUÈ ES PUNXI";
	//CADIRA-NENA
	array3D[31][0][0] = (char *)"LA NENA NO VOLIA SEURE A LA CADIRA";
	array3D[31][0][1] = (char *)"I EL PARE ES VA ENFADAR";
	array3D[31][1][0] = (char *)"LA NENA SAP QUE S'HA DE SEURE A LA";
	array3D[31][1][1] = (char *)"CADIRA AMB L'ESQUENA BEN RECTA";
	array3D[31][2][0] = (char *)"LA NENA HA CAIGUT DE LA CADIRETA";
	array3D[31][2][1] = (char *)"PERQUÈ NO ESTAVA LLIGADA";
	//CADIRA-TRICICLE
	array3D[32][0][0] = (char *)"LA CADIRA DEL TRICICLE ERA MOLT";
	array3D[32][0][1] = (char *)"INCÒMODA, I FEIA MAL AL CUL";
	array3D[32][1][0] = (char *)"EL TRICICLE TÉ UNA CADIRA QUE ES";
	array3D[32][1][1] = (char *)"POT AJUSTAR A L'ALÇADA";
	array3D[32][2][0] = (char *)"ANAVA TAN RÀPID AMB EL TRICICLE";
	array3D[32][2][1] = (char *)"QUE HE XOCAT CONTRA UNA CADIRA!!";
	//CADIRA-CONILL
	array3D[33][0][0] = (char *)"EL CONILL DE PELUIX NO S'HA PERDUT.";
	array3D[33][0][1] = (char *)"ESTÀ SOBRE DE LA CADIRA, NO PLORIS!";
	array3D[33][1][0] = (char *)"EL CONILLET D'ÍNDIES FEIA UN";
	array3D[33][1][1] = (char *)"CIRCUIT PER LES POTES DE LA CADIRA";
	array3D[33][2][0] = (char *)"LA CADIRA DE L'HABITACIÓ ESTÀ PLENA";
	array3D[33][2][1] = (char *)"DE CONILLETS DE PELUIX";
	//CADIRA-ÀNEC
	array3D[34][0][0] = (char *)"L'ÀNEC DE L'ESTANY VOLIA REPOSAR,";
	array3D[34][0][1] = (char *)"I ES VA POSAR SOBRE LA CADIRA";
	array3D[34][1][0] = (char *)"FEIA UNA COCA-COLA A LA CADIRA DEL";
	array3D[34][1][1] = (char *)"BAR, I VA VENIR UN ÀNEC A EMPRENYAR";
	array3D[34][2][0] = (char *)"L'ÀNEC MOSSEGAVA LA POTA DE LA";
	array3D[34][2][1] = (char *)"CADIRA. POTSER LI FA MAL EL BEC";
	//CADIRA-TAMBOR
	array3D[35][0][0] = (char *)"EL TAMBOR NO S'HA PERDUT. L'HAS";
	array3D[35][0][1] = (char *)"DEIXAT A SOBRE DE LA CADIRA.";
	array3D[35][1][0] = (char *)"POTS TOCAR EL TAMBOR DRET, O";
	array3D[35][1][1] = (char *)"ASSEGUT A LA CADIRA. COM VULGUIS";
	array3D[35][2][0] = (char *)"LA POTA DE LA CADIRA ES VA TRENCAR,";
	array3D[35][2][1] = (char *)"I SERVIA PER TOCAR EL TAMBOR";
	//CADIRA-GOS
	array3D[36][0][0] = (char *)"EL LLOC PREFERIT DEL GOS ÉS LA";
	array3D[36][0][1] = (char *)"CADIRA QUE HI HA A LA CUINA";
	array3D[36][1][0] = (char *)"EL GOS SEMPRE S'AMAGA A SOTA DE ";
	array3D[36][1][1] = (char *)"LA CADIRA. ARA JA HO SÉ";
	array3D[36][2][0] = (char *)"EL GOS SEMPRE LLEPA LA POTA DE LA";
	array3D[36][2][1] = (char *)"CADIRA. ES PENSA QUE ÉS UN XUPA-XUP";
	//CADIRA-PINGÜÍ
	array3D[37][0][0] = (char *)"ERA UN ROBOT AMB FORMA DE PINGÜÍ";
	array3D[37][0][1] = (char *)"QUE XOCAVA CONTRA LA CADIRA";
	array3D[37][1][0] = (char *)"LA MARIA I EL PERE TENEN UN PINGÜÍ";
	array3D[37][1][1] = (char *)"DE PELUIX. AQUELL DE LA CADIRA";
	array3D[37][2][0] = (char *)"ELS PINGÜINS NO TENEN CUL, NO";
	array3D[37][2][1] = (char *)"SABRIEN SEURE EN UNA CADIRA!";
	//CACTUS-NENA
	array3D[38][0][0] = (char *)"NENA! VIGILA NO ET PUNXIS AMB";
	array3D[38][0][1] = (char *)"EL CACTUS. ET FARIES MAL";
	array3D[38][1][0] = (char *)"LA NENA HA DIBUIXAT UN CACTUS QUE";
	array3D[38][1][1] = (char *)"HA VIST EN UNS DIBUIXOS ANIMATS";
	array3D[38][2][0] = (char *)"LA NENA ANAVA AMB BICI I SE LI HA";
	array3D[38][2][1] = (char *)"PUNXAT LA RODA AMB UN CACTUS";
	//CACTUS-TRICICLE
	array3D[39][0][0] = (char *)"ANAVA MOLT RÀPIC AMB EL TRICICLE";
	array3D[39][0][1] = (char *)"I HE XOCAT CONTRA UN CACTUS.";
	array3D[39][1][0] = (char *)"EL TRICICLE HA XOCAT CONTRA UN";
	array3D[39][1][1] = (char *)"CACTUS I L'HA BEN DESTROSSAT";
	array3D[39][2][0] = (char *)"SEMPRE HI HA COSES AL MIG! AQUEST";
	array3D[39][2][1] = (char *)"CACTUS! AQUEST TRICICLE! ...";
	//CACTUS-CONILL
	array3D[40][0][0] = (char *)"ELS CONILLS MENGEN PLANTES, PERÒ";
	array3D[40][0][1] = (char *)"EM SEMBLA QUE DE CACTUS NO EN VOLEN";
	array3D[40][1][0] = (char *)"SI ELS CACTUS NO TINGUESSIN PUNXES,";
	array3D[40][1][1] = (char *)"POTSER ELS CONILLS EN MENJARIEN";
	array3D[40][2][0] = (char *)"NO SIGUIS DOLENT I TREU EL CACUTS";
	array3D[40][2][1] = (char *)"DE DINS LA GÀBIA DEL CONILL";
	//CACTUS-ÀNEC
	array3D[41][0][0] = (char *)"L'ÀNEC VA ATERRISSAR SOBRE UN CAMP";
	array3D[41][0][1] = (char *)"QUE ESTAVA PLE DE CACTUS. QUIN MAL!";
	array3D[41][1][0] = (char *)"ELS ÀNECS MENGEN MOLTES COSES";
	array3D[41][1][1] = (char *)"DIFERENTS, PERÒ CACTUS NO!";
	array3D[41][2][0] = (char *)"HA POSAT L'ÀNEC DE PELUIX A SOBRE";
	array3D[41][2][1] = (char *)"DEL CACTUS. QUINA POCA GRÀCIA.";
	//CACTUS-TAMBOR
	array3D[42][0][0] = (char *)"EL TAMBOR ESTÀ FET DE PELL DE VACA";
	array3D[42][0][1] = (char *)"I ES POT FER MALBÉ AMB EL CACTUS";
	array3D[42][1][0] = (char *)"FA SERVIR EL CACTUS COM SI FOS UN";
	array3D[42][1][1] = (char *)"PENJADOR. MIRA ON ÉS EL TAMBOR!";
	array3D[42][2][0] = (char *)"QUINA DECORACIÓ MÉS RARA QUE TÉ A";
	array3D[42][2][1] = (char *)"CASA: UN TAMBOR, UN CACTUS,...";
	//CACTUS-GOS
	array3D[43][0][0] = (char *)"EL GOS VOL ENSUMAR EL CACTUS, I";
	array3D[43][0][1] = (char *)"S'HA FET MAL AL MUSELL.";
	array3D[43][1][0] = (char *)"AQUELL CACTUS FA BONA OLOR, I EL";
	array3D[43][1][1] = (char *)"GOS SEMPRE L'ESTÀ ENSUMANT";
	array3D[43][2][0] = (char *)"EL GOS NO ES FIXAVA PER ON ANAVA I";
	array3D[43][2][1] = (char *)"ES VA PUNXAR AMB EL CACTUS";
	//CACTUS-PINGÜÍ
	array3D[44][0][0] = (char *)"ON VIUEN ELS PINGÜINS FA FRED, I";
	array3D[44][0][1] = (char *)"ON VIUEN ELS CACUTS FA CALOR";
	array3D[44][1][0] = (char *)"EN EL ZOO HAN POSAT CACTUS PER";
	array3D[44][1][1] = (char *)"DECORAR LA CASETA DELS PINGÜINS";
	array3D[44][2][0] = (char *)"ELS PINGUINS TENEN LA PELL SUAU,";
	array3D[44][2][1] = (char *)"I ELS CACTUS LA TENEN RUGOSA.";
	//NENA-TRICICLE
	array3D[45][0][0] = (char *)"LA NENA JA VA AMB BICICLETA, PERÒ";
	array3D[45][0][1] = (char *)"MAI VA SABER ANAR AMB TRICICLE";
	array3D[45][1][0] = (char *)"EL TRICICLE VERMELL ÉS LA JOGUINA";
	array3D[45][1][1] = (char *)"PREFERIDA DE LA NENA AMB TRENES";
	array3D[45][2][0] = (char *)"LA NENA QUE VA AMB EL TRICICLE";
	array3D[45][2][1] = (char *)"ÉS GERMANA DEL MEU MILLOR AMIC";
	//NENA-CONILL
	array3D[46][0][0] = (char *)"LA NENA TENIA UN CONILL DE PELUIX.";
	array3D[46][0][1] = (char *)"EL VA PERDRE I NO PARAVA DE PLORAR";
	array3D[46][1][0] = (char *)"A LA NENA LI VAN COMPRAR UN";
	array3D[46][1][1] = (char *)"CONILLET D'ÍNDIES, QUE CUIDAVA MOLT";
	array3D[46][2][0] = (char *)"LA NENA COLLIA MADUIXES, I DE SOBTE";
	array3D[46][2][1] = (char *)"VA SORTIR UN CONILL BEN GROS.";
	//NENA-ÀNEC
	array3D[47][0][0] = (char *)"LA NENA HA DIBUIXAT L'ÀNEC DONALD.";
	array3D[47][0][1] = (char *)"LI HA QUEDAT MOLT BÉ!";
	array3D[47][1][0] = (char *)"ESCOLTA NENA: QUAN PINTIS L'ÀNEC";
	array3D[47][1][1] = (char *)"DONALD FIXA'T DE NO SORTIR DE LÍNIA";
	array3D[47][2][0] = (char *)"LA NENA TÉ UN ÀNEC DE PELUIX, I EL";
	array3D[47][2][1] = (char *)"NEN PREFEREIX ELS DINOSAURES";
	//NENA-TAMBOR
	array3D[48][0][0] = (char *)"A LA NENA LI AGRADA TOCAR EL";
	array3D[48][0][1] = (char *)"TAMBOR. LI'N COMPRARÉ UN DE GROS";
	array3D[48][1][0] = (char *)"AQUELL TAMBOR ÉS TAN GROS QUE LA";
	array3D[48][1][1] = (char *)"NENA NO EL POT ARROSSEGAR";
	array3D[48][2][0] = (char *)"EL TAMBOR FEIA TAN SOROLL QUE LA";
	array3D[48][2][1] = (char *)"NENA NO PARAVA DE PLORAR";
	//NENA-GOS
	array3D[49][0][0] = (char *)"A LA NENA PETITA NO LI AGRADEN ELS";
	array3D[49][0][1] = (char *)"GOSSOS. JA ES FARÀ GRAN";
	array3D[49][1][0] = (char *)"EL NEN I LA NENA VOLEN TENIR UN GOS";
	array3D[49][1][1] = (char *)"PERÒ ALS PARES NO ELS FA GRACIA";
	array3D[49][2][0] = (char *)"EL GOS FA FER UN LLADRUC A LA NENA,";
	array3D[49][2][1] = (char *)"I ES VA POSAR A PLORAR DE VALENT";
	//NENA-PINGÜÍ
	array3D[50][0][0] = (char *)"A L'ESCOLA LA NENA HA DIBUIXAT";
	array3D[50][0][1] = (char *)"UN PINGÜÍ QUE LI HA QUEDAT MOLT BÉ";
	array3D[50][1][0] = (char *)"LA NENA VA A LA CLASSE DELS";
	array3D[50][1][1] = (char *)"PINGÜINS, QUÈ DIVERTIT!";
	array3D[50][2][0] = (char *)"LA NENA MIRAVA UN CONTE ON SORTIA";
	array3D[50][2][1] = (char *)"UN PINGÜÍ MOLT EIXERIT";
	//TRICICLE-CONILL
	array3D[51][0][0] = (char *)"EL NEN SEMPRE CARREGA AL TRICICLE";
	array3D[51][0][1] = (char *)"EL SEU CONILL DE PELUIX";
	array3D[51][1][0] = (char *)"LA JOGUINA QUE M'HAN REGALAT ÉS";
	array3D[51][1][1] = (char *)"UN CONILL QUE VA EN TRICICLE";
	array3D[51][2][0] = (char *)"EL CONILLET D'ÍNDIES ES VA AMAGAR";
	array3D[51][2][1] = (char *)"ENTRE LES RODES DEL TRICICLE";
	//TRICICLE-ÀNEC
	array3D[52][0][0] = (char *)"A L'ÀNEC DE LA GRANJA LI AGRADA";
	array3D[52][0][1] = (char *)"PICAR LES RODES DEL TRICICLE";
	array3D[52][1][0] = (char *)"EL PERE CARREGA L'ÀNEC DE PLÀSTIC";
	array3D[52][1][1] = (char *)"EN EL CARRETÓ DEL TRICICLE";
	array3D[52][2][0] = (char *)"HE ANAT ALS CAVALLITOS. PRIMER AL";
	array3D[52][2][1] = (char *)"TRICICLE I DESPRÉS A L'ÀNEC GEGANT";
	//TRICICLE-TAMBOR
	array3D[53][0][0] = (char *)"LA MARIA PREFEREIX ANAR AMB";
	array3D[53][0][1] = (char *)"TRICILE, I EL PERE VOL EL TAMBOR";
	array3D[53][1][0] = (char *)"EL PERE TOCA FORT EL TAMBOR TOT";
	array3D[53][1][1] = (char *)"PEDALANT SOBRE EL TRICICLE";
	array3D[53][2][0] = (char *)"T'HE DIT QUE NO PIQUIS EL";
	array3D[53][2][1] = (char *)"TRICICLE! NO ÉS CAP TAMBOR!";
	//TRICICLE-GOS
	array3D[54][0][0] = (char *)"EL GOS SEMPRE EMPAITA EL TRICICLE,";
	array3D[54][0][1] = (char *)"I EL PERE ESTÀ BEN ESPANTAT!";
	array3D[54][1][0] = (char *)"EL TRICICLE TÉ UN REMOLC, I AL GOS";
	array3D[54][1][1] = (char *)"LI AGRADA MOLT PUJAR-HI";
	array3D[54][2][0] = (char *)"EL GOS HA TROBAT UN BON LLOC PER";
	array3D[54][2][1] = (char *)"FER LA MIGDIADA: SOTA EL TRICICLE";
	//TRICICLE-PINGÜÍ
	array3D[55][0][0] = (char *)"EN EL REMOLC DEL TRICICLE EL PERE";
	array3D[55][0][1] = (char *)"HI CARREGA TOTS ELS PINGÜINS QUE TÉ";
	array3D[55][1][0] = (char *)"A P5 HI HA DUES CLASSES: LA DELS";
	array3D[55][1][1] = (char *)"PINGÜINS I LA DELS TRICICLES";
	array3D[55][2][0] = (char *)"EL NÚMERO DE CIRC CONSISTEIX EN QUÈ";
	array3D[55][2][1] = (char *)"EL PINGÜÍ PUJA DALT DEL TRICICLE";
	//CONILL-ÀNEC
	array3D[56][0][0] = (char *)"QUÈ VOLS PEL DINAR DE NADAL? CONILL";
	array3D[56][0][1] = (char *)"DE BOSC O ÀNEC FARCIT DE PRUNES?";
	array3D[56][1][0] = (char *)"ALS CONILLS NO ELS AGRADA GENS";
	array3D[56][1][1] = (char *)"L'AIGUA,I ELS ÀNECS BEN AL CONTRARI";
	array3D[56][2][0] = (char *)"ELS CONILLS TENEN PÈLS, I ELS ÀNECS";
	array3D[56][2][1] = (char *)"PLOMES. PERÒ TOTS DOS SÓN SUAUS";
	//CONILL-TAMBOR
	array3D[57][0][0] = (char *)"EL TAMBOR DE JOGUINA TENIA DIBUIXAT";
	array3D[57][0][1] = (char *)"UNS QUANTS CONILLS AMB BAQUETES";
	array3D[57][1][0] = (char *)"ELS HOMES ANTICS CONSTRUÏEN TAMBORS";
	array3D[57][1][1] = (char *)"AMB PELLS DE CONILL I DE CABRA";
	array3D[57][2][0] = (char *)"NO PARA DE TOCAR EL TAMBOR I EL";
	array3D[57][2][1] = (char *)"CONILL D'ÍNDIES ESTÀ BEN ESPANTAT!";
	//CONILL-GOS
	array3D[58][0][0] = (char *)"EN UNA GRANJA SEGUR QUE TROBARÀS";
	array3D[58][0][1] = (char *)"CONILLS, GOSSOS, VAQUES I OVELLES";
	array3D[58][1][0] = (char *)"AQUELL GOS CAÇADOR FA MOLT MALAMENT";
	array3D[58][1][1] = (char *)"LA SEVA FEINA: TÉ POR DELS CONILLS";
	array3D[58][2][0] = (char *)"TANT ELS GOSSOS COM ELS CONILLS SÓN";
	array3D[58][2][1] = (char *)"MAMÍFERS: TENEN PETITONS QUE MAMEN";
	//CONILL-PINGÜÍ
	array3D[59][0][0] = (char *)"ELS CONILLS I ELS PINGÜINS EREN ELS";
	array3D[59][0][1] = (char *)"MEUS PELUIXOS QUAN ERA PETIT";
	array3D[59][1][0] = (char *)"EL MESTRE ENS HA DONAT FEINA PER";
	array3D[59][1][1] = (char *)"DEMÀ: PINTAR UN CONILL I UN PINGÜÍ";
	array3D[59][2][0] = (char *)"QUIN PESSEBRE MÉS DIVERTIT! HEM";
	array3D[59][2][1] = (char *)"POSAT UN CONILL I UN PINGÜÍ!!";
	//ÀNEC-TAMBOR
	array3D[60][0][0] = (char *)"QUIN ÀNEC MÉS LLEST! TOCA EL";
	array3D[60][0][1] = (char *)"TAMBOR PICANT AMB EL BEC!!";
	array3D[60][1][0] = (char *)"L'ÀNEC FA UN SOROLL QUE EM POSA";
	array3D[60][1][1] = (char *)"MÉS NERVIÓS QUE EL TOC DEL TAMBOR";
	array3D[60][2][0] = (char *)"VULL ARRENCAR UNA PLOMA A L'ÀNEC";
	array3D[60][2][1] = (char *)"I FICAR-LA PER DECORAR EL TAMBOR";
	//ÀNEC-GOS
	array3D[61][0][0] = (char *)"EL GOS SEMPRE EMPAITA L'ÀNEC.";
	array3D[61][0][1] = (char *)"SEMBLA QUE NO LI DONGUEM MENJAR!";
	array3D[61][1][0] = (char *)"EL GOS ÉS MANYAC. EN CANVI, SI ET";
	array3D[61][1][1] = (char *)"DESCUIDES L'ÀNEC ET MOSSEGARÀ!";
	array3D[61][2][0] = (char *)"QUÈ DIVERTIT VEURE EL GOS EMPAITANT";
	array3D[61][2][1] = (char *)"L'ÀNEC A DINS DE L'ESTANY!";
	//ÀNEC-PINGÜÍ
	array3D[62][0][0] = (char *)"ALS ÀNECS I ALS PINGÜIS ELS AGRADA";
	array3D[62][0][1] = (char *)"L'AIGUA, PERÒ NEDEN MOLT DIFERENT";
	array3D[62][1][0] = (char *)"ÀNECS I PINGÜINS SÓN OCELLS. ARA BÉ,";
	array3D[62][1][1] = (char *)"ELS ÀNECS VOLEN I ELS PINGÜINS NO";
	array3D[62][2][0] = (char *)"ELS PINGÜINS SÓN BLANCS I NEGRES.";
	array3D[62][2][1] = (char *)"ELS ÀNECS PODEN SER DE MOLTS COLORS";
	//TAMBOR-GOS
	array3D[63][0][0] = (char *)"EL GOS NO PARA D'ENSUMAR EL TAMBOR.";
	array3D[63][0][1] = (char *)"SEGUR QUE HI HA AMAGADA ALGUNA COSA";
	array3D[63][1][0] = (char *)"QUÈ DIVERTIT! EL GOS TOCA EL TAMBOR";
	array3D[63][1][1] = (char *)"REMENANT LA CUA!";
	array3D[63][2][0] = (char *)"AL CERCAVILA JO TOCO EL TAMBOR, I";
	array3D[63][2][1] = (char *)"EL GOS PORTA EL RITME FENT LLADRUCS";
	//TAMBOR-PINGÜÍ
	array3D[64][0][0] = (char *)"ELS REIS M'HAN PORTAT UN TAMBOR";
	array3D[64][0][1] = (char *)"I UN PINGÜÍ. DE JOGUINA, ÉS CLAR!";
	array3D[64][1][0] = (char *)"AMB EL TAMBOR SEMPRE TOCO UNA CANÇÓ";
	array3D[64][1][1] = (char *)"QUE VA D'UN PINGÜÍ QUE ES VA PERDRE";
	array3D[64][2][0] = (char *)"TINC UNA JOGUINA DE DONAR CORDA: ÉS";
	array3D[64][2][1] = (char *)"UN PINGÜÍ QUE TOCA EL TAMBOR";
	//GOS-PINGÜÍ
	array3D[65][0][0] = (char *)"ELS GOSSOS ESQUIMALS AGUANTEN EL";
	array3D[65][0][1] = (char *)"FRED IGUAL QUE ELS PINGÜINS";
	array3D[65][1][0] = (char *)"M'AGRADARIA UN PINGÜÍ DE MASCOTA,";
	array3D[65][1][1] = (char *)"PERÒ ÉS IMPOSSIBLE. MILLOR UN GOS";
	array3D[65][2][0] = (char *)"ELS GOSSOS ESTIREN EL TRINEU, I UNA";
	array3D[65][2][1] = (char *)"FAMÍLIA DE PINGÜINS S'HO MIREN";


	LlegirAmbFiducials *app = new LlegirAmbFiducials(port);
	app->run();
	delete(app);

	return 0;
}


