// cd ~/projectes/sdl_minim/v3
// g++ -Wall -o recreativa_arcade recreativa_arcade.cpp -lrt `sdl-config  --cflags --libs` -lSDL_ttf

#include <iostream>

#include <SDL.h>
#include "SDL_ttf.h"

#define DEPTH 16

int sortir = false;

int currentResWidth, currentResHeight;
SDL_Surface *screen;
SDL_Event event;
TTF_Font *font1;
SDL_Color fgcolor_blanc = {255,255,255};
Uint32 color_fons_blau;

#define FONT_SIZE1 40
#define KEY_SORTIR SDLK_0

// ===============================================================

class ScreenElement {
private:
	std::string name;
    SDL_Surface *srf;
    SDL_Rect rect;

public:
	ScreenElement ( std::string name="");
	std::string getName() const;
	void setName(std::string name);

	SDL_Surface *getSurface() const;
	void setSurface(SDL_Surface *);

	SDL_Rect getRectangle() const;
	void setRectangle(SDL_Rect);

};
 
// ===============================================================

class Screen {
private:
	std::string name;
	ScreenElement screlement;

public:
	Screen ( std::string name = "");


	std::string getName() const;
	void setName(std::string name);

	ScreenElement getScreenElement() const;
	void setScreenElement(ScreenElement);

	void createScreenElements(std::string screenName);
};
// ===============================================================

class App {
private:
	std::string name;
public:
	Screen screen1;

	App ( std::string name="");

	std::string getName() const;
	void setName(std::string name);

	void loopGame();
	
	int inicialitzarSDL();
	void finalitzarSDL();
	void handleKey(SDL_KeyboardEvent key);
};

// ===============================================================

int main (int argc, char ** argv){

	system("clear");

	App new_app("new_app");
	new_app.loopGame();
    new_app.finalitzarSDL();

	std::cout << "BYE" << std::endl;

	return 0;
}

// ===============================================================

// Constructor
App::App(std::string name) {
	this->name = name;

    if (inicialitzarSDL()<0) std::cout << "Problema en inicialitzar SDL" << std::endl;

    //construim les pantalles
    Screen pantallaTemp;

    pantallaTemp.setName("new_game");
    pantallaTemp.createScreenElements(pantallaTemp.getName());

    screen1 = pantallaTemp;
}

std::string App::getName() const {
	return name;
}
 
void App::setName(std::string name) {
	this->name = name;
}

/**************************
* Bucle principal del joc *
**************************/
void App::loopGame()  {
    std::cout << screen1.getName() << std::endl;

    SDL_Surface *srftemp;

    //srftemp = TTF_RenderUTF8_Blended(font1, screen1.getScreenElement().getName().c_str(), fgcolor_blanc ); //funciona
    srftemp = screen1.getScreenElement().getSurface(); //funciona

    SDL_Rect recttemp;
    recttemp = screen1.getScreenElement().getRectangle();

    SDL_FillRect (screen, &recttemp, color_fons_blau);

    std::cout << recttemp.x << std::endl;

    SDL_BlitSurface(srftemp,NULL,screen,&recttemp);
    SDL_UpdateRect(screen,0,0,0,0);


    do {
        while(SDL_PollEvent(&event)) 
        {      
            switch (event.type) 
            {
                case SDL_KEYDOWN:
                    App::handleKey(event.key);
                    break;
            }
        }
    }
    while( !sortir ); 
}


int App::inicialitzarSDL() {
    if (SDL_Init(SDL_INIT_VIDEO | SDL_INIT_AUDIO) < 0) {
        printf("No s'ha pogut inicialitzar SDL: %s\n",SDL_GetError());
        return -1;
    }

    SDL_ShowCursor( SDL_DISABLE ); //cursor invisible
    SDL_EnableKeyRepeat (SDL_DEFAULT_REPEAT_DELAY, SDL_DEFAULT_REPEAT_INTERVAL);
    
    const SDL_VideoInfo* screenInfo = SDL_GetVideoInfo();
    currentResWidth = (int)screenInfo->current_w;
    currentResHeight = (int)screenInfo->current_h;

    //cout << "screen width: " << currentResWidth  << endl;
    //cout << "screen height: " << currentResHeight  << endl << endl;

    if (!(screen = SDL_SetVideoMode(currentResWidth, currentResHeight, DEPTH, SDL_FULLSCREEN|SDL_SWSURFACE)))
    {
        SDL_Quit();
        return -1;
    }

    // Inicialitzem SDL_ttf
    if (TTF_Init() < 0) {
        printf("No s'ha pogut inicialitzar SDL_ttf: %s\n",SDL_GetError());
        SDL_Quit();
        return -1;
    }

    // càrrega de la font
    font1 = TTF_OpenFont("./Bungee-Regular.ttf", FONT_SIZE1);
    color_fons_blau = SDL_MapRGB (screen->format, 0, 0, 255);

    return 0;
}

void App::handleKey(SDL_KeyboardEvent key) {

    switch(key.keysym.sym) {

    case SDLK_ESCAPE:
    case KEY_SORTIR: // SDLK_0
        if(key.state == SDL_PRESSED) {
            std::cout << "HE PITJAT LA TECLA 0" << std::endl;
            sortir = true;
            break;
        }
    default:
        break;
    }

}

void App::finalitzarSDL() {
    //alliberem tot
    TTF_CloseFont(font1);
    //SDL_FreeSurface(srf_surface);
    SDL_FreeSurface(screen);
    SDL_Quit();
}

// ===============================================================

// Constructor
Screen::Screen(std::string name) {
	this->name = name;
}

std::string Screen::getName() const {
	return name;
}
 
void Screen::setName(std::string name) {
	this->name = name;
}

ScreenElement Screen::getScreenElement() const {
	return screlement;
}
 
void Screen::setScreenElement(ScreenElement screlement) {
	this->screlement = screlement;
}

void Screen::createScreenElements(std::string screenName) {

	ScreenElement ScreenElementTemp;
	SDL_Surface *srfTemp;
	SDL_Rect rectTemp;

	ScreenElementTemp.setName("Choose Game");

	srfTemp = TTF_RenderUTF8_Blended(font1, ScreenElementTemp.getName().c_str(), fgcolor_blanc );
	ScreenElementTemp.setSurface(srfTemp);
	rectTemp.x = 15;
	rectTemp.y = 10;
	rectTemp.w = 400;
	rectTemp.h = 200;
	ScreenElementTemp.setRectangle(rectTemp);

	this->screlement = ScreenElementTemp;
}

// ===============================================================

// Constructor
ScreenElement::ScreenElement(std::string name) {
	this->name = name;
}

std::string ScreenElement::getName() const {
	return name;
}
 
void ScreenElement::setName(std::string name) {
	this->name = name;
}

SDL_Surface* ScreenElement::getSurface() const {
	return srf;
}
 
void ScreenElement::setSurface(SDL_Surface *srf) {
	this->srf = srf;
}

SDL_Rect ScreenElement::getRectangle() const {
	return rect;
}
 
void ScreenElement::setRectangle(SDL_Rect rect) {
	this->rect = rect;
}

// ===============================================================
