/* g++ -Wall -c App.cpp `sdl-config  --cflags --libs`  -lSDL_ttf */

#include "App.h"
#include <iostream>
#include <stdio.h>
#include <unistd.h>
#include <string.h>

void cleanVariables();


// Constructor
App::App(std::string name) {
	this->name = name;

    currentResWidth = SCREEN_WIDTH;
    currentResHeight = SCREEN_HEIGHT;

    if (inicialitzarSDL()<0) std::cout << "Problema en inicialitzar SDL" << std::endl;

    //construim les pantalles
    Screen pantallaTemp;

    pantallaTemp.setName("new_game");
    pantallaTemp.createScreenElements(pantallaTemp.getName());

    screen1 = pantallaTemp;
}

std::string App::getName() const {
	return name;
}
 
void App::setName(std::string name) {
	this->name = name;
}

/**************************
* Bucle principal del joc *
**************************/
void App::loopGame()  {
    std::cout << screen1.getName() << std::endl;

    SDL_Surface *srftemp;

    //srftemp = TTF_RenderUTF8_Blended(font1, screen1.getScreenElement().getName().c_str(), fgcolor_blanc ); //funciona
    srftemp = screen1.getScreenElement().getSurface(); //funciona

    SDL_Rect recttemp;
    recttemp = screen1.getScreenElement().getRectangle();

    SDL_FillRect (screen, &recttemp, color_fons_blau);

    std::cout << recttemp.x << std::endl;

    SDL_BlitSurface(srftemp,NULL,screen,&recttemp);
    SDL_UpdateRect(screen,0,0,0,0);


    do {
        while(SDL_PollEvent(&event)) 
        {      
            switch (event.type) 
            {
                case SDL_KEYDOWN:
                    App::handleKey(event.key);
                    break;
            }
        }
    }
    while( !sortir ); 
}


int App::inicialitzarSDL() {
    if (SDL_Init(SDL_INIT_VIDEO | SDL_INIT_AUDIO) < 0) {
        printf("No s'ha pogut inicialitzar SDL: %s\n",SDL_GetError());
        return -1;
    }

    SDL_ShowCursor( SDL_DISABLE ); //cursor invisible
    SDL_EnableKeyRepeat (SDL_DEFAULT_REPEAT_DELAY, SDL_DEFAULT_REPEAT_INTERVAL);
    
    const SDL_VideoInfo* screenInfo = SDL_GetVideoInfo();
    currentResWidth = (int)screenInfo->current_w;
    currentResHeight = (int)screenInfo->current_h;

    //cout << "screen width: " << currentResWidth  << endl;
    //cout << "screen height: " << currentResHeight  << endl << endl;

    if (!(screen = SDL_SetVideoMode(currentResWidth, currentResHeight, DEPTH, SDL_FULLSCREEN|SDL_SWSURFACE)))
    {
        SDL_Quit();
        return -1;
    }

    // Inicialitzem SDL_ttf
    if (TTF_Init() < 0) {
        printf("No s'ha pogut inicialitzar SDL_ttf: %s\n",SDL_GetError());
        SDL_Quit();
        return -1;
    }

    // càrrega de la font
    font1 = TTF_OpenFont("./Bungee-Regular.ttf", FONT_SIZE1);
    color_fons_blau = SDL_MapRGB (screen->format, 0, 0, 255);

    return 0;
}

void App::handleKey(SDL_KeyboardEvent key) {

    switch(key.keysym.sym) {

    case SDLK_ESCAPE:
    case KEY_SORTIR: // SDLK_0
        if(key.state == SDL_PRESSED) {
            std::cout << "HE PITJAT LA TECLA 0" << std::endl;
            sortir = true;
            sortir = true;
            break;
        }
    default:
        break;
    }

}

void App::finalitzarSDL() {
    //alliberem tot
    TTF_CloseFont(font1);
    //SDL_FreeSurface(srf_surface);
    SDL_FreeSurface(screen);
    SDL_Quit();
}

