// cd ~/projectes/sdl_minim/v1
// g++ -Wall -o main main.cpp -lrt `sdl-config  --cflags --libs` -lSDL_ttf

#include <iostream>

#include <SDL.h>
#include "SDL_ttf.h"

#define SCREEN_WIDTH 1024 //valor per defecte, abans d'avariguar la resolució de la pantalla
#define SCREEN_HEIGHT 768
#define DEPTH 16
#define FONT_SIZE1 40
#define KEY_SORTIR SDLK_0

int sortir;

int currentResWidth, currentResHeight;
SDL_Surface *screen;
SDL_Surface *srf_surface;
SDL_Rect rect_rectangle;
SDL_Event event;
TTF_Font *font1;
SDL_Color fgcolor_blanc;
Uint32 color_fons_blau;

int inicialitzarSDL();
void finalitzarSDL();
void handleKey(SDL_KeyboardEvent key);


int main (int argc, char ** argv){
	sortir = false;

	system("clear");

	std::string strfoo = "Prova SDL";

    currentResWidth = SCREEN_WIDTH;
    currentResHeight = SCREEN_HEIGHT;

    if (inicialitzarSDL()<0) std::cout << "Problema en inicialitzar SDL" << std::endl;

	srf_surface = TTF_RenderUTF8_Blended(font1, strfoo.c_str(), fgcolor_blanc );

	rect_rectangle.x = 15;
	rect_rectangle.y = 10;
	rect_rectangle.w = 400;
	rect_rectangle.h = 200;


    SDL_FillRect (screen, &rect_rectangle, color_fons_blau);

    SDL_BlitSurface(srf_surface,NULL,screen,&rect_rectangle);
    SDL_UpdateRect(screen,0,0,0,0);

    do {
        while(SDL_PollEvent(&event)) 
        {      
            switch (event.type) 
            {
                case SDL_KEYDOWN:
                    handleKey(event.key);
                    break;
            }
        }
    }
    while( !sortir ); 

    finalitzarSDL();

	return 0;
}

int inicialitzarSDL() {
    if (SDL_Init(SDL_INIT_VIDEO | SDL_INIT_AUDIO) < 0) {
        printf("No s'ha pogut inicialitzar SDL: %s\n",SDL_GetError());
        return -1;
    }

    SDL_ShowCursor( SDL_DISABLE ); //cursor invisible
    SDL_EnableKeyRepeat (SDL_DEFAULT_REPEAT_DELAY, SDL_DEFAULT_REPEAT_INTERVAL);
    
    const SDL_VideoInfo* screenInfo = SDL_GetVideoInfo();
    currentResWidth = (int)screenInfo->current_w;
    currentResHeight = (int)screenInfo->current_h;

    std::cout << "screen width: " << currentResWidth  << std::endl;
    std::cout << "screen height: " << currentResHeight  << std::endl << std::endl;

    if (!(screen = SDL_SetVideoMode(currentResWidth, currentResHeight, DEPTH, SDL_FULLSCREEN|SDL_SWSURFACE)))
    {
        SDL_Quit();
        return -1;
    }

    // Inicialitzem SDL_ttf
    if (TTF_Init() < 0) {
        printf("No s'ha pogut inicialitzar SDL_ttf: %s\n",SDL_GetError());
        SDL_Quit();
        return -1;
    }

    // càrrega de la font
    font1 = TTF_OpenFont("./Bungee-Regular.ttf", FONT_SIZE1);
    color_fons_blau = SDL_MapRGB (screen->format, 0, 0, 255);
	//fgcolor_blanc = {255,255,255}; //compila bé amb l'opció -std=c++0x
	fgcolor_blanc.r = 255;
	fgcolor_blanc.g = 255;
	fgcolor_blanc.b = 255;

    return 0;
}

void handleKey(SDL_KeyboardEvent key) {

    switch(key.keysym.sym) {

    case SDLK_ESCAPE:
    case KEY_SORTIR: // SDLK_0
        if(key.state == SDL_PRESSED) {
            std::cout << "HE PITJAT LA TECLA 0" << std::endl;
            sortir = true;
            break;
        }
    default:
        break;
    }

}

void finalitzarSDL() {
    TTF_CloseFont(font1);
    SDL_FreeSurface(srf_surface);
    SDL_FreeSurface(screen);
    SDL_Quit();
}


