/* main_v3.c */

#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <stdio.h>
#include <math.h>

#include <jack/jack.h>
#include <jack/midiport.h>
#include <gtk/gtk.h>


const double PI = 3.14;

/*Our output port*/
jack_port_t *output_port;
jack_port_t *input_port;

typedef jack_default_audio_sample_t sample_t;

/*The current sample rate*/
jack_nframes_t sr;

/*one cycle of our sound*/
sample_t* cycle;
/*samples in cycle*/
jack_nframes_t samincy;
/*the current offset*/
long offset=0;

/*frequency of our sound*/
int tone=262;
unsigned char num_missatgeCC, valor_missatgeCC;

int process (jack_nframes_t nframes, void *arg){

   void* port_buf_in = jack_port_get_buffer(input_port, nframes);
   unsigned char* buffer;
   jack_midi_event_t in_event;
   jack_nframes_t event_index = 0;
   jack_nframes_t event_count = jack_midi_get_event_count(port_buf_in);
   jack_midi_event_get(&in_event, port_buf_in, 0);
   //GTK
   GtkRange *range = (GtkRange *) arg; //a arg li estic passant l'objecte scale, del qual vull actualitzar el valor un cop conegui el missatge CC que envio.

  /*grab our output buffer*/
  sample_t *out = (sample_t *) jack_port_get_buffer (output_port, nframes);

  /*For each required sample*/
  for(jack_nframes_t i=0;i<nframes;i++){
      //part MIDI
      //captura d'events midi provinents del controlador
      if((in_event.time == i) && (event_index < event_count))
      {
         //printf("%d\n",*(in_event.buffer));
         if ( (*(in_event.buffer) & 0xf0) == 0x90) { //Note ON
            printf("Note on\n");
	    num_missatgeCC = *(in_event.buffer + 1);
	    valor_missatgeCC = *(in_event.buffer + 2);
            printf("%d\n",num_missatgeCC);
            printf("%d\n",valor_missatgeCC);

         }
         else if ( (*(in_event.buffer) & 0xf0) == 0xB0) //missatge CC, el que envia els controls del Axiom 25
         {
            printf("Missatge CC\n");
	    num_missatgeCC = *(in_event.buffer + 1);
	    valor_missatgeCC = *(in_event.buffer + 2);
            printf("%d\n",num_missatgeCC);
            printf("%d\n",valor_missatgeCC);
            //i actualitzem el slider, que provocarà el tret de l'event...
            gtk_range_set_value(range,valor_missatgeCC); //el gtk_range_set_value es fa servir d'aquesta manera
         }

         event_index++;
         if(event_index < event_count) {
            jack_midi_event_get(&in_event, port_buf_in, event_index);
            i--; //el problema és que en el jack-keyboard i en el vkeybd (i no en el VMPK), abans d'enviar el missatge de program change s'envia un missatge de status (0xb0), en el mateix time. És necessari fer i-- per capturar aquest event.
          }

      }

    //part AUDIO
    /*Copy the sample at the current position in the cycle to the buffer*/
    out[i]=cycle[offset];
    /*and increment the offset, wrapping to 0 if needed*/
    /*(Dumb increment fixed thanks to Jussi Sainio)*/
    offset++;
    if(offset==samincy)
      offset=0;    

  }
				   
  return 0;      
}

int srate (jack_nframes_t nframes, void *arg){
  printf ("the sample rate is now %lu/sec\n", nframes);
  sr=nframes;
  return 0;
}

void error (const char *desc){
  fprintf (stderr, "JACK error: %s\n", desc);
}

void jack_shutdown (void *arg){
  exit (1);
}

static void set_value(GtkWidget * widget, gpointer data)
{
   GtkRange *range = (GtkRange *) widget;
   tone = gtk_range_get_value(range)+262;
   //gtk_range_set_value(range,0); el gtk_range_set_value es fa servir d'aquesta manera
   g_print("el valor és %i\n",tone);

  /*Create 1 cycle of the wave*/
  /*Calculate the number of samples in one cycle of the wave*/
  samincy=(sr/tone);
  /*Calculate our escala multiplier*/
  sample_t escala = 2 * PI / samincy;
  /*Allocate the space needed to store one cycle*/
  cycle = (sample_t *) malloc (samincy * sizeof(sample_t));
  /*Exit if allocation failed (more sense from Jussi)*/
  if(cycle == NULL) {
    fprintf(stderr,"memory allocation failed\n");
    //return 1;
  }
 
  // si moc molt ràpid el slider es produeix segmentation fault i algun XRUN. I és que només és un exemple didàctic. 
  // A dins de la funció callback no hi poden haver bucles com estic fent. El que estic fent és CPU consuming (calcular l'array cicle[i] cada cop que moc el slider.
  /*And fill it up*/
  for(int i=0;i < samincy;i++){
    cycle[i]=sin(i*escala);
  }
}

int main (int argc, char ** argv)
{
  GtkWidget *window;
  GtkWidget *fixed;
  GtkWidget *scale;

  gtk_init(&argc, &argv);


  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(window), "CPU widget");
  gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);
  gtk_window_set_default_size(GTK_WINDOW(window), 200, 180);


  g_signal_connect(G_OBJECT(window), "destroy", 
       G_CALLBACK(gtk_main_quit), NULL);

  fixed = gtk_fixed_new();
  gtk_container_add(GTK_CONTAINER(window), fixed);

  scale = gtk_vscale_new_with_range(0.0, 100.0, 1.0);
  gtk_range_set_inverted(GTK_RANGE(scale), TRUE);
  gtk_scale_set_value_pos(GTK_SCALE(scale), GTK_POS_TOP);
  gtk_widget_set_size_request(scale, 50, 120);
  gtk_fixed_put(GTK_FIXED(fixed), scale, 130, 20);

  g_signal_connect(G_OBJECT(scale), "value_changed", G_CALLBACK(set_value), NULL);
  gtk_widget_show(fixed);
  gtk_widget_show_all(window);

  jack_client_t *client;
  jack_client_t *client_midicontroller;
  const char **ports;
  
  if (argc < 2) {
    fprintf (stderr, "usage: ./main_v2 prova_widget \n");
    return 1;
  }
  
  jack_set_error_function (error);
  
  if((client = jack_client_open (argv[1],JackNullOption,NULL)) == 0) {
    fprintf (stderr, "jack server not running?\n");
    return 1;
  }

  //jack_set_process_callback (client, process, 0); //fins ara no passava arguments en el callback. Ara tinc la necessitat de passar-li l'objecte scale
  jack_set_process_callback (client, process, scale); //li he de passar com argument l'objecte scale
  jack_set_sample_rate_callback (client, srate, 0);
  
  jack_on_shutdown (client, jack_shutdown, 0);
  
  printf ("engine sample rate: %lu\n", jack_get_sample_rate (client));
  printf ("engine sample rate: %lu\n", jack_get_sample_rate (client));
  

  sr=jack_get_sample_rate (client);

  output_port = jack_port_register (client, "output", JACK_DEFAULT_AUDIO_TYPE, JackPortIsOutput, 0); //AUDIO
  input_port = jack_port_register (client, "in", JACK_DEFAULT_MIDI_TYPE, JackPortIsInput, 0);        //MIDI

/*Create 1 cycle of the wave*/
  /*Calculate the number of samples in one cycle of the wave*/
  samincy=(sr/tone);
  /*Calculate our escala multiplier*/
  sample_t escala = 2 * PI / samincy;
  /*Allocate the space needed to store one cycle*/
  cycle = (sample_t *) malloc (samincy * sizeof(sample_t));
  /*Exit if allocation failed (more sense from Jussi)*/
  if(cycle == NULL) {
    fprintf(stderr,"memory allocation failed\n");
    return 1;
  }

  /*And fill it up*/
  for(int i=0;i < samincy;i++){
    cycle[i]=sin(i*escala);
  }



  /* tell the JACK server that we are ready to roll */
  
  if (jack_activate (client)) {
    fprintf (stderr, "cannot activate client");
    return 1;
  }
  
  /* connect the ports*/
  if ((ports = jack_get_ports (client, NULL, NULL, 
                   JackPortIsPhysical|JackPortIsInput)) == NULL) {
    fprintf(stderr, "Cannot find any physical playback ports\n");
    exit(1);
  }
  
  int i=0;
  while(ports[i]!=NULL){
    if (jack_connect (client, jack_port_name (output_port), ports[i])) {
      fprintf (stderr, "cannot connect output ports\n");
    }
    i++;
  }
  
  free (ports);

   //intentem realitzar la connexió del port sax_trainer:in al nostre controlador midi preferit...
   if((client_midicontroller = jack_client_open ("a2j",JackNullOption,NULL)) == 0)
   {
      fprintf (stderr, "jack server not running?\n");
         return 1;
   }
	
   if ((ports = jack_get_ports (client_midicontroller, NULL, NULL, JackPortIsOutput)) == NULL) {
      fprintf(stderr, "Cannot find any input ports to connect sax_trainer to\n");
      exit(1);
   }

   //vaig directe al gra i sé quin port és el que m'interessa
   printf ("%s\n", ports[3]); //a2j:USB Axiom 25 [24] (capture): USB Axiom 25 MIDI 1
   jack_connect (client_midicontroller, ports[3],jack_port_name (input_port));		
   free (ports);

  //el gtk_main() és el bucle principal del GTK, i ha d'anar al final
  gtk_main();

  jack_client_close (client);
  free(cycle);

  return 0;
}


