/* main_v2.c */

#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <stdio.h>
#include <math.h>

#include <jack/jack.h>
#include <gtk/gtk.h>


const double PI = 3.14;

/*Our output port*/
jack_port_t *output_port;

typedef jack_default_audio_sample_t sample_t;

/*The current sample rate*/
jack_nframes_t sr;

/*one cycle of our sound*/
sample_t* cycle;
/*samples in cycle*/
jack_nframes_t samincy;
/*the current offset*/
long offset=0;

/*frequency of our sound*/
int tone=262;

int process (jack_nframes_t nframes, void *arg){
  /*grab our output buffer*/
  sample_t *out = (sample_t *) jack_port_get_buffer (output_port, nframes);

  /*For each required sample*/
  for(jack_nframes_t i=0;i<nframes;i++){
    /*Copy the sample at the current position in the cycle to the buffer*/
    out[i]=cycle[offset];
    /*and increment the offset, wrapping to 0 if needed*/
    /*(Dumb increment fixed thanks to Jussi Sainio)*/
    offset++;
    if(offset==samincy)
      offset=0;    

  }
				   
  return 0;      
}

int srate (jack_nframes_t nframes, void *arg){
  printf ("the sample rate is now %lu/sec\n", nframes);
  sr=nframes;
  return 0;
}

void error (const char *desc){
  fprintf (stderr, "JACK error: %s\n", desc);
}

void jack_shutdown (void *arg){
  exit (1);
}

static void set_value(GtkWidget * widget, gpointer data)
{
   GtkRange *range = (GtkRange *) widget;
   tone = gtk_range_get_value(range)+262;
   g_print("el valor és %i\n",tone);

  /*Create 1 cycle of the wave*/
  /*Calculate the number of samples in one cycle of the wave*/
  samincy=(sr/tone);
  /*Calculate our escala multiplier*/
  sample_t escala = 2 * PI / samincy;
  /*Allocate the space needed to store one cycle*/
  cycle = (sample_t *) malloc (samincy * sizeof(sample_t));
  /*Exit if allocation failed (more sense from Jussi)*/
  if(cycle == NULL) {
    fprintf(stderr,"memory allocation failed\n");
    //return 1;
  }
 
  // si moc molt ràpid el slider es produeix segmentation fault i algun XRUN. I és que només és un exemple didàctic. 
  // A dins de la funció callback no hi poden haver bucles com estic fent. El que estic fent és CPU consuming (calcular l'array cicle[i] cada cop que moc el slider.
  /*And fill it up*/
  for(int i=0;i < samincy;i++){
    cycle[i]=sin(i*escala);
  }
}

int main (int argc, char ** argv)
{
  GtkWidget *window;
  GtkWidget *fixed;
  GtkWidget *scale;

  gtk_init(&argc, &argv);


  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(window), "CPU widget");
  gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);
  gtk_window_set_default_size(GTK_WINDOW(window), 200, 180);


  g_signal_connect(G_OBJECT(window), "destroy", 
       G_CALLBACK(gtk_main_quit), NULL);

  fixed = gtk_fixed_new();
  gtk_container_add(GTK_CONTAINER(window), fixed);

  scale = gtk_vscale_new_with_range(0.0, 100.0, 1.0);
  gtk_range_set_inverted(GTK_RANGE(scale), TRUE);
  gtk_scale_set_value_pos(GTK_SCALE(scale), GTK_POS_TOP);
  gtk_widget_set_size_request(scale, 50, 120);
  gtk_fixed_put(GTK_FIXED(fixed), scale, 130, 20);

  g_signal_connect(G_OBJECT(scale), "value_changed", G_CALLBACK(set_value), NULL);
  gtk_widget_show(fixed);
  gtk_widget_show_all(window);

  jack_client_t *client;
  const char **ports;
  
  if (argc < 2) {
    fprintf (stderr, "usage: ./main_v2 prova_widget \n");
    return 1;
  }
  
  jack_set_error_function (error);
  
  if((client = jack_client_open (argv[1],JackNullOption,NULL)) == 0) {
    fprintf (stderr, "jack server not running?\n");
    return 1;
  }

  jack_set_process_callback (client, process, 0);
  jack_set_sample_rate_callback (client, srate, 0);
  
  jack_on_shutdown (client, jack_shutdown, 0);
  
  printf ("engine sample rate: %lu\n", jack_get_sample_rate (client));
  printf ("engine sample rate: %lu\n", jack_get_sample_rate (client));
  

  sr=jack_get_sample_rate (client);

  output_port = jack_port_register (client, "output", JACK_DEFAULT_AUDIO_TYPE, JackPortIsOutput, 0);

/*Create 1 cycle of the wave*/
  /*Calculate the number of samples in one cycle of the wave*/
  samincy=(sr/tone);
  /*Calculate our escala multiplier*/
  sample_t escala = 2 * PI / samincy;
  /*Allocate the space needed to store one cycle*/
  cycle = (sample_t *) malloc (samincy * sizeof(sample_t));
  /*Exit if allocation failed (more sense from Jussi)*/
  if(cycle == NULL) {
    fprintf(stderr,"memory allocation failed\n");
    return 1;
  }

  /*And fill it up*/
  for(int i=0;i < samincy;i++){
    cycle[i]=sin(i*escala);
  }



  /* tell the JACK server that we are ready to roll */
  
  if (jack_activate (client)) {
    fprintf (stderr, "cannot activate client");
    return 1;
  }
  
  /* connect the ports*/
  if ((ports = jack_get_ports (client, NULL, NULL, 
                   JackPortIsPhysical|JackPortIsInput)) == NULL) {
    fprintf(stderr, "Cannot find any physical playback ports\n");
    exit(1);
  }
  
  int i=0;
  while(ports[i]!=NULL){
    if (jack_connect (client, jack_port_name (output_port), ports[i])) {
      fprintf (stderr, "cannot connect output ports\n");
    }
    i++;
  }
  
  free (ports);

  //el gtk_main() és el bucle principal del GTK, i ha d'anar al final
  gtk_main();

  jack_client_close (client);
  free(cycle);

  return 0;
}


