function World(specs){
	this.set(specs);
	this.lifeManager = new LifeManager();
	this.timeManager = new TimeManager({
		timeIterval: 50,
		step: this.step.bind(this)
	});
	this.createMinions({
		preys: 10,
		predators: 2,
		plants: 20
	});
}

World.prototype.set = function(specs){
	this.grafic = canvasToolkit;
	this.grafic.width = specs.width;
	this.grafic.height = specs.height;
};

World.prototype.step = function(){
	this.grafic.rebuild();
	this.lifeManager.live();
};

World.prototype.listeners = function(){
	this.lifeManager.gameOverEvent.listen(this.stop);
};

World.prototype.stop = function(){
	this.timeManager.stop();
};

World.prototype.start = function(){
	this.timeManager.start();
};

World.prototype.createMinions  = function(minions){
	for(var i = minions.preys; i--; ){
		this.lifeManager.newPrey(Math.floor(Math.random() * this.grafic.width), Math.floor(Math.random() * this.grafic.height), Math.floor(Math.random() * 360));
	}
	for(var i = minions.predators; i--; ){
		this.lifeManager.newPredator(Math.floor(Math.random() * this.grafic.width), Math.floor(Math.random() * this.grafic.height), Math.floor(Math.random() * 360));
	}
	for(var i = minions.plants; i--; ){
		this.lifeManager.newPlant(Math.floor(Math.random() * this.grafic.width), Math.floor(Math.random() * this.grafic.height));
	}
};

//Static function
World.normalizePosition = function(pos){
	if (pos.x > canvasToolkit.width) {
		pos.x -= canvasToolkit.width;
	}

	if (pos.x < 0) {
		pos.x += canvasToolkit.width;
	}

	if (pos.y < 0) {
		pos.y += canvasToolkit.height;
	}

	if (pos.y > canvasToolkit.height) {
		pos.y -= canvasToolkit.height;
	}

	return {x: pos.x, y: pos.y};
};