function Predator(){
	Element.call(this);
}

//Inherit from Element
Predator.prototype = new Element();

//Parent functions
Predator.prototype.set_base = Predator.prototype.set;
// Predator.prototype.move_base = Predator.prototype.move;

//Extend set function
Predator.prototype.set = function(specs){
	specs.direction = specs.direction || 0;
	this.set_base(specs);
	this.distanceToMeal = 99999999999;
	this.eats = specs.eats || ['Prey'];
	this.type = 'Predator';
};

//Override the live function
Predator.prototype.live = function(manager){
	var myMealData = manager.findNearestMeal(this);
	if(myMealData){
		this.myMeal = myMealData.meal;
		this.distanceToMeal = myMealData.distance;
		this.haunt(manager);
		this.correctPosition(manager);
	}else{
		this.myMeal = null;
		this.move();
	}
	this.aging(manager);
};

Element.prototype.drawDirectionToTarget = function(){
	this.grafic.lineStandard(this.x, this.y, this.myMeal.x, this.myMeal.y);
};


Predator.prototype.haunt = function(manager){
	this.direction = manager.getNextDirectionToDestination(this, this.myMeal);
	this.move();
	this.eatMeal(manager);

};

Predator.prototype.eatMeal = function(manager){
	if(this.distanceToMeal < this.size * 2){
		//Create a new predator.
		manager.newPredator(this.myMeal.x + 6, this.myMeal.y, this.myMeal.direction);

		//Create a new pray
		manager.newPrey(Math.floor(Math.random() * this.grafic.width), Math.floor(Math.random() * this.grafic.height), Math.floor(Math.random() * 360));

		//Kill the prey.
		manager.killPrey(this.myMeal);

		//Eat a prey makes the predator younger
		this.lifeHope += 400;
	}
};

Predator.prototype.correctPosition = function(manager){
	var partnerData =  manager.findNearestPartner(this);
	if(partnerData){
		if(partnerData.distance < this.size + this.size){
			var direction = this.direction;
			if(direction < 90 || direction > 270)
				this.x -= 6;
			else
				this.x += 6;
			this.correctPosition(manager);
		}
	}
};

Predator.prototype.aging = function(manager){
	this.lifeHope--;

	if(!this.lifeHope)
		this.die(manager);
	
	// this.color = "red";

	// if(remaining < 255){
	// 	var dif = 255 - remaining;
	// 	var hexDiff =  dif.toString(16);
	// 	// this.color = '#ff' + hexDiff + hexDiff;
	// 	this.color = '#' + remaining.toString(16) + '0000';

	// }
}

// //Functional classes
// function m (){
// 	var that = {};
// 	that.algo = function(){
		
// 	}
// 	return that;
// }

// function n(){
// 	var that = m();
// 	thatn.otracosa=function(){
		
// 	}
// 	return that;
// }



// //Classical classes
// function M(specs){
// 	this.algo = function(){
		
// 	}
// }

// function N(specs){
// 	M.call(this, specs);
// 	this.otracosa = function(){
		
// 	}
// }

// var cosa = new M();
// var cosa = M.call({});



// //Prototypal
// function M(){
// 	this.a = 25;
// };
// M.prototype.algo = function(){
	
// }
// M.prototype.test = function(){
	
// }

// function N(){
// 	M.call(this);
// 	this.test();
// }
// N.prototype =  new M();
// N.prototype.otracosa = function(){
	
// }

// Object.create = function(cosa) {
// 	var result = {};
// 	result.__proto__ = cosa;
// 	return result;
// };



// // Special way of inheritance for prototypal method
// var Prey = (function() {
// 	function Prey(){
		
// 	}
// 	Prey.prototype = new Element();

// 	var set_base = Prey.prototype.set;
// 	Prey.prototype.set=function(specs){
// 		set_base.call(this);
// 	};

// 	return Prey;
// })();