function Plant(){
	Element.call(this);
}

//Inherit from Element
Plant.prototype = new Element();

//Inherited methods
Plant.prototype.set_base = Plant.prototype.set;
Plant.prototype.live_base = Plant.prototype.live;

//Extend parent set function
Plant.prototype.set = function(specs){
	this.set_base(specs);
	this.type = 'Plant';
	this.lifeHope = specs.lifeHope || 1000;
	this.maxSize = this.size * 10;
};

Plant.prototype.live = function(manager){
	this.grow();
	this.aging(manager);
	this.draw();
};

Plant.prototype.grow = function(){
	if(this.maxSize > this.size){
		this.size += this.age / 500;
	}

};


Plant.prototype.aging = function(){
	this.age++;
};
