function Element(){
	this.x = 0;
	this.y = 0;
	this.speed = 0;
	this.maxTurnSpeed = 0;
	this.direction = 0;
	this.color = "#00ff00";
	this.size = 3;
	this.grafic = canvasToolkit;
	this.specs = {};
	this.eats = [];
	this.type = 'Element';
	this.lifeHope = 400;
	this.age = 0;
};

Element.prototype.set = function(specs){
	this.x = specs.x || this.x;
	this.y = specs.y || this.y;
	this.speed = specs.speed || this.speed;
	this.maxTurnSpeed = specs.maxTurnSpeed || this.maxTurnSpeed;
	this.direction = specs.direction || this.direction;
	this.color = specs.color || this.color;
	this.size = specs.size || this.size;
	this.specs = specs || this.specs;
};

Element.prototype.live = function(manager){
	this.move();
	this.aging();
};

Element.prototype.aging = function(manager){
	this.age++;
	if(this.lifeHope == this.age){
		this.die(manager);
	}
};

Element.prototype.die = function(manager){
	manager.killPrey(this);
};

Element.prototype.move = function() {
	var rad = (90 - this.direction) * Math.PI / 180;
	var dx = this.speed*Math.sin(rad);
	var dy = this.speed*Math.cos(rad);
	this.x += dx;
	this.y -= dy;
	this.draw();
	this.drawDirection(dx, dy);
	
	if (this.x + dx > this.grafic.width) {
		this.x -= this.grafic.width;
	}

	if (this.x + dx < 0) {
		this.x += this.grafic.width;
	}

	if (this.y + dy < 0) {
		this.y += this.grafic.height;
	}

	if (this.y + dy > this.grafic.height) {
		this.y -= this.grafic.height;
	}
};

Element.prototype.draw = function(){
	this.grafic.circle(this.x, this.y, this.size, this.color);
};

Element.prototype.drawDirection = function(dx, dy){
	this.grafic.line(this.x, this.y, dx, dy, this.speed);
};

Element.prototype.canEat = function (element) {
	return this.eats.indexOf(element.type) != -1
};

Element.prototype.isPartner = function(element){
	return this.type === element.type
};

Element.prototype.canEatMe = function(element){
	return element.canEat(this);
};