function LifeManager(){
	this.life = [];
	this.grafic = canvasToolkit;
}

/*
 * MAIN FUNCTIONS
 */

 //Activate the alive elemets
LifeManager.prototype.live = function(){
	for(var i = 0; i< this.life.length; i++){
		this.life[i].live(this);
	}
}

//Prepare all events that may be fired.
LifeManager.prototype.events = function(){
	this.gameOverEvent = new Event();	
};

/*
 * CREATURE CREATION / KILL
 */

//Creating a new prey
LifeManager.prototype.newPrey = function(x, y, direction){
	var prey = new Prey();
	prey.set({
		speed: 5,
		maxTurnSpeed: 20,
		color: "blue",
		x: x,
		y: y,
		direction: direction
	});	

	// this.preys.push(prey);
	this.life.push(prey);

	return prey;
};

//Create a new predator
LifeManager.prototype.newPredator = function(x, y, direction){
	var predator = new Predator();
	predator.set({
		speed: 4,
		maxTurnSpeed: 20,
		color: "red",
		x: x,
		y: y,
		direction: direction
	});

	this.life.push(predator);

	return predator;
};

//Create a new Plant
LifeManager.prototype.newPlant = function(x,y){
	var plant = new Plant();
	plant.set({
		color: 'green',
		x: x,
		y: y,
		size: 1
	});

	this.life.push(plant);

	return plant;
};

//Kill a prey
LifeManager.prototype.killPrey = function(prey){
	this.life.splice(this.life.indexOf(prey),1);
};

//Kill a predator
LifeManager.prototype.killPredator = function(predator){
	this.life.splice(this.life.indexOf(predator),1);
};

//Kill
LifeManager.prototype.kill = function(aliveElement){
	this.life.splice(this.life.indexOf(aliveElement),1);
};


/*
 *USEFUL FUCNTIONS
 */

//Search the nearest eatable thing
LifeManager.prototype.findNearestMeal = function(element){
	var nearest = {};
	var shortestDistance = 99999999999;
	for(var i = this.life.length; i--; ){
		if(element.canEat(this.life[i]) && element != this.life[i]){
			var distance = this.getDistanceToElement(element, this.life[i]);
			if(distance < shortestDistance){
				shortestDistance = distance;
				nearest = this.life[i];
			}
		}
	}
	var data = {
		meal: nearest,
		distance: shortestDistance
	};
	return data;
};

//Search the nearest partner
LifeManager.prototype.findNearestPartner = function(element){
	var nearest = {};
	var shortestDistance = 99999999999;
	for(var i = this.life.length; i--; ){
		if(element.isPartner(this.life[i]) && element != this.life[i]){
			var distance = this.getDistanceToElement(element, this.life[i]);
			if(distance < shortestDistance){
				shortestDistance = distance;
				nearest = this.life[i];
			}
		}
	}
	var data = {
		partner: nearest,
		distance: shortestDistance
	};
	return data;
}

//Get the direction from one element to an other element.
LifeManager.prototype.getDirectionToDestination = function(element, destination){
	var dest = this.getRelativePosition(element, destination);

	var dx = dest.x - element.x;
	var dy = dest.y - element.y;

	//Calculating the angle of the destination
	var ang = -Math.atan(dy/dx) * 180 / (Math.PI);

	//Correcting the angle to standarize it;
	if( dest.x < element.x ){
		 ang = 180 + ang;
	}else{
		if( dest.y > element.y ){
			ang = 360 + ang;
		}
	}

	return ang;
};

//Getting the next direction the element must use to reach the destination counting on the max turn speed.
LifeManager.prototype.getNextDirectionToDestination = function(element, destination){
	var ang = this.getDirectionToDestination(element, destination);
	// debugger;
	var direcc = element.direction;

	//Getting the difference angle between my direction and the direction where is the prey.
	var diff = ang - direcc ;
	var diff2 = ang + 360 - direcc;
	var diff3 = ang - 360 - direcc;
	if(Math.abs(diff) > Math.abs(diff2)){
		diff = diff2;
	}
	if(Math.abs(diff) > Math.abs(diff3)){
		diff = diff3;
	}

	//correcting the direction
	if(Math.abs(diff) > element.maxTurnSpeed){
		var dir = direcc + (element.maxTurnSpeed * Math.abs(diff)/diff);
		if(dir >= 360){
			dir -= 360;
		}
		if(dir < 0){
			dir += 360;
		}
		return dir;
	}else{
		return ang;
	}
}

//Get distance between two elements.
LifeManager.prototype.getDistanceToElement = function(element1, element2){
	return this.getDistanceBetweenPositions(element1.x, element1.y, element2.x, element2.y);
};

LifeManager.prototype.getDistanceToPosition = function(element, x, y){
	return this.getDistanceBetweenPositions(element1.x, element1.y, x, y);
};

LifeManager.prototype.getDistanceBetweenPositions = function(x1, y1, x2, y2){
	var dx = x2 - x1;
	var dy = y2 - y1;
	if(dx > this.grafic.width / 2){
		dx = dx -this.grafic.width / 2;
	}
	if(dy > this.grafic.height / 2){
		dy = dy -this.grafic.height / 2;
	}
	return Math.sqrt(dx*dx + dy*dy)	
};

LifeManager.prototype.getRelativePosition = function(element1, element2){
	var dx = element2.x - element1.x;
	var dy = element2.y - element1.y;
	if(dx > this.grafic.width / 2){
		dx = dx -this.grafic.width;
	}
	if(dy > this.grafic.height / 2){
		dy = dy -this.grafic.height;
	}
	var newPos = {
		x: element1.x + dx,
		y: element1.y + dy
	};
	return newPos;
};