/* 
This is just a simplified version of the project gnublin-api,  projecte licenced with LGPL v3
http://wiki.gnublin.org/index.php/Hauptseite
This code is for accessing GPIO pins in the Raspberry Pi: input, output and I2C
*/

#include <cstring>
#include <ctime>
#include <fcntl.h>
#include <fstream>
#include <iostream>
#include <linux/i2c.h>
#include <linux/i2c-dev.h>
#include <sstream>
#include <stdio.h>
#include <stdlib.h>
#include <string>
#include <sys/ioctl.h>
#include <time.h>
#include <unistd.h>
#include <math.h>

#define OUTPUT 	"out"
#define INPUT	"in"
#define LOW	0
#define HIGH	1
#define ON	1
#define OFF	0
#define IN	1
#define OUT	0

int stringToNumber(std::string str);
std::string numberToString(int num);
int hexstringToNumber(std::string str);

//***** NEW BLOCK *****

/**
* @class rp_gpio
* @~english
* @brief Class for accessing RP GPIO-Ports
*
* With the rp_gpio API you can controll the GPIO-Ports of the RP Board
* @~german 
* @brief Klasse für den zugriff auf die GPIO Pins
*
* Mit der rp_gpio API lassen sich die GPIO-Ports auf dem RP einfach aus dem eigenem Programm heraus ansteuern.  
*/
class rp_gpio {
	public:
		rp_gpio();
		bool fail();
		int pinMode(int pin, std::string direction); //Defines GPIO<pin> as INPUT or OUTPUT
		int digitalWrite(int pin, int value); //Writes value on GPIO
		int digitalRead(int pin); //Reads value from GPIO<pin>
		int unexport(int pin);
		const char *getErrorMessage();
	private:
		bool error_flag;
		std::string ErrorMessage;
};
//***** NEW BLOCK *****
//*******************************************************************
//Class for accessing RP i2c Bus
//*******************************************************************
/**
* @class rp_i2c
* @~english
* @brief Class for accessing RP i2c bus
*
* The RP I2C bus can easily accessed with this class
* @~german 
* @brief Klasse für den zugriff auf den RP I2C Bus
*
* Die RP I2C Klasse gewährt einfachen Zugriff auf den I2C Bus
*/ 

class rp_i2c {
	bool error_flag;
	int slave_address;
	std::string devicefile;
	std::string ErrorMessage;
        int fd;
        int errorMsg(std::string message);
        int open_fd();
        void close_fd();
	void init(std::string DeviceFile, int Address);
public:
	rp_i2c();
	rp_i2c(int Address);
	rp_i2c(std::string DeviceFile, int Address);
	~rp_i2c();
	bool fail();
	int setAddress(int Address);
	int getAddress();
	const char *getErrorMessage();
	int setDevicefile(std::string filename);
	int receive(unsigned char *RxBuf, int length);
	int receive(unsigned char RegisterAddress, unsigned char *RxBuf, int length);
	int send(unsigned char *TxBuf, int length);
	int send(unsigned char RegisterAddress, unsigned char *TxBuf, int length);
	int send(unsigned char value);
};

