// gcc municipis_catalunya-1.0.c -o municipis_catalunya
// versió 1.0:

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h> 
#include <string.h>

char SOFTWARE[] = "municipis_catalunya";
char DATE[] = "setembre";
char YEAR[] = "2014";
char AUTHOR[] = "Joan Quintana Compte (joanillo)";
char LICENSE[] = "GPL v.3";
char WEB[] = "joanqc@gmail.com - www.joanillo.org";
char VERSION[] = "v1.0";

void print_capcalera (void);
void print_menu (void);

char *replace_str(char *str, char *old, char *new) {
  int i, count = 0;
  int newlen = strlen(new);
  int oldlen = strlen(old);
  
  for (i = 0; str[i]; ++i)
    if (strstr(&str[i], old) == &str[i])
      ++count, i += oldlen - 1;
  
  char *ret = (char *) calloc(i + 1 + count * (newlen - oldlen), sizeof(char));
  if (!ret) return;
  
  i = 0;
  while (*str)
    if (strstr(str, old) == str)
      strcpy(&ret[i], new),
      i += newlen,
      str += oldlen;
    else
      ret[i++] = *str++;
    
  ret[i] = '\0';

  return ret;
}

char *replace_str2(const char *str, const char *old, const char *new)
{
	char *ret, *r;
	const char *p, *q;
	size_t oldlen = strlen(old);
	size_t count, retlen, newlen = strlen(new);

	if (oldlen != newlen) {
		for (count = 0, p = str; (q = strstr(p, old)) != NULL; p = q + oldlen)
			count++;
		/* this is undefined if p - str > PTRDIFF_MAX */
		retlen = p - str + strlen(p) + count * (newlen - oldlen);
	} else
		retlen = strlen(str);

	if ((ret = malloc(retlen + 1)) == NULL)
		return NULL;

	for (r = ret, p = str; (q = strstr(p, old)) != NULL; p = q + oldlen) {
		/* this is undefined if q - p > PTRDIFF_MAX */
		ptrdiff_t l = q - p;
		memcpy(r, p, l);
		r += l;
		memcpy(r, new, newlen);
		r += newlen;
	}
	strcpy(r, p);

	return ret;
}
			

int strpos(char *haystack, char *needle)
{
   char *p = strstr(haystack, needle);
   if (p)
      return p - haystack;
   return -1;   // Not found = -1.
}

char* subString (const char* input, int offset, int len, char* dest)
{
  int input_len = strlen (input);

  if (offset + len > input_len)
  {
     return NULL;
  }

  strncpy (dest, input + offset, len);
  return dest;
}

char *reindexacio (char *);

int main(int argc, char *argv[]) {
	int mode;
	char c;
	FILE *ptr_fitxer;

	print_capcalera ();
	print_menu ();

	while(1)  {
		c = getchar();

		switch (c)
		{
			case 'q' : case 'Q':
				system("clear");
				printf("\n%s %s\n",SOFTWARE,VERSION);
				printf("\nCreated by %s.\n",AUTHOR);
				printf("Licensed under %s.\n\n",LICENSE);
				mode=0;
				break;
			case '1' : 
				mode = 1;
				break;
			case '2' : 
				mode = 2;
				break;
			case '3' : 
				mode = 3;
				break;
			case '4' : 
				mode = 4;
				break;
			case '5' : 
				mode = 5;
				break;
			case '6' : 
				mode = 6;
				break;
			default :
				break;
		}

		if ( mode == 0 ) break;
		//if ( mode==1 || mode==2 || mode==3 || mode==4 || mode==5 || mode==6 ) break;


		// 1: Llistar tots els municipis (llegir el fitxer línia a línia) ****************************************************************
		if (mode==1) {

	    	char buf[1000];

	    	ptr_fitxer =fopen("municipis.txt","r");
			if (!ptr_fitxer)
				return 1;

			while (fgets(buf,1000, ptr_fitxer)!=NULL) {
				printf("%s",buf);
			}

			fclose(ptr_fitxer);
			print_menu ();
			mode = -1;

		}

		// 1: Llistar tots els municipis (fiquem tot el fitxer en un buffer de memòria, i el bolquem a la pantalla) ****************************************************************
		if (mode==2) {

			//ficarem tot el contingut del fitxer en un buffer (punter a caràcters, char *)
			//http://stackoverflow.com/questions/3747086/reading-the-whole-text-file-into-a-char-array-in-c
			long lSize;
			char *buffer;

			ptr_fitxer = fopen ( "municipis.txt" , "rb" );
			if (!ptr_fitxer)
				return 1;

			fseek( ptr_fitxer , 0L , SEEK_END);
			lSize = ftell( ptr_fitxer );
			rewind( ptr_fitxer );

			/* allocate memory for entire content */
			buffer = calloc( 1, lSize+1 );
			if( !buffer ) fclose(ptr_fitxer),fputs("memory alloc fails",stderr),exit(1);

			/* copy the file into the buffer */
			if( 1!=fread( buffer , lSize, 1 , ptr_fitxer) ) {
				fclose(ptr_fitxer);
				free(buffer);
				fputs("entire read fails",stderr),exit(1);
			}
			/* do your work here, buffer is a string contains the whole text */

			fclose(ptr_fitxer);
			printf("%s\n", buffer);
			free(buffer);
			print_menu ();
			mode = -1;
		}

		// 3: Filtrar per municipi/comarca/província ****************************************************************
		if (mode==3) {

		    char filtre[100];
			printf("Entra el filtre: ");
			scanf(" %[^\n]s", filtre); //http://stackoverflow.com/questions/6282198/reading-string-from-input-with-space-character
	    	printf("filtre: %s\n", filtre);

	    	char buf[1000];

	    	ptr_fitxer =fopen("municipis.txt","r");
			if (!ptr_fitxer)
				return 1;

			while (fgets(buf,1000, ptr_fitxer)!=NULL) {
				if (strstr(buf,filtre)) { 
					printf("%s",buf);
				}
			}
			fclose(ptr_fitxer);
			print_menu ();
			mode = -1;

		}


		// 4: Modificar municipi per id (format municipi;comarca;provincia) ****************************************************************
		if (mode==4) {

			char str_ind[4];
			int ind;
			char registre[1000];
			char registre_temp[1000];
			long int pos;
			long int pos2;

			printf("Entra el id que vols modificar: ");
			scanf(" %[^\n]s", str_ind); //http://stackoverflow.com/questions/6282198/reading-string-from-input-with-space-character
	    	ind = atoi(str_ind);

			printf("Entra el nou valor (municipi;comarca;província): ");
			scanf(" %[^\n]s", registre_temp); //http://stackoverflow.com/questions/6282198/reading-string-from-input-with-space-character

			strcpy (registre, str_ind);
			strcat (registre, ";");
			strcat (registre, registre_temp);
			printf("Registre modificat: %s\n", registre);

			//ficarem tot el contingut del fitxer en un buffer (punter a caràcters, char *)
			//http://stackoverflow.com/questions/3747086/reading-the-whole-text-file-into-a-char-array-in-c
			long lSize;
			char *buffer;
			char *buffer_temp;
			char *buffer_temp2;

			ptr_fitxer = fopen ( "municipis.txt" , "rb" );
			if (!ptr_fitxer)
				return 1;

			fseek( ptr_fitxer , 0L , SEEK_END);
			lSize = ftell( ptr_fitxer );
			rewind( ptr_fitxer );

			/* allocate memory for entire content */
			buffer = calloc( 1, lSize+1 );
			if( !buffer ) fclose(ptr_fitxer),fputs("memory alloc fails",stderr),exit(1);

			/* copy the file into the buffer */
			if( 1!=fread( buffer , lSize, 1 , ptr_fitxer) ) {
				fclose(ptr_fitxer);
				free(buffer);
				fputs("entire read fails",stderr),exit(1);
			}
			/* do your work here, buffer is a string contains the whole text */
			fclose(ptr_fitxer);

			//cerquem la fila actual del registre que volem modificar
			pos = strpos(buffer, str_ind);
			printf("%li\n", pos);
			buffer_temp = calloc( 1, lSize-pos+1 );
			subString (buffer, pos, lSize-pos, buffer_temp);
			pos2 = strpos(buffer_temp, "\n");
			buffer_temp2 = calloc( 1, pos2 );
			subString (buffer_temp, 0, pos2, buffer_temp2);
			printf("%s\n", buffer_temp2);

			//modifiquem el buffer:
			buffer = replace_str(buffer, buffer_temp2, registre);
			//i ara hem de bolcar el buffer al fitxer, al revés que abans.
			ptr_fitxer = fopen ( "municipis.txt" , "w" );
			fprintf(ptr_fitxer,"%s", buffer);
			fclose(ptr_fitxer);

			//ja podem alliberar el buffer
			free(buffer);
			print_menu ();
			mode = -1;

		}


		// 5: Inserir municipi en una posició (format municipi;comarca;provincia) ****************************************************************
		if (mode==5) {

			char str_ind[4];
			int ind;
			long int pos;
			int pos2;

			printf("Entra el id: ");
			scanf(" %[^\n]s", str_ind);
			//printf("%s\n", str_ind);
			ind = atoi(str_ind);
			
		    char registre[1000];
		    char registre_temp[1000];

			printf("Entra les dades (municipi;comarca;província):");
			scanf(" %[^\n]s", registre_temp);
	    	printf("Nou registre: %s\n", registre_temp);

	    	strcpy(registre, str_ind);
	    	strcat(registre, ";");
	    	strcat (registre, registre_temp);
	    	printf("%s\n", registre);


			long lSize;
			char *buffer;
			char *buffer1;
			char *buffer2;
			char *buffer3;

			ptr_fitxer = fopen ( "municipis.txt" , "rb" );
			if (!ptr_fitxer)
				return 1;

			fseek( ptr_fitxer , 0L , SEEK_END);
			lSize = ftell( ptr_fitxer );
			rewind( ptr_fitxer );

			// allocate memory for entire content
			buffer = malloc( sizeof(char)*(lSize+1) );
			if( !buffer ) fclose(ptr_fitxer),fputs("memory alloc fails",stderr),exit(1);

			// copy the file into the buffer
			if( 1!=fread( buffer , lSize, 1 , ptr_fitxer) ) {
				fclose(ptr_fitxer);
				free(buffer);
				fputs("entire read fails",stderr),exit(1);
			}
			//do your work here, buffer is a string contains the whole text

			fclose(ptr_fitxer);
			printf("%s\n", buffer);


			pos = strpos( buffer, str_ind);
			printf("%li\n", pos);

			buffer1 = malloc( sizeof(char)*(pos) );
			strncpy(buffer1, buffer, pos);
			//printf("%s\n\n", buffer1);

			buffer2 = malloc( sizeof(char)*(lSize-pos+20) );

			buffer2 = strstr(buffer, str_ind);
			//printf("%s\n", buffer2);	

			free(buffer);
			buffer = malloc( sizeof(char)*(lSize+1000) );
			strcpy(buffer, buffer1);
			strcat(buffer, registre);
			strcat(buffer, "\n");
			strcat(buffer, buffer2);
			strcat(buffer, "\n");
			printf("%s\n", buffer);

			//free(buffer2); //falla?
			free(buffer3);

			buffer = reindexacio(buffer);


			//tornem a escriure en el fitxer
			ptr_fitxer = fopen ( "municipis.txt" , "w" );
			if (!ptr_fitxer)
				return 1;

			fprintf(ptr_fitxer,"%s", buffer);
			fclose(ptr_fitxer);


			free (buffer);

			print_menu ();
			mode = -1;

		}

		// 6: Eliminar municipi per id (format municipi;comarca;provincia) ****************************************************************
		if (mode==6) {

			char str_ind[4];
			int ind;
			long int pos;
			int pos2;

			printf("Entra el id: ");
			scanf(" %[^\n]s", str_ind);
			printf("%s\n", str_ind);
			ind = atoi(str_ind);
			printf("%d\n", ind);

	    	
			long lSize;
			char *buffer;
			char *buffer2;
			char *buffer3;

			ptr_fitxer = fopen ( "municipis.txt" , "rb" );
			if (!ptr_fitxer)
				return 1;

			fseek( ptr_fitxer , 0L , SEEK_END);
			lSize = ftell( ptr_fitxer );
			rewind( ptr_fitxer );

			/* allocate memory for entire content */
			buffer = malloc( sizeof(char)*(lSize+1) );
			if( !buffer ) fclose(ptr_fitxer),fputs("memory alloc fails",stderr),exit(1);

			/* copy the file into the buffer */
			if( 1!=fread( buffer , lSize, 1 , ptr_fitxer) ) {
				fclose(ptr_fitxer);
				free(buffer);
				fputs("entire read fails",stderr),exit(1);
			}
			/* do your work here, buffer is a string contains the whole text */

			fclose(ptr_fitxer);
			printf("%s\n", buffer);



			pos = strpos( buffer, str_ind);
			printf("%li\n", pos);
			buffer2 = malloc( sizeof(char)*(lSize-pos+1) );

			buffer2 = strstr(buffer, str_ind);
			//printf("%s\n", buffer2);	

			pos2 = strpos( buffer2, "\n"); //posició del retorn de carro
			buffer3 = malloc( sizeof(char)*(pos2+2) );
			strncpy(buffer3, buffer2, pos2+1);
			printf("%s\n", buffer3);
			buffer = replace_str2(buffer, buffer3, "");

			printf("%s\n", buffer);

			//free(buffer2); //falla?
			free(buffer3);

			buffer = reindexacio(buffer);


			//tornem a escriure en el fitxer
			ptr_fitxer = fopen ( "municipis.txt" , "w" );
			if (!ptr_fitxer)
				return 1;

			fprintf(ptr_fitxer,"%s", buffer);
			fclose(ptr_fitxer);


			free (buffer);

			print_menu ();
			mode = -1;

		}


	}


	return 0;
}

void print_capcalera ()   //Prints menu on screen
{
	system("clear");
	printf("\n%s %s\n",SOFTWARE,VERSION);
	printf("\nCreated by %s.\n",AUTHOR);
	printf("Licensed under %s.\n",LICENSE);
}

void print_menu ()   //Prints menu on screen
{
	printf ("\nEscull una opció:\n");
	printf ("1: Llistar tots els municipis (llegir el fitxer línia a línia)\n");
	printf ("2: Llistar tots els municipis (bolcar tot el fitxer en un buffer, i printar-lo)\n");
	printf ("3: Filtrar per municipi/comarca/província\n");
	printf ("4: Modificar municipi (format id;municipi;comarca;provincia)\n");
	printf ("5: Inserir municipi en una posició (format municipi;comarca;provincia)\n");
	printf ("6: Esborrar municipi (format id)\n");
	printf ("Q o Ctrl-C per sortir\n\n");
}
 
 char *reindexacio (char *buffer) {

 	printf("Falta la reindexacio.\n");
 	return buffer;
 }