console.log("Strings, formatar text");
console.log("=======================");
console.log("https://developer.mozilla.org/es/docs/Web/JavaScript/Guide/Text_formatting");
console.log();
console.log('cometes simples o cometes dobles:')
var cad1 = 'hola món';
var cad2 = "HOLA MÓN";

console.log(`${cad1}-${cad2}`);

console.log();
console.log('caràcters d\'escapament:')
console.log('\u00A9 INS Jaume Balmes'); // "©"

console.log();
const foo = new String('hola món'); // Crea un objeto String
console.log(foo); // Muestra: [String: 'foo']
console.log(foo.valueOf()); //aquest és el valor correcte de la cadena. valueOf() retorna la primitiva de la cadena 

console.log(typeof foo); // Devuelve 'object'

//evidentment, la manera més correcte de declarar cadenes és:
var cad = "hola món 2";
console.log(cad + " " + typeof cad);

console.log();
console.log('La funció eval() té com a argument una cadena, i en fa l\'avalució (en aquest cas, fa la suma correctament)');
const firstString = '2 + 2';              // Crea un valor de cadena literal
const secondString = new String('2 + 2'); // Crea un objeto String
console.log(eval(firstString)); // Devuelve el número 4
console.log(eval(secondString)); // Devuelve la cadena "2 + 2"
console.log(firstString);


console.log();
const hello = '¡Hola, mundo!';
const helloLength = hello.length;
hello[0] = 'L'; // Esto no tiene ningún efecto, porque las cadenas son inmutables
console.log(hello);
console.log(hello[1]);       // Esto devuelve "H"

console.log();
var cad = "Institut Jaume Balmes de Barcelona";

console.log('Propietat més important: length');
console.log(cad.length);

console.log();
console.log('Mètodes més importants: charAt(), indexOf(), includes(), concat(), split(), slice(), substring(), substr(), match(), replace(), toLowerCase(), toUpperCase(), repeat(), trim()');

console.log();
console.log('Exemple de: charAt()');
console.log(cad.charAt(0));

console.log();
console.log('Exemple de: indexOf()');
console.log(cad.indexOf('B'));
console.log(cad.indexOf('z'));

console.log();
console.log('Exemple de: includes()');
console.log(cad.includes('Balmes'));

console.log();
console.log('Exemple de: concat()');
console.log(cad.concat(', Catalunya'));

console.log();
console.log('Exemple de: split()');
var arr = cad.split(' ');
console.log(arr); //cerquem els espais en blan, i això ens serveix per convertir-ho a Array. S'utilitza molt
console.log(arr[1]);
console.log(arr.length);

console.log();
console.log('Exemple de: slice()'); //The slice() method extracts parts of a string and returns the extracted parts in a new string.
console.log(cad.slice(2,8)); //del caràcter 2 al caràcter 8 (el primer caràcter és el 0)
console.log(cad);

console.log();
console.log('Exemple de: substring()'); //The substring() method extracts characters, between to indices (positions), from a string, and returns the substring.
console.log(cad.substring(2,8));

// diferència entre slice i substring:
// https://stackoverflow.com/questions/2243824/what-is-the-difference-between-string-slice-and-string-substring

console.log();
console.log('Exemple de: substr()'); //extracts parts of a string, beginning at the character at a specified position, and returns a specified number of characters.
console.log(cad.substr(2,8));

console.log();
console.log('Exemple de: toLowerCase()');
console.log(cad.toLowerCase());

console.log();
console.log('Exemple de: toUpperCase()');
console.log(cad.toUpperCase())

console.log();
console.log('Exemple de: repeat()');
console.log(cad);
console.log('='.repeat(cad.length)); //en aquest cas ho fem servir per subratllar

console.log();
console.log('Exemple de: trim()');
cad = "   " + cad + "   ";
console.log(cad.length);
cad = cad.trim();
console.log(cad);
console.log(cad.length);

console.log();
// match i replace fan servir expressions regulars com a argument
console.log('Exemple de: match()');

const cadena = "Per a més informació, vegi el capítol 3.4.5 i el capítol 4.4.2";
let expressio = /(capítol \d+(\.\d)*)/ig;
let trobat = cadena.match(expressio);
console.log(trobat); //el resultat és un array

console.log();
console.log('Exemple de: replace()');
let cadena_reemplacada = cadena.replace(expressio, 'X');
console.log(cadena_reemplacada);
