console.log("Expressions regulars");
console.log("====================");
console.log("*https://developer.mozilla.org/es/docs/Web/JavaScript/Guide/Regular_Expressions");
console.log("*https://developer.mozilla.org/es/docs/Web/JavaScript/Guide/Regular_Expressions/Cheatsheet");
console.log("*https://www.w3schools.com/jsref/jsref_obj_regexp.asp");
console.log("*https://developer.mozilla.org/es/docs/Web/JavaScript/Guide/Regular_Expressions/Groups_and_Ranges#using_groups");

console.log();
//dues maneres de construir expressions regulars
let re1 = /ab+c/;
let re2 = new RegExp('ab+c');

let re3_a = /tg/g; //troba el grup 'tg' de forma global (totes les ocurrències)
let re3_b = /tg/i;
let re3_c = /tg/ig;

var cad_a = "setze jutges d'un jutjat mengen fetge d'un penjat";
var cad_b = "SETZE JUTGES D'UN JUTJAT MENGEN FETGE D'UN PENJAT";
console.log("cadena: " + cad_a);
console.log(re3_a.test(cad_a));
console.log(re3_a.exec(cad_a));
console.log(cad_a.match(re3_a));
console.log(cad_b.match(re3_a)); //no troba res
console.log(cad_b.match(re3_b));
console.log(cad_b.match(re3_c));

console.log("Classes de caràcters");
console.log("--------------------");
console.log("\\, ., \\cX, \\d, \\D, \\f, \\n, \\r, \\s, \\S, \\t, \\v, \\w, \\W, \\0, \\xhh, \\uhhhh, \\uhhhhh, [\\b]");

const chessStory = 'He played the King in a8 and she moved her Queen in c2.';
const regexpCoordinates = /\w\d/g;
console.log("Trobem de forma global una lletra seguida d'un número");
console.log(chessStory);
console.log(chessStory.match(regexpCoordinates));

console.log();
console.log("Assercions");
console.log("--------------------");
console.log("^, $, x(?=y), x(?!y), (?<=y)x, (?<!y)x, \\b, \\B");

const text = 'A quick fox';

const regexpLastWord = /\w+$/;
console.log(text.match(regexpLastWord));
// expected output: Array ["fox"]

const regexpWords = /\b\w+\b/g;
console.log(text.match(regexpWords));
// expected output: Array ["A", "quick", "fox"]

//si el que volem és trobar les paraules, és més fàcil fer:
const regexpWords2 = /\w+/g;
console.log(text.match(regexpWords2));
// expected output: Array ["A", "quick", "fox"]

const regexpFoxQuality = /\w+(?= fox)/;
console.log(text.match(regexpFoxQuality));
// expected output: Array ["quick"]


console.log();

console.log("Grups i rangs");
console.log("--------------------");
console.log("(x), (?:x), (?<Name>x), x|y, [xyz], [^xyz], \\Number");

const aliceExcerpt = 'The Caterpillar and Alice looked at each other';
const regexpWithoutE = /\b[a-df-z]+\b/ig; //paraules que no contenen la 'e'
console.log(aliceExcerpt.match(regexpWithoutE));
// expected output: Array ["and", "at"]

const imageDescription = 'This image has a resolution of 1440×900 pixels.';
const regexpSize = /([0-9]+)×([0-9]+)/;
const match = imageDescription.match(regexpSize);
console.log(`Width: ${match[1]} / Height: ${match[2]}.`);
// expected output: "Width: 1440 / Height: 900."


console.log();

console.log("Quantificadors");
console.log("--------------------");
console.log("*, +, ?, x{n}, x{n,}, x{n,m}");

const cad1 = '223332442222444';
const re4 = /222*/; //0 o més vegades amb l'expressió anterior
const re5 = /222+/; //1 o més vegades amb l'expressió anterior
const re6 = /222?/; //0 o 1 vegades amb l'expressió anterior
const re7 = /2222?/; //0 o 1 vegades amb l'expressió anterior
console.log(cad1.match(re4));
console.log(cad1.match(re5));
console.log(cad1.match(re6));
console.log(cad1.match(re7));

console.log();

const re8 = /2*/g; //0 o més vegades amb l'expressió anterior
const re9 = /2+/g; //1 o més vegades amb l'expressió anterior
const re10 = /2?/g; //0 o 1 vegades amb l'expressió anterior
const re11 = /22?/g; //0 o 1 vegades amb l'expressió anterior
console.log(cad1.match(re8));
console.log(cad1.match(re9));
console.log(cad1.match(re10));
console.log(cad1.match(re11));

const ghostSpeak = 'booh boooooooh';
const regexpSpooky = /bo{3,}h/;
console.log(ghostSpeak.match(regexpSpooky));
// expected output: Array ["boooooooh"]

const modifiedQuote = '[He] ha[s] to go read this novel [Alice in Wonderland].';
const regexpModifications = /\[.*?\]/g;
console.log(modifiedQuote.match(regexpModifications));
// expected output: Array ["[He]", "[s]", "[Alice in Wonderland]"]

const regexpTooGreedy = /\[.*\]/g;
console.log(modifiedQuote.match(regexpTooGreedy));
// expected output: Array ["[He] ha[s] to go read this novel [Alice in Wonderland]"]


console.log();

console.log("Escapaments");
console.log("--------------------");
console.log("Què passa si cerquem un caràcter especial, com ara el punt . o el asterisc *?")
const cad2 = 'aquesta cadena conté un punt. I també un asterisc *, i els volem trobar.';
const re12 = /[\.|\*]/g
console.log(cad2.match(re12));

console.log();

console.log("Mètodes de RegExp")
console.log("--------------------");
console.log("Els més importants: exec(), test(), match()");
console.log("També tenim: matchAll(), search(), replace(), replaceAll(), split()");

console.log('exec(), test() i match() ja les hem probat.');

console.log('str.search(expresionregular)');
console.log('32343354323'.search(/3{2}/)); //troba la posició '33'
console.log('32343354323'.search(/3{4}/));
const cad3 = 'les ciències: pedago*, sociolo*, criminolo*, musicolo*';
console.log(cad3.replace(/\*/,'gia')); //només la primera
console.log(cad3.replace(/\*/g,'gia')); //totes
//replace i replaceAll admeten en el primer argument tant una expressió regular com una cadena. Són mètodes de String
console.log(cad3.replace('*','gia'));
console.log(cad3.replaceAll('*','gia'));
console.log();

//volem trobar quines són les variables que hi ha en aquesta cadena
const cad4 = "nom: $1, cognom: $2, mail: $3, telefon: $4"; 
console.log(cad4.split(/\$/)); //s'ha de millorar
console.log(cad4.split(/:\s\$\d\,?\s?/));
//l'últim element està buit perquè el caràcter de separació està al final de tot. Per eliminar-lo:
let arr_variables = cad4.split(/:\s\$\d\,?\s?/)
console.log(arr_variables.length);
arr_variables.pop();
console.log(arr_variables.length);
for (let i=0; i<arr_variables.length;i++) {
	console.log(arr_variables[i]);
}

