console.log("Numbers and dates");
console.log("=================");

console.log("https://developer.mozilla.org/es/docs/Web/JavaScript/Guide/Numbers_and_dates");

console.log("Números");
console.log("=================");

let num = 34;
console.log(num + ' ' + typeof num);

//binari
var FLT_SIGNBIT  = 0b10000000000000000000000000000000; // 2147483648
console.log(FLT_SIGNBIT + ' ' + typeof FLT_SIGNBIT);

//octal
var num_octal  = 0755; // 493
console.log(num_octal + ' ' + typeof num_octal);

//hexadecimal
var num_hex  = 0XA; // 10
console.log(num_hex + ' ' + typeof num_hex);


//exponents
var num2 = 2e6;  // 2000000
console.log(num2 + ' ' + typeof num_hex);

console.log();
console.log('Objecte Number');
console.log('----------------');
console.log('Propietats i mètodes (referència):');
console.log('https://developer.mozilla.org/es/docs/Web/JavaScript/Reference/Global_Objects/Number');


var txt_num_decimal = "5.64";
console.log(Number.parseInt(txt_num_decimal,10)); //mètode de l'objecte Number
console.log(parseInt(txt_num_decimal, 10)); //funció global. Les dues maneres funcionen de la mateixa manera.

console.log(Number.isFinite(5/2)); //true
console.log(Number.isFinite(5/0)); //false

var x = "23.5485";
console.log(Number.parseFloat(x).toFixed(2)); //23.55 fa l'arrodoniment
console.log(Number.parseFloat(x).toPrecision(5)); //23.549 fa l'arrodoniment

console.log();
console.log('Objecte Math');
console.log('----------------');
console.log(Math.PI);
console.log(Math.PI.toFixed(4));

console.log(Math.sin(1.56)); //1.56 és aprox Pi/2, i recordeu que sin(pi/2)=1
//exemple d'aplicació de les funcions trigonomètriques: efecte persiana:
//https://www.jose-aguilar.com/scripts/css/efecto-persiana/

console.log();
console.log('Diferents exemples:');
console.log(Math.abs(-3));
console.log(Math.pow(3,4));
console.log(Math.exp(2)); //e^2
console.log(Math.floor(3.68)) //3. no hi ha arrodoniment
console.log(Math.ceil(3.28)) //4. no hi ha arrodoniment

console.log(Math.random())

console.log("Trobar números aleatori entre 1 i 20:")
for (let i=0;i<40;i++) {
	console.log(Math.floor(Math.random()*20)+1);
}

console.log();
console.log("arrodoniment (round):");
console.log(Math.round(3.1416)); //3
console.log(Math.round(3.6)); //4
console.log(Math.round(3.5)); //3.5 arrodoneix a 4 (hi ha dos meitats: del 0 al 4 i del 5 al 9)

console.log();
console.log("l' arrel quadrada de 121 és: " + Math.sqrt(121));

console.log();
console.log('Objecte Date');
console.log('----------------');
//JavaScript no tiene un tipo de dato para fechas. Sin embargo, puedes utilizar el objeto Date
//y sus métodos para trabajar con fechas y horas en tus aplicaciones.
//El objeto Date tiene una gran cantidad de métodos para establecer, obtener y manipular fechas.
//Pero no tiene propiedades.

console.log('les dates es guarden internament amb un número: el número de milisegons que ha passat des del 01/01/1970 00:00:00');
console.log('És important saber consultar la referència:');
console.log('https://www.w3schools.com/jsref/jsref_obj_date.asp');
console.log('https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date');

console.log('var d1 = new Date();');
var d1 = new Date(); //la data actual del sistema
console.log(d1);
console.log(d1.getTime() + ' milisegons'); //retrona els milisegons que han passat des del 01/01/1970

console.log(d1/1000 + ' segons'); // com podem veure en aquest exemple, d1 és internament un número


console.log('var d2 = new Date(milliseconds);');
var d2 = new Date(3000); //3 segons després del 01/01/1970 00:00:00
console.log(d2);

console.log('var d3 = new Date(dateString);');
var d3 = new Date("December 25, 1995 13:30:00");
console.log(d3);

console.log('var d4 = new Date(year, month, day, hours, minutes, seconds, milliseconds);');
var d4 = new Date(2021, 8, 11, 12, 0, 0, 0);
console.log(d4);

function JSClock() {
  var time = new Date();
  var hour = time.getHours();
  var minute = time.getMinutes();
  var second = time.getSeconds();
  var temp = '' + ((hour > 12) ? hour - 12 : hour);
  if (hour == 0)
    temp = '12';
  temp += ((minute < 10) ? ':0' : ':') + minute;
  temp += ((second < 10) ? ':0' : ':') + second;
  temp += (hour >= 12) ? ' PM' : ' AM';
  return temp;
}

console.log('L\'hora actual:');
console.log(JSClock())

function DataActual() {
	var dies_setmana = ['diumenge', 'dilluns', 'dimarts', 'dimecres', 'dijous', 'divendres', 'dissabte'];
	var mesos = ['gener', 'febrer', 'març', 'abril', 'maig', 'juny', 'juliol', 'agos', 'setembre', 'octubre', 'novembre', 'desembre'];
	var time = new Date();
	var dia = time.getDate();
	var dia_setmana = time.getDay(); //0-6, 0: diumenge
	var mes = time.getMonth(); //0-11
	var year = time.getFullYear();
	var arr_formats = [];
	var format1 = dies_setmana[dia_setmana] + ", " + dia + "/" + (mes+1) + "/" + year;
	var format2 = dia + "-" + (mes+1) + "-" + year;
	var format3 = dies_setmana[dia_setmana] + ", " + dia + " de " + mesos[mes+1] + " de " + year;
	arr_formats.push(format1);
	arr_formats.push(format2);
	arr_formats.push(format3);

	return arr_formats;
}
console.log(DataActual()[0]);
console.log(DataActual()[1]);
console.log(DataActual()[2]);

//getTimezoneOffset()	Returns the time difference between UTC time and local time, in minutes
console.log(d1.getTimezoneOffset()); //120 minuts significa que són dues hores de diferència amb l'hora UTC (120 si estem en horari d'estiu, 60 si estem en horari d'hivern)

//getUTCHours()	Returns the hour, according to universal time (from 0-23)
console.log(d1.getUTCHours()); //hora universal

console.log(`Des del 01/01/1970 han passat ${Date.now()} milisegons`);


console.log();
console.log('Després hi ha totes les funcions set (setters):');

var ara = new Date();
ara.setDate(15);
ara.setHours(15); //posa l'hora UTC, no la local
ara.setMinutes(15);
console.log(ara);

//toDateString()	Converts the date portion of a Date object into a readable string
ara = new Date();
console.log(ara.toDateString());
console.log(ara.toLocaleDateString());
console.log(ara.toString());
