console.log("Funcions");
console.log("===================");
console.log("https://developer.mozilla.org/es/docs/Web/JavaScript/Guide/Functions");

console.log();
console.log("Definir funcions");
console.log("----------------");

function square(number) {
  return number * number;
}

let costat = 5;
console.log("L'àrea del quadrat de costat " + costat + " m val " + square(5) + " m^2");

function myFunc(theObject) {
  theObject.make = 'Toyota';
}

var mycar = { make: 'Honda', model: 'Accord', year: 1998 };
var x, y;

x = mycar.make; // x obtiene el valor "Honda"

myFunc(mycar);
y = mycar.make; // y obtiene el valor "Toyota"
                // (la propiedad make fue cambiada por la función)
console.log(x);
console.log(y);

console.log("funcions anònimes (no tenen nom):");
const square2 = function(number) { return number * number }
x = square2(4) // x obtiene el valor 16
console.log(x);

console.log("Però normalment interessa posar un nom a les funcions:");
const factorial = function fac(n) { return n < 2 ? 1 : n * fac(n - 1) }

console.log(factorial(10))

console.log();
console.log("Podem passar una funció com a argument d'una altra funció (mapejar):");

function map(f, a) {
  let result = []; // Crea un nuevo arreglo
  let i; // Declara una variable
  for (i = 0; i != a.length; i++)
    result[i] = f(a[i]);
  return result;
}
const f = function(x) {
   return x * x * x;
}

let numbers = [0, 1, 2, 5, 10];
let cube = map(f,numbers);
console.log(cube);
console.log();


console.log("Els objectes tenen propietats i mètodes. De fet els mètodes també són propietats, la única cosa que estan definits com a funcions (ho veurem més endavant).")

console.log();
console.log("Cridar a les funcions");
console.log("---------------------");

square(5);
//però millor: (si la funció retorna un valor, necessitem algú que reculli el que retorna la funció)
console.log(square(5));

console.log();
console.log("Funció que es crida a ella mateixa: la funció factoria, exemple típic de recursivitat");

function factorial2(n) { //factorial() estava declarat més amunt, hem de posar un altre nom
  if ((n === 0) || (n === 1))
    return 1;
  else
    return (n * factorial2(n - 1));
}

for (let i=0;i<5;i++) {
	console.log(`El factorial de ${i} és ${factorial(i)}`);
}

console.log();
console.log("Àmbit de function");
console.log("-----------------");

// Las siguientes variables se definen en el ámbito global
var num1 = 20,
    num2 = 3,
    name = 'Chamahk';

// Esta función está definida en el ámbito global
function multiply() {
  return num1 * num2;
}

console.log(multiply()); // Devuelve 60

console.log();

// Un ejemplo de función anidada
function getScore() {
  var num1 = 2,
      num2 = 3;

  function add() {
    return name + ' anotó ' + (num1 + num2);
  }

  return add();
}

console.log(getScore()); // Devuelve "Chamahk anotó 5"

console.log();
console.log();
console.log("Àmbit i la pila de funcions");
console.log("---------------------------");

var x = 0;
while (x < 10) { // "x < 10" es la condición del bucle
   console.log("comptador dins d'un bucle: " + x);
   x++;
}

console.log();
console.log("Fem el mateix, però amb una funció que es crida a ella mateixa de forma recursiva:");

function loop(x) {
  if (x >= 10) // "x >= 10" es la condición de salida (equivalente a "!(x < 10)")
    return;
	console.log("comptador recursiu: " + x);
  loop(x + 1); // la llamada recursiva
}
loop(0);


console.log();
console.log("TODO. Fem l'exemple a classe de recórrer tots els nodes del DOM de forma recursiva (formulari_dom.html).");

console.log();
console.log("Funcions aniuades (una funció dins d'una altra)");

function addSquares(a, b) {
  function square(x) {
    return x * x;
  }
  return square(a) + square(b);
}
console.log(addSquares(2, 3)); // devuelve 13
console.log(addSquares(3, 4)); // devuelve 25
console.log(addSquares(4, 5)); // devuelve 41

console.log();

function outside(x) {
  function inside(y) {
    return x + y;
  }
  return inside;
}
fn_inside = outside(3); // Piensa en ello como: dame una función que agregue 3 a lo que sea que le des
                        // eso
console.log(fn_inside(5)); // devuelve 8
console.log(outside(3)(5)); // devuelve 8

console.log();
console.log("Tancaments");
console.log("----------------");
console.log("La función externa no tiene acceso a las variables y funciones definidas dentro de la función interna. Esto proporciona una especie de encapsulación para las variables de la función interna.");

var pet = function(name) {   // La función externa define una variable llamada "name"
  var getName = function() {
    return name;             // La función interna tiene acceso a la variable
                             // "name" de la función externa
  }
  return getName;            // Devuelve la función interna, exponiéndola así a ámbitos externos
}
myPet = pet('Vivie');

console.log(myPet()); // Devuelve "Vivie"

console.log();

console.log();
console.log("Utilitzar l'objecte arguments");
console.log("-----------------------------");

console.log("El arguments de una función se mantiene en un objeto similar a un arreglo. Dentro de una función, puedes abordar los argumentos que se le pasan de la siguiente manera: arguments[i]");
console.log();

function myConcat(separator) {
   var result = ''; // inicia list
   var i;
   // itera a través de arguments
   for (i = 1; i < arguments.length; i++) {
      result += arguments[i] + separator;
   }
   return result;
}

console.log(myConcat(', ', 'red', 'orange', 'blue'));
console.log();

console.log("Paràmetres de funció");
console.log("--------------------");

console.log("Hi ha la possiblitat de què hi hagi paràmetres predeterminats. Per exemple:")

function multiply(a, b) {
  b = typeof b !== 'undefined' ?  b : 1; //operador ternari, el veiem a la propera classe

  return a * b;
}

console.log(multiply(5,3)); // 15
console.log(multiply(5)); // 5

console.log("Amb ECMAScript 2015 ho podem fer així:");
function multiply2(a, b = 1) {
  return a * b;
}

console.log(multiply2(8,3)); // 24
console.log(multiply2(8)); // 8

console.log();
console.log("Funcions fletxa");
console.log("---------------");

var a = [
  'Hidrógeno',
  'Helio',
  'Litio',
  'Berilio'
];

var a2 = a.map(function(s) { return s.length; });

console.log(a2); // logs [9, 5, 5, 7]

var a3 = a.map(s => s.length);

console.log(a3); // logs [9, 5, 5, 7]

console.log();

console.log("Aquest exemple funciona si executem p.age a la consola en diferents instants de temps.");
console.log("La funció setInterval() la veurem en d'altres ocasions.");
function Person() {
  var self = this; // Algunos eligen `that` en lugar de` self`.
                   // Elige uno y se congruente.
  self.age = 0;

  setInterval(function growUp() {
    // La retrollamada se refiere a la variable `self` de la cual
    // el valor es el objeto esperado.
    self.age++;
  }, 1000);
}

//p = new Person();
//console.log(p.age);

console.log();
console.log("Funcions predefinides");
console.log("---------------------");
console.log("parseInt() és una funció predefinida. No és un mètode dels números o strings");
var num = 3.1416;
console.log(parseInt(num)); //així si
//console.log(num.parseInt()) // això no!!
