console.log("Arrays. Col·leccions indexades");
console.log("=============================)");
console.log("https://developer.mozilla.org/es/docs/Web/JavaScript/Guide/Indexed_collections");

console.log();
console.log("L'objecte Array");
console.log("---------------");
console.log("Un array és una llista ordenada de valores als que ens referim amb un nom i un index.");

//diferents maneres de declarar un Array
let arr1 = new Array('taronja', 'poma', 'pera', 'raïm');
let arr2 = Array('taronja', 'poma', 'pera', 'raïm')
let arr3 = ['taronja', 'poma', 'pera', 'raïm'] // array literal

console.log(arr1.length);

//Per crear un array buit de 4 elements:
let arr4 = new Array(4) //compte! això no és un array d'un sol element que conté el número 4

let arr5 = Array(4)

let arr6 = []
arr6.length = 4
console.log(arr6.length);
console.log(arr6[0]); //undefined

//si vull crear un array d'un sol element que conté el número 4:
let arr7 = [4]
console.log(arr7.length);
console.log(arr7[0]);

console.log();
//omplim un array amb valors:
let emp = [];
emp[0] = 'Casey Jones';
emp[1] = 'Phil Lesh';
emp[2] = 'August West';

console.log();
let arr8 = []
arr8[3.4] = 'Oranges'; //com que 3.4 no és un index vàlid, ese crea una propietat en l'objecte que representa l'array, en lloc d'un element de l'array.
console.log(arr8);
console.log(typeof arr8);
console.log(arr8.length);                 // 0
console.log(arr8.hasOwnProperty(3.4));    // true
console.log(arr8['3.4']);
console.log(arr8[0]); //undefined (no és un array!)

console.log();

let cats = ['Dusty', 'Misty', 'Twiggy']
console.log(cats.length)  // 3

cats.length = 2
console.log(cats)  // logs "Dusty, Misty" - Twiggy se ha eliminado

cats.length = 0
console.log(cats)  // logs []; el arreglo cats está vacío

cats.length = 3
console.log(cats)  // logs [ <3 elementos vacíos> ]

console.log();
console.log('Iterant sobre els arrays');
console.log('------------------------');

let colors1 = ['red', 'green', 'blue']
for (let i = 0; i < colors1.length; i++) {
  console.log(colors1[i]);
}

console.log();

let colors2 = ['red', 'green', 'blue']
colors2.forEach(function(color) {
  console.log(color)
})

// La función que passem al forEach (la funció de callback) s'executa un cop per cada element de l'array.
console.log();

//amb l'operador fletxa
let colors3 = ['red', 'green', 'blue']
colors3.forEach(color => console.log(color))


/*
https://developer.mozilla.org/es/docs/Web/JavaScript/Reference/Global_Objects/Array/forEach

arr.forEach(function callback(currentValue, index, array) {
    // tu iterador
}[, thisArg]);
*/

console.log();
console.log('Mètodes dels arrays');
console.log('------------------------');
// https://www.w3schools.com/jsref/jsref_obj_array.asp
// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array
console.log('concat, join, push, pop, shift, unshift, slice, splice, reverse, sort, indexOf, lastIndexOf, forEach, map, filter, every, some, reduce, reduceRight');

console.log();
console.log('*** concat i join ***');

let arr9 = new Array('1', '2', '3')
arr9 = arr9.concat('a', 'b', 'c')
console.log(arr9);

let arr10 = new Array('pluja', 'ruixat', 'calamarsa', 'tempesta')
let txt_llista = arr10.join('-')   // 'pluja-ruixat-calamarsa-tempesta'
console.log(txt_llista);

console.log();
console.log('*** push i pop ***');
let arr11 = new Array('1', '2')
arr11.push('3') // myArray ahora es ["1", "2", "3"]
console.log(arr11);
//exemple: codi de http://projects.joanillo.org/municipis/

let last = arr11.pop()
console.log(arr11);
console.log(last);

//si vull buidar totalment un array:
let diesSetmana = ['diumenge', 'dilluns', 'dimarts', 'dimecres', 'dijous', 'divendres', 'dissabte'];
while (diesSetmana.length > 0) {
	console.log(diesSetmana.pop()); //anem buidant un a un
}
console.log(diesSetmana.length); //l'array ha quedat buit
console.log();
console.log('*** shift i unshift ***');
//shift: elimina el primer elemento de un arreglo y devuelve ese elemento.
let arr12 = new Array ('1', '2', '3')
let first = arr12.shift()
// arr12 ahora es ["2", "3"], first es "1"
console.log(first);
console.log(arr12);

//unshift: agrega uno o más elementos al principio de un arreglo y devuelve la nueva longitud del arreglo.
let arr13 = new Array('1', '2', '3')
console.log(arr13.unshift('4', '5'))
// myArray se convierte en ["4", "5", "1", "2", "3"]
console.log(arr13);

console.log();
console.log('*** slice i splice ***');
// slice(start_index, upto_index) extrae una sección de un arreglo y devuelve un nuevo arreglo.
let arr14 = new Array('a', 'b', 'c', 'd', 'e')
arr14 = arr14.slice(1, 4) // comienza en el índice 1 y extrae todos los elementos hasta el índice 3, devuelve ["b", "c", "d"]
console.log(arr14);

let arr15 = new Array('1', '2', '3', '4', '5')
arr15.splice(1, 3, 'a', 'b', 'c', 'd')
// myArray ahora es ["1", "a", "b", "c", "d", "5"]
// Este código comenzó en el índice uno (o donde estaba el "2"),
// eliminó 3 elementos allí, y luego insertó todos los consecutivos
// elementos en su lugar.
console.log(arr15);

console.log();
console.log('*** reverse ***');
let arr16 = new Array ('1', '2', '3')
arr16.reverse()
// transpone el arreglo para que myArray = ["3", "2", "1"]
console.log(arr16);

console.log();
console.log('*** sort ***');
// sort() ordena los elementos de un arreglo en su lugar y devuelve una referencia al arreglo.
let mesos = ['gener', 'febrer', 'març', 'abril', 'maig', 'juny', 'juliol', 'agost', 'setembre', 'octubre', 'novembre', 'desembre'];
console.log(mesos.sort());
console.log(mesos); //compte! el mètode sort retorna l'array ordenat. És a dir, l'array ha quedat ordenat

//sort() també pot agafar una funció retrocrida per determinar com es comparan els elements de l'array.

//Per exemple, podem ordenar per la tercera lletra de la cadena:
let sortFn1 = function(a, b) {
  if (a[2] < b[2]) return -1;
  if (a[2] > b[2]) return 1;
  if (a[2] == b[2]) return 0;
}
mesos.sort(sortFn1)
console.log(mesos); 

console.log();

//Per exemple, podem ordenar per la longitud de la cadena:
let sortFn2 = function(a, b) {
  if (a.length < b.length) return -1;
  if (a.length > b.length) return 1;
  if (a.length == b.length) return 0;
}
mesos.sort(sortFn2)
console.log(mesos); 

// exemple real: http://rutesgps.joanillo.org/ -> les rutes estan ordenades alfabèticament

console.log();

console.log('*** indexOf i lastIndexOf ***');
let arr17 = ['a', 'b', 'a', 'b', 'a']
console.log(arr17.indexOf('b')) // registros 1

// Ahora inténtalo de nuevo, comenzando después de la última coincidencia
console.log(arr17.indexOf('b', 2)) // registra 3
console.log(arr17.indexOf('z')) // logs -1, porque no se encontró 'z'

console.log(arr17.lastIndexOf('b'))

console.log();
console.log('*** forEach ***');
// forEach(callback[, thisObject]) ejecuta callback en cada elemento del arreglo y devuelve undefined.
let arr18 = ['a', 'b', 'c', 'd', 'e']
arr18.forEach(function(element) { console.log(element) })

console.log();

arr18.forEach(function(element,ind) {
	console.log(ind + ": " + element);
})

console.log();
//definim la funció externament
function logArrayElements(element, index, array) {
    console.log("a[" + index + "] = " + element);
}

arr18.forEach(logArrayElements);

console.log();
console.log('*** map ***');
//map(callback [, thisObject]) retorna un nou array resultant del que retorna la funció callback per cadascun dels elements de l'array original

let arr19 = ['a', 'b', 'c']
let arr20 = arr19.map(function(item) { return item.toUpperCase() })
console.log(arr20) // registra ['A', 'B', 'C']

console.log();
console.log('*** filter ***');
//filter(callback [, thisObject]) devuelve un nuevo arreglo que contiene los elementos para los cuales callback devolvió true.
let arr21 = ['a', 10, 'b', 20, 'c', 30]
let arr22 = arr21.filter(function(item) { return typeof item === 'number'; })
console.log(arr22)  // registra [10, 20, 30]

console.log();
console.log('*** every ***');
//every(callback [, thisObject]) devuelve true si callback devuelve true para cada elemento del arreglo.

function isNumber(value) {
  return typeof value === 'number'
}
let arr23 = [1, 2, 3]
console.log(arr23.every(isNumber))  // registra true
let arr24 = [1, '2', 3]
console.log(arr24.every(isNumber))  // registra false

console.log();
console.log('*** some ***');
//some(callback[, thisObject]) devuelve true si callback devuelve true para al menos un elemento del arreglo.
function isNumber(value) {
  return typeof value === 'number'
}
let arr25 = [1, 2, 3]
console.log(arr25.some(isNumber))  // registra true
let arr26 = [1, '2', 3]
console.log(arr26.some(isNumber))  // registra true
let arr27 = ['1', '2', '3']
console.log(arr27.some(isNumber))  // registra false

console.log();
console.log('*** reduce ***');
//reduce(callback[, initialValue]) aplica callback(acumulador, currentValue[, currentIndex[,array]]) para cada valor en el arreglo con el fin de reducir la lista de elementos a un solo valor. La función reduce devuelve el valor final devuelto por la función callback. 
let arr28 = [10, 20, 30]
let total = arr28.reduce(function(accumulator, currentValue) { return accumulator + currentValue }, 0)
console.log(total) // resultat: 60

console.log();
console.log('*** reduceRigth ***');
//reduceRight(callback[, initialValue]) funciona como reduce(), pero comienza con el último elemento.

console.log();
console.log('Arrays multidimensionals');
console.log('------------------------');
//els arrays es poden anidar, per tal de formar arrays multidimensionals. Això significa que un array pot contenir un altre array com a element.
//exemple: http://projects.joanillo.org/la_palma/

let arr29 = new Array(5)
for (let i = 0; i < 5; i++) {
  arr29[i] = new Array(3)
  for (let j = 0; j < 3; j++) {
    arr29[i][j] = i + '-' + j;
  }
}

console.log(arr29);
console.log(arr29.length); //5
console.log(arr29[0].length); //3