/*********************************************************************************************
*										                                                               *
*  lilypond2musicbox - lilypond to bitmap converter for DIY Music Box   							* 
*                                                              										*
*  Author: Joan Quintana                          															*
*  email:  joanqc@gmail.com                     															*
*  www:    http://www.joanillo.org                      													*
*                                                              										*
*  file: lilypond2musicbox_1_05.cpp                                        						*
*  date: january-2010                                            										*
*																															*
*  version: 1.05                                                										*
*                                                              										*
*  License: GPL v 2                                           											*
*  Copyright: 2009 by Joan Quintana                       												*
*                                                              										*
*  description: Source Code for lilypond2musicbox, a lilypond 											*
*              (music score format) to bitmap converter, intended 									*
*           	using with DIY Music Box by ThinkGeek.com 												*
*              or other music boxes																				*
*																															*
*  to compile: g++ -o lilypond2musicbox lilypond2musicbox_1_05.cpp EasyBMP.cpp					*
*																															*
*  this software is developed with EasyBMP v1.06                                             *
*  explanation: I bought a DIY Music Box from thinkgeek.com, and I want to automatize        *
*              the creation of punch cards from lilypond files. The program generates        *
*              a printable bmp file showing the pattern of the dots you're going to punch.   *
*					This DIY Music Box is manufactured by kikkerland.com									*
*					more info: http://www.thinkgeek.com/geektoys/science/8f7f/ 							*
*  comments: 																											*
*              -de moment tot el staff ha d'estar en una sola línia									*
*              -At this moment only accept triplet 2/3													*
*              -at this moment beats could be 1,2,4,8,16													*
*              -tresets només he considerat treset de corxees i treset de negres					*
*              -no hi ha sostinguts. Això és lo propi en les caixes de música. La partitura 	*
*                   s'ha d'arranjar per tal que no hi hagi sostinguts abans de processar-la.	*
*              -per determinar la primera nota a on comença, es cerca per relative c' 			*
*                   (do central, el que està una ratlla per sota el pentagrama), relative c  *
*						  o relative c''. Aleshores la primera nota és la que està més a la 			*
*						  vora d'aquest relative.																	*
*					-condicions que imposo per a la paginació: l'inici de pàgina ha de començar 	*
*						amb l'inici de compàs; la primera nota de la pàgina ha de contenir el 		*
*						valor de la durada de la nota.															*
*					-haurem de seguir obligatòriament el format %staff i %pag, encara que la 		*
*						cançó només tingui un staff i una pàgina. Veure una cançó d'exemple per		*
*						tal de seguir el format. Per exemple: una_plata_denciam_v7.ly					*
*					-tots els staffs d'una pàgina han de tenir la mateixa durada. Per ex,			*
*						staff1,pag2 ha de durar el mateix que staff2,pag2 i que staff3,pag2			*
*					-cada staff té el seu relative de forma obligatòria (veure exemple)				*
*					-si no fico el paràmetre -p, processa totes les pàgines, i obtenim un			*
*						bitmpa per cada pàgina.																		*
*					-si no fico el paràmetre -s significa processar tots els staffs					*
*					-si no fico -o, agaga output[p].bmp: output1.bmp per a pag=1,...					*
*					-d design parameter. [-d kikkerland]. design kikkerland corresponds to the		*
*						DIY Music Box sold by Think Geek. Recompiling is it possible to define		*
*						other designs, how is intended by the author.										*
*																															*
*	Exemples: 	./lilypond2musicbox -i mayim_mayim_v2.ly -o mayim										*
*					./lilypond2musicbox -i una_plata_denciam_v7.ly -s 2 -p 2 -o una_plata			*
*					./lilypond2musicbox -i una_plata_denciam_v7.ly -d kikkerland						*
*																															*
*																															*
* conversió beats-valor_temps:																					*
* beats																													*
* -----																													*
* 1 -> 16 (rodona)																									*
*   -> 12 (blanca amb punt)																						*
* 2 -> 8 (blanca)																										*
*   -> 6 (negra amb punt)																							*
* 4 -> 4 (negra)																										*
*   -> 3 (corxea amb punt)																							*
* 8 -> 2 (corxea)																										*
* 16 -> 1 (semicorxea)																								*
*																															*
* però això ho multipliquem tot per 3 per tenir en compte els triplets								*
* conversió beats-valor_temps:																					*
* beats																													*
* -----																													*
* 1 -> 48 (rodona)																									*
*   -> 36 (blanca amb punt)																						*
* 2 -> 24 (blanca)																									*
*   -> 18 (negra amb punt)																							*
* 4 -> 12 (negra)																										*
*   -> 9 (corxea amb punt)																							*
* 8 -> 6 (corxea)																										*
*   -> 4 (triplet 2/3)																								*
* 16 -> 3 (semicorxea)																								*	
* 																															*
* NOTA: Per ajustar el bitmap a les dimensions requerides (per al DIY Music Box de Think Geek*
o qualsevol	 altre sistema) he de jugar amb dues opcions: pixels_nota (que em diu l'amplada  *
 en pixels entre dues notes consecutives) i el factor_temps. Per al DIY Music Box de Think   *
Geek la manera de procedir és: factor_temps=4 i const pixels_nota=6, i a més 						*
margin_left=margin_right=19,																						*
i quan vaig a imprimir acabar d'ajustar l'amplada de la impressió a 41mm.							*
Compte! amb la manera com les impressores intenten imprimir els bitmaps. Si la llargada		*
de la cançó és massa llarga, i la impressora ho ajusta a una pàgina, aleshores és possible	*
que l'amplada sigui inferior a 41mm. La prova que he fet amb Una Plata d'Enciam és la mida	*
justa, més llarga i no hi cabria. Aleshores la manera de procedir serà ficar una marca dins	*
del fitxer de lilupond que signifiqui per al software 'canvi de fitxer', i aleshores tenir	*
varis fitxers a imprimir que s'hauran de solapar correctament...										*
**********************************************************************************************/

#include "EasyBMP.h"
using namespace std;
#include <iostream>
#include <string>
#include <stdio.h>
#include <stdlib.h>
#include <vector>

void processa_linia(string);
void processa_staff(string);
void processa_pag(string);
void processa_treset(string);
void imprimir_nota(string, int, string, int, int);

/* my_itoa: convert n to string */
char* my_itoa(unsigned int n) {
int i=0,c=0,j=0;
char *s = NULL;
do {
s = (char *) realloc(s, (i+1)*sizeof( char));
s[i++] = n % 10 + '0';
} while ((n /= 10) > 0);
s = (char *) realloc(s, i*sizeof( char));
s[i] = '\0';
for (i = 0, j = strlen(s) - 1; i < j; i++, j--) {
c = s[i];
s[i] = s[j];
s[j] = c;
}
return s;
}


string trim(string);
string nota;
string beat, beat_treset;
int escala; //escala pot agafar el valor escala=1 (0-6); escala=2 (7-13); escala=3 (nota=14). L'escala inicial em vindrà donada per relative c', relative c o relative c''.
//c' equival al do central de baix (=0); c'' equival al do central de dalt (=7)
string car, car2;

int comptador_linies=1;
int num_pags;

//si no sé quina dimensió ha de tenir un array, he d'utilitzar vectors. Quan comencem a llegir el fitxer .ly no sabem quants staffs i pàgines hi haurà
//Vectors a C++
//http://www.cplusplus.com/reference/stl/vector/
//http://www.dreamincode.net/forums/showtopic33631.htm
vector<int> pag(0);
vector<int> temps_total_staff(0);

int nota_actual;

bool passada1a=true;
int temps_total, num_compassos;
int pixels_compas; //aquest valor queda definit després de la 1a passada
//24px és la durada del compàs. 24 px perquè són blanques, ritme 2/4. Per a un ritme 4/4 seran 48
//el 48 ve de què una rodona són 48 unitats de temps, i una semicorxea 3 u.d.t.	

//els valors parametritzables per a un disseny de music box són:
// notes[], factor_temps, pixels_nota, margin_left, margin_right, polifonia.
//els valors següents són els que hi ha per defecte i es corresponen al DIY Music Box de ThinkGeek (fabricant Kikkerland). Ara bé, puc tenir altres dissenys
//que introdueixo amb l'opció -d [-d kikkerland]
//per ajustar les mides del bitmap tinc dos factors: factor_temps representa la resolució vertical, el factor que es multiplica a la durada del compàs (48 per a 4/4); pixels_nota és la separació entre les notes successives.
char disseny[50];
char notes[]="cdefgabcdefgabc"; //0=c; 1=d; 2=e; 3=f; 4=g; 5=a; 6=b; 7=c; 8=d; 9=e; 10=f; 11=g; 12=a; 13=b; 14=c;
int polifonia=15; //número de notes al DIY MusicBox de thinkgeek.com (Kikkerland)
double factor_temps=4; //amb el factor_temps puc ajustar la resolució vertical, la longitud en pixels dels compassos
int pixels_nota=6;
int margin_left=19; //estableixo un marge. 19 és el marge que va bé per a DIY Music Box de ThinkGeek (Kikkerland)
int margin_right=19;

int compassos;
int amplada;

int number_staff;
int number_page=0;
int estem_en_staff_num;
int estem_en_pag_num;

string titol;

BMP Output;

int main (int argc, char* argv[])
{

	char DATE[] = "January";
	char YEAR[] = "2010";
	char AUTHOR[] = "Joan Quintana";
	char LICENSE[] = "GPL v. 2";
	char WEB[] = "joanqc@gmail.com - www.joanillo.org";

	bool help_mode = false;
	char input_filename[2049];
	char output_filename[2049]=""; //="output.bmp";
	char output_filename_base[2049]="";

	char linia[1000];
	string str;

	FILE *fp;

	// determinar tots els arguments
	int k=1;
	for( k=1 ; k < argc ; k++ )
	{
		if( *(argv[k]+0) == '-' )
		{ 
			if( *(argv[k]+1) == 'h' )
			{ help_mode = true; }
			if( *(argv[k]+1) == 'i' )
			{ strcpy( input_filename , argv[k+1]); }
			if( *(argv[k]+1) == 's' )
			{ number_staff=atoi(argv[k+1]); }
			if( *(argv[k]+1) == 'p' )
			{ number_page=atoi(argv[k+1]); }
			if( *(argv[k]+1) == 'o' )
			{ strcpy( output_filename_base , argv[k+1]); }
			if( *(argv[k]+1) == 'd' )
			{ strcpy( disseny , argv[k+1]); }
		}
	}

	// if the user asked for help or is confused, spit out help info
	if( argc == 1 || help_mode )
	{
	cout << "\nlilypond2musicbox v1_05: Lilypond file to punched card converter. \n\n"
		<< "\nlilypond2musicbox usage: \n\n"
		<< " This converts a lilypond file (music score format) to a printable bmp, intended for using it with the DIY Music Box that is sold on thinkgeek.com. \n"
		<< " The resulting image is the template for punching the card that will be used in your music box. This software is also usefull for other music boxes \n"
		<< " that use the same technique: punched cards that have the information of which notes are going to be played. \n\n" 
		<< "   lilypond2musicbox -i <input file> [-s staff_number] [-p pag_number] [-o <output bitmap>] \n\n"
		<< " in v1_05 a lilypond file coud be spanned in several images in order to be printed with the proper dimensions. \n"
		<< " ex: lilypond2musicbox -i song.ly -p 1 -o output1.bmp \n"
		<< " ex: lilypond2musicbox -i song.ly -p 2 -o output2.bmp \n"
		<< " if -p is not given, then it takes p=1\n"
		<< " if -o is not given, then it takes output1.bmp for p=1, output2.bmp for p=2,...\n\n"
		<< " This gives this help information:\n"
		<< "   lilypond2musicbox-h\n\n"
		<< " Created on " << DATE << ", " << YEAR << " by " << AUTHOR << ".\n"
		<< " Uses the EasyBMP library, Version " << _EasyBMP_Version_ << ".\n"
		<< " Licensed under " << LICENSE << " by " << AUTHOR << ".\n"
		<< " Copyright (c) " << YEAR << " " << AUTHOR << "\n"
		<< " Contact: " << WEB << "\n\n";
		return 1;
 	}

	// spit out copyright / license information
	cout  << "\n Created on " << DATE << ", " << YEAR << " by " << AUTHOR << ".\n"
	<< " Uses the EasyBMP library, Version " << _EasyBMP_Version_ << ".\n"
	<< " Licensed under " << LICENSE << " by " << AUTHOR << ".\n"
	<< " Copyright (c) " << YEAR << " " << AUTHOR << "\n"
	<< " Contact: " << WEB << "\n\n";

	if (strcmp(disseny,"kikkerland")==0) {
		strcpy(notes,"cdefgabcdefgabc"); //0=c; 1=d; 2=e; 3=f; 4=g; 5=a; 6=b; 7=c; 8=d; 9=e; 10=f; 11=g; 12=a; 13=b; 14=c;
		polifonia=15; //número de notes al DIY MusicBox de thinkgeek.com (Kikkerland)
		factor_temps=4; //amb el factor_temps puc ajustar la resolució vertical, la longitud en pixels dels compassos
		pixels_nota=6;
		margin_left=19; //estableixo un marge. 19 és el marge que va bé per a DIY Music Box de ThinkGeek (Kikkerland)
		margin_right=19;
	}
	else if (strcmp(disseny,"prova")==0) {
		strcpy(notes,"cdefgabcdefgabcdefga"); //0=c; 1=d; 2=e; 3=f; 4=g; 5=a; 6=b; 7=c; 8=d; 9=e; 10=f; 11=g; 12=a; 13=b; 14=c;
		polifonia=20; //número de notes al DIY MusicBox de thinkgeek.com (Kikkerland)
		factor_temps=8; //amb el factor_temps puc ajustar la resolució vertical, la longitud en pixels dels compassos
		pixels_nota=6;
		margin_left=9; //estableixo un marge. 19 és el marge que va bé per a DIY Music Box de ThinkGeek (Kikkerland)
		margin_right=9;
	}
	amplada=pixels_nota*(polifonia-1); //vull que les notes coincideixin amb les línies. Tinc 15 notes però 14 separacions

	//passada preliminar: per saber quantes pàgines hi ha a cada staff (tots els staffs han de tenir el mateix número de pàgines)
	fp=fopen(input_filename,"r");

	while(fgets(linia, 1000, fp)!=NULL) {
		str=linia;
		if (str.find("title")<10)  {
			titol = str.substr (str.find("title")+5);
			titol = titol.substr (titol.find("\"")+1);
			titol = titol.substr (0,titol.length()-2);
		}			
		
		if (str.find("%pag")==0 )  num_pags++;

		if (str.find("%staff")==0 ) {
			if (atoi(str.substr(str.find("%staff")+6,1).c_str())==2)  break;
		}

		if (str.find("\\score")==0) break;
	}
	fclose(fp);

	cout << "\n" << titol << "\n";
	cout << "=======================================\n";

	int init_page, final_page;
	if (number_page==0){
		init_page=1;
		final_page=num_pags+1;
	} else {
		init_page=number_page;
		final_page=number_page+1;
	}
	/** RECORREM TOTES LES PÀGINES (i obtenim tots els bitmaps), o si utilitzem l'opció -p només processem la pàgina escollida */
	for (number_page=init_page; number_page<final_page; number_page++) {
			//inicialitzem variables		
			estem_en_staff_num=0;
			estem_en_pag_num=0;
			compassos=0;
			temps_total=0;
			passada1a=true;
			comptador_linies=1;
			strcpy(output_filename,"");

		cout << "\nProcessing page #" << number_page << "\n";
		cout << "----------------------------------------\n\n";

		//1a passada: per saber quants compassos tinc i així dimensionar el bmp
		fp=fopen(input_filename,"r");

		while(fgets(linia, 1000, fp)!=NULL) {
			str=linia;
			processa_linia(str);
			if (str.find("\\score")==0) break;
		}
		fclose(fp);

		//cout << "=======================================\n";

		compassos=temps_total/pixels_compas;
		cout << "temps total: " << temps_total << "\n";
		cout << "num compassos: " << compassos << "\n";


		//comprovar que tots els staffs tenen el mateix temps_total. Això només té sentit si vull imprimir tots els staffs
		int temps_staffs_iguals=1;
		if (number_staff==0){
			for (int i=0; i < estem_en_staff_num-1; i++){
				//cout << "Temps total staff #" << i << ": " << temps_total_staff.at(i) << " \n";
				//cout << "Temps total staff #" << i+1 << ": " << temps_total_staff.at(i+1) << " \n";
				if (temps_total_staff.at(i)!=temps_total_staff.at(i+1)) temps_staffs_iguals=temps_staffs_iguals*0;
			}
			if (temps_staffs_iguals==0) cout << "\n**************************\nTEMPS STAFFS NO SON IGUALS!\na falta de millorar-ho, recordem que només hi pot haver un espai en blanc entre notes\n*************************\n\n";
		}


		Output.SetSize( margin_left+amplada+margin_right+1 , (int)(round(factor_temps*temps_total+0.49))+1 );
		//Output.SetBitDepth( 16 ); //abans funcionava i amb la nova versió ha deixat de funcionar. Per què?

		//cout << "factor temps: " << factor_temps << "\n";
		//cout << "pixels_nota: " << pixels_nota << "\n";	cout << "pixels_nota: " << pixels_nota << "\n";
		//cout << "amplada: " << amplada << "\n";
		//cout << "margin_right: " << margin_right << "\n";
		//cout << "margin_left: " << margin_left << "\n";

		//divisòria de notes
		//marge esquerre
		for (int j=0;j<(int)(round(factor_temps*temps_total+0.49))+1;j++){
			Output(0,j)->Red=200;
			Output(0,j)->Green=200;
			Output(0,j)->Blue=200;
		}
		for (int i=0;i<amplada+1;i+=pixels_nota){
			for (int j=0;j<(int)(round(factor_temps*temps_total+0.49))+1;j++){
				Output(margin_left+i,j)->Red=200;comptador_linies=1;
				Output(margin_left+i,j)->Green=200;
				Output(margin_left+i,j)->Blue=200;
			}
		}
		//marge dret
		for (int j=0;j<(int)(round(factor_temps*temps_total+0.49))+1;j++){
			Output(margin_left+amplada+margin_right,j)->Red=200;
			Output(margin_left+amplada+margin_right,j)->Green=200;
			Output(margin_left+amplada+margin_right,j)->Blue=200;
		}

		//divisòria de compassos
		for (int i=0;i<=compassos;i++){
			for (int j=0;j<amplada+1;j++){
				Output(margin_left+j,(int)(round(factor_temps*pixels_compas*i+0.49)))->Red=200;
				Output(margin_left+j,(int)(round(factor_temps*pixels_compas*i+0.49)))->Green=200;
				Output(margin_left+j,(int)(round(factor_temps*pixels_compas*i+0.49)))->Blue=200;
			}
		}

		//2a passada
		//la 1a passada ha servit per dimensionar la imatge i imprimir la plantilla. Amb la segona passada imprimiré les notes
		passada1a=false;
		comptador_linies=1;

		fp=fopen(input_filename,"r");

		while(fgets(linia, 1000, fp)!=NULL) {
			str=linia;
			processa_linia(str);
			if (str.find("\\score")==0) break;
		}
		fclose(fp);

		//rescale to 42% of original size. D'aquesta manera aconseguim ajustar-ho al tamany necessari
		//Rescale( Output , 'p', 42 );
		//rescale (preserving aspect ratio) to width 100 pixels
		//Rescale( Output , 'W', 100 );
		//rescale (preserving aspect ratio) to height 100
		//Rescale( Output , 'H', 300 );
		//rescale (preserving aspect ratio) to fit in a 100 x 100 box
		//Rescale( Output , 'f', 300 );

		//grabem el bmp
		//convertim number_page a char. Sembla mentida lo difícil que és fer-ho amb C! atoi està implementat a <string>, però no itoa. Per tant, es programa específicament
		char *p = NULL;
		p = my_itoa(number_page);
		if(!p) free(p);
		if (strlen(output_filename_base) == 0) {
			strcat(strcat(strcat(output_filename,"output"),p),".bmp");
		} else {
			strcat(output_filename,output_filename_base);
			strcat(strcat(output_filename,p),".bmp");
		}
		Output.WriteToFile( output_filename );
		cout << "\n" << output_filename << " file saved\n";
	}
	cout << "\n";
	return 0;
}

void processa_linia(string str){

	if (str.find("\\relative c'''")==0)  {
		escala=3;
	} else if (str.find("\\relative c''")==0)  {
		escala=2;
	} else if (str.find("\\relative c'")==0)  {
		escala=1;
	}

	if (str.find("time")<10)  {
		str = str.substr (str.find("time")+5);
		str = str.substr (0,3);
		if (str=="4/4") {
			pixels_compas=48;
		}
		else if (str=="3/4") {
			pixels_compas=36;
		}
		else if (str=="2/4") {
			pixels_compas=24;
		}
	}

	if (str.find("%staff")==0 )  {
		estem_en_staff_num=atoi(str.substr(str.find("%staff")+6,1).c_str());
		estem_en_pag_num=0;
		if ((number_staff == 0) || (estem_en_staff_num == number_staff)) {
			if (passada1a==false) cout << "\nProcessing staff #" << estem_en_staff_num << "\n";
			nota_actual=-1;
		}
	}

	if (str.find("%pag")==0 )  {
		estem_en_pag_num=atoi(str.substr(str.find("%pag")+4,1).c_str());

		//sempre s'ha de processar totes les pàgines
		//només s'ha de processar el staff demanat. Si number_staff==0, processar tots els staffs		
		if ((number_staff==0) || (estem_en_staff_num==number_staff)){
			pag.resize((estem_en_staff_num-1)*num_pags + estem_en_pag_num);
			pag.at((estem_en_staff_num-1)*num_pags + estem_en_pag_num-1)=comptador_linies+1;

			if (passada1a==false) cout << "Processing page #" << estem_en_pag_num << "\n";
			//cout << "number staff:" << number_staff << " number_page: " << number_page << " estem_en_staff_num: " << estem_en_staff_num << " estem_en_pag_num: " << estem_en_pag_num <<"\n";
			//cout << "pag: #" << estem_en_pag_num << " " << comptador_linies+1 << "\n";

			//avariguar la 1a nota del staff
			if (nota_actual==-1 & escala==1){
				nota_actual=0;
			} 
			else if (nota_actual==-1 & escala==2){
				nota_actual=7;
			} 	
			else if (nota_actual==-1 & escala==3){
				nota_actual=14;
			} 

		}

	}

	//només s'ha de processar el staff demanat. Si number_staff==0, processar tots els staffs		
	if ((number_staff==0) || (estem_en_staff_num==number_staff)){
		if (estem_en_pag_num > 0) {	
			if (comptador_linies==pag.at((estem_en_staff_num-1)*num_pags + estem_en_pag_num-1)) {
				if (estem_en_pag_num==number_page) temps_total=0;		
				processa_pag(str); //s'ha de processar totes les pàgines, encara que no sigui la pàgina sol.licitada, perquè utilitzo relative de forma obligada
				if (estem_en_pag_num==number_page) { //la única cosa que comprovem és que, per a una pàgina concreta, aquesta pàgina per als diferents staffs té el mateix temps_total. 
					if (passada1a==true) temps_total_staff.resize(estem_en_staff_num);
					temps_total_staff.at(estem_en_staff_num-1)=temps_total;
					//cout << "Temps Staff: " << estem_en_staff_num << ", Pag: " << estem_en_pag_num << ": " << temps_total_staff.at(estem_en_staff_num-1) << "\n\n";
				}
			}
		}
	}

	comptador_linies++;

}


void processa_pag(string str){

	string str2;
	string treset;
	size_t postreset1;
	size_t postreset2;

	for(int i=0;i<=str.length();i++) {
	
	car = str.substr (i,1);
	car2 = str.substr (i,2);

	if (i < str.length()-9) { //això segurament es pot millorar, però compte que la cadena no pot ser menor que 9
		treset = str.substr (i+1,9);
	} else {
		treset="";
	}


	if (car==" "){
		if ((passada1a==false) & (number_page==estem_en_pag_num)) cout << nota << nota_actual << "_" << beat << " ";
		imprimir_nota(nota, nota_actual, beat, estem_en_staff_num, estem_en_pag_num);
	}
	else if (car=="\\") {
		str2 = str.substr (i);

		//hem trobat un caràcter especial, cerquem un treset		
		postreset1 = str2.find("times 2/3 {");	
		if (postreset1==1) { //tenim un treset
  			postreset1 = str2.find("{");
  			postreset2 = str2.find("}");
			//printf("%i  %i\n",pos1,pos2);
	  		str2 = str2.substr (postreset1+1,postreset2-postreset1-1);
			processa_treset(str2);
			i=i+sizeof("times 2/3 {")+postreset2-postreset1; //avancem tots els espais que ocupa el treset
		}
	}

	else if (car=="r"){ //silenci
		nota=car.at(0);
	}
	else if (car=="c" and (nota_actual<=3)){
		nota=car.at(0);
		if (car2=="c'") {
			nota_actual=7;
		} else if (car2=="c,") {
			nota_actual=0;
		} else {
			nota_actual=0;
		}		
	}
	else if (car=="d" and (nota_actual>=0 and nota_actual<=4)){
		nota=car.at(0);
		if (car2=="d'") {
			nota_actual=8;
		} else if (car2=="d,") {
			nota_actual=1;
		} else {
			nota_actual=1;
		}	
	}
	else if (car=="e" and (nota_actual>=0 and nota_actual<=5)){
		nota=car.at(0);
		if (car2=="e'") {
			nota_actual=9;
		} else if (car2=="e,") {
			nota_actual=2;
		} else {
			nota_actual=2;
		}		
	}
	else if (car=="f" and (nota_actual>=0 and nota_actual<=6)){
		nota=car.at(0);
		if (car2=="f'") {
			nota_actual=10;
		} else if (car2=="f,") {
			nota_actual=3;
		} else {
			nota_actual=3;
		}		
	}
	else if (car=="g" and (nota_actual>=1 and nota_actual<=7)){
		nota=car.at(0);
		if (car2=="g'") {
			nota_actual=11;
		} else if (car2=="g,") {
			nota_actual=4;
		} else {
			nota_actual=4;
		}	
	}
	else if (car=="a" and (nota_actual>=2 and nota_actual<=8)){
		nota=car.at(0);
		if (car2=="a'") {
			nota_actual=12;
		} else if (car2=="a,") {
			nota_actual=5;
		} else {
			nota_actual=5;
		}		
	}
	else if (car=="b" and (nota_actual>=3 and nota_actual<=9)){
		nota=car.at(0);
		if (car2=="b'") {
			nota_actual=13;
		} else if (car2=="b,") {
			nota_actual=6;
		} else {
			nota_actual=6;
		}		
	}
	else if (car=="c" and (nota_actual>=4 and nota_actual<=10)){
		nota=car.at(0);
		if (car2=="c'") {
			nota_actual=14;
		} else if (car2=="c,") {
			nota_actual=0;
		} else {
			nota_actual=7;
		}		
	}
	else if (car=="d" and (nota_actual>=5 and nota_actual<=11)){
		nota=car.at(0);
		if (car2=="d'") {
			nota_actual=8;
		} else if (car2=="d,") {
			nota_actual=1;
		} else {
			nota_actual=8;
		}		
	}
	else if (car=="e" and (nota_actual>=6 and nota_actual<=12)){
		nota=car.at(0);
		if (car2=="e'") {
			nota_actual=9;
		} else if (car2=="e,") {
			nota_actual=2;
		} else {
			nota_actual=9;
		}		
	}
	else if (car=="f" and (nota_actual>=7 and nota_actual<=13)){
		nota=car.at(0);
		if (car2=="f'") {
			nota_actual=10;
		} else if (car2=="f,") {
			nota_actual=3;
		} else {
			nota_actual=10;
		}			
	}
	else if (car=="g" and (nota_actual>=8 and nota_actual<=14)){
		nota=car.at(0);
		if (car2=="g'") {
			nota_actual=11;
		} else if (car2=="g,") {
			nota_actual=4;
		} else {
			nota_actual=11;
		}			
	}
	else if (car=="a" and (nota_actual>=9 and nota_actual<=14)){
		nota=car.at(0);
		if (car2=="a'") {
			nota_actual=12;
		} else if (car2=="a,") {
			nota_actual=5;
		} else {
			nota_actual=12;
		}		
	}
	else if (car=="b" and (nota_actual>=10 and nota_actual<=14)){
		nota=car.at(0);
		if (car2=="b'") {
			nota_actual=13;
		} else if (car2=="b,") {
			nota_actual=6;
		} else {
			nota_actual=13;
		}	
	}
	else if (car=="c" and (nota_actual>=11)){
		nota=car.at(0);
		if (car2=="c'") {
			nota_actual=14;
		} else if (car2=="c,") {
			nota_actual=7;
		} else {
			nota_actual=14;
		}			
	}
	else if (car2=="2.") {
			beat="36";
	}
	else if (car2=="4.") {
			beat="18";
	}
	else if (car2=="8.") {
			beat="9";
	}
	else if (car2=="16") {
			beat="3";
	}
	else if (car=="8") {
			beat="6";
	}
	else if (car=="4") {
			beat="12";
	}
	else if (car=="2") {
			beat="24";
	}
	else if (car=="1") {
			beat="48";
	}

	}

	if ((passada1a==false) & (number_page==estem_en_pag_num)) cout << nota << nota_actual << "_" << beat << " " << "\n";
	imprimir_nota(nota, nota_actual, beat, estem_en_staff_num, estem_en_pag_num);

}

void processa_treset(string cad){
	if (passada1a==false) cout << "\ntreset:\t";
	cad=trim(cad);
	for(int j=0;j<=cad.length();j++) {
		car = cad.substr (j,1);
		if (car==" "){
			if ((passada1a==false) & (number_page==estem_en_pag_num)) cout << nota << nota_actual << "_" << beat << " ";
			imprimir_nota(nota, nota_actual, beat_treset, estem_en_staff_num, estem_en_pag_num);
		}
		else if (car=="r"){ //silenci
			nota=car.at(0);
		}
		else if (car=="c" and (nota_actual<=3)){
			nota=car.at(0);
			if (car2=="c'") {
				nota_actual=7;
			} else if (car2=="c,") {
				nota_actual=0;
			} else {
				nota_actual=0;
			}		
		}
		else if (car=="d" and (nota_actual>=0 and nota_actual<=4)){
			nota=car.at(0);
			if (car2=="d'") {
				nota_actual=8;
			} else if (car2=="d,") {
				nota_actual=1;
			} else {
				nota_actual=1;
			}	
		}
		else if (car=="e" and (nota_actual>=0 and nota_actual<=5)){
			nota=car.at(0);
			if (car2=="e'") {
				nota_actual=9;
			} else if (car2=="e,") {
				nota_actual=2;
			} else {
				nota_actual=2;
			}		
		}
		else if (car=="f" and (nota_actual>=0 and nota_actual<=6)){
			nota=car.at(0);
			if (car2=="f'") {
				nota_actual=10;
			} else if (car2=="f,") {
				nota_actual=3;
			} else {
				nota_actual=3;
			}		
		}
		else if (car=="g" and (nota_actual>=1 and nota_actual<=7)){
			nota=car.at(0);
			if (car2=="g'") {
				nota_actual=11;
			} else if (car2=="g,") {
				nota_actual=4;
			} else {
				nota_actual=4;
			}	
		}
		else if (car=="a" and (nota_actual>=2 and nota_actual<=8)){
			nota=car.at(0);
			if (car2=="a'") {
				nota_actual=12;
			} else if (car2=="a,") {
				nota_actual=5;
			} else {
				nota_actual=5;
			}		
		}
		else if (car=="b" and (nota_actual>=3 and nota_actual<=9)){
			nota=car.at(0);
			if (car2=="b'") {
				nota_actual=13;
			} else if (car2=="b,") {
				nota_actual=6;
			} else {
				nota_actual=6;
			}		
		}
		else if (car=="c" and (nota_actual>=4 and nota_actual<=10)){
			nota=car.at(0);
			if (car2=="c'") {
				nota_actual=14;
			} else if (car2=="c,") {
				nota_actual=0;
			} else {
				nota_actual=7;
			}		
		}
		else if (car=="d" and (nota_actual>=5 and nota_actual<=11)){
			nota=car.at(0);
			if (car2=="d'") {
				nota_actual=8;
			} else if (car2=="d,") {
				nota_actual=1;
			} else {
				nota_actual=8;
			}		
		}
		else if (car=="e" and (nota_actual>=6 and nota_actual<=12)){
			nota=car.at(0);
			if (car2=="e'") {
				nota_actual=9;
			} else if (car2=="e,") {
				nota_actual=2;
			} else {
				nota_actual=9;
			}		
		}
		else if (car=="f" and (nota_actual>=7 and nota_actual<=13)){
			nota=car.at(0);
			if (car2=="f'") {
				nota_actual=10;
			} else if (car2=="f,") {
				nota_actual=3;
			} else {
				nota_actual=10;
			}			
		}
		else if (car=="g" and (nota_actual>=8 and nota_actual<=14)){
			nota=car.at(0);
			if (car2=="g'") {
				nota_actual=11;
			} else if (car2=="g,") {
				nota_actual=4;
			} else {
				nota_actual=11;
			}			
		}
		else if (car=="a" and (nota_actual>=9 and nota_actual<=14)){
			nota=car.at(0);
			if (car2=="a'") {
				nota_actual=12;
			} else if (car2=="a,") {
				nota_actual=5;
			} else {
				nota_actual=12;
			}		
		}
		else if (car=="b" and (nota_actual>=10 and nota_actual<=14)){
			nota=car.at(0);
			if (car2=="b'") {
				nota_actual=13;
			} else if (car2=="b,") {
				nota_actual=6;
			} else {
				nota_actual=13;
			}	
		}
		else if (car=="c" and (nota_actual>=11)){
			nota=car.at(0);
			if (car2=="c'") {
				nota_actual=14;
			} else if (car2=="c,") {
				nota_actual=7;
			} else {
				nota_actual=14;
			}			
		}
		else if (car=="8") { //treset de corxees
				beat="6";
				beat_treset="4";
		}
		else if (car=="4") { //treset de negres
				beat="12";
				beat_treset="8";
		}
	}
	if ((passada1a==false) & (number_page==estem_en_pag_num)) cout << nota << nota_actual << "_" << beat << " " << "\n";
	imprimir_nota(nota, nota_actual, beat_treset, estem_en_staff_num, estem_en_pag_num);

}


string trim(string s)
{
	int pos;
	pos = s.find(" ");
	if (pos==0) s = s.substr (1); //eliminem un espai blanc al principi

	pos = s.rfind(" ");
	if (s.length()==pos+1) s = s.substr (0,s.length()-1); //eliminem un espai blanc al final, si existeix
	return s;
}

void imprimir_nota(string nota, int nota_num, string durada, int estem_en_staff_num, int estem_en_pag_num)
{

	char ctemps[2];
	char notachar;
	int temps;
	int posicio_nota;

	if (number_page==estem_en_pag_num) {

		notachar=nota.at(0);

		if (durada.length()==1) {
			ctemps[0]=durada.at(0);
		}
		else if (durada.length()==2){
			ctemps[0]=durada.at(0);
			ctemps[1]=durada.at(1);
		} 

		temps=atoi(ctemps);

		if (passada1a==false) {
		if (notachar!='r'){ //els silencis no s'imprimeixen
			posicio_nota=nota_num*pixels_nota;

			Output(margin_left+posicio_nota,(int)(round(factor_temps*temps_total+0.49)))->Red=0;
			Output(margin_left+posicio_nota,(int)(round(factor_temps*temps_total+0.49)))->Green=0;
			Output(margin_left+posicio_nota,(int)(round(factor_temps*temps_total+0.49)))->Blue=0;

			//Output(margin_left+posicio_nota+1,(int)(round(factor_temps*temps_total+0.49)))->Red=0;
			//Output(margin_left+posicio_nota+1,(int)(round(factor_temps*temps_total+0.49)))->Green=0;
			//Output(margin_left+posicio_nota+1,(int)(round(factor_temps*temps_total+0.49)))->Blue=0;

			Output(margin_left+posicio_nota,(int)(round(factor_temps*temps_total+0.49))+1)->Red=0;
			Output(margin_left+posicio_nota,(int)(round(factor_temps*temps_total+0.49))+1)->Green=0;
			Output(margin_left+posicio_nota,(int)(round(factor_temps*temps_total+0.49))+1)->Blue=0;

			//Output(margin_left+posicio_nota+1,(int)(round(factor_temps*temps_total+0.49))+1)->Red=0;
			//Output(margin_left+posicio_nota+1,(int)(round(factor_temps*temps_total+0.49))+1)->Green=0;
			//Output(margin_left+posicio_nota+1,(int)(round(factor_temps*temps_total+0.49))+1)->Blue=0;

		}
		}

		temps_total=temps_total+temps;

		//cout << temps << " " << temps_total<< "\n";
	}
}



