// compilar: $ gimptool-2.0 --install gimp_pintar_ratlla_v4.c
// per executar-lo des de la consola
//$ python servertest_v2.py localhost 10008 "(plug-in-pintar-ratlla4 RUN-NONINTERACTIVE 1 2 \"50,50,300,8\" \"Circle (01),ffaaff\")"

//

//v2: afegeixo un altre paràmetre
//v3: el paràmetre que afegeixo (que és un string) en faig un split i els passo a números
//els paràmetres que passo són els valors per representar un pentagrama: a,b,c,d,e: 
//(a,b): coordenades d'on comença el pentagrama
//c: longitud
//d: separació
//v4: agrupo els paràmetres que passo en dos números: uns numèrics, d'altres tipus string

#include <libgimp/gimp.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

char** str_split( char*, char, int* );
GimpRGB convertir_color (char *);

static void query (void);
static void run   (const gchar      *name,
                   gint              nparams,
                   const GimpParam  *param,
                   gint             *nreturn_vals,
                   GimpParam       **return_vals);

static void pintar_ratlla  (GimpDrawable *drawable, int *, char **);


GimpPlugInInfo PLUG_IN_INFO =
{
  NULL,
  NULL,
  query,
  run
};

MAIN()

static void
query (void)
{
  static GimpParamDef args[] =
  {
    {
      GIMP_PDB_INT32,
      "run-mode",
      "Run mode"
    },
    {
      GIMP_PDB_IMAGE,
      "image",
      "Input image"
    },
    {
      GIMP_PDB_DRAWABLE,
      "drawable",
      "Input drawable"
    },
    {
      GIMP_PDB_STRING,
      "argus1",
      "Arguments1"
    },
    {
      GIMP_PDB_STRING,
      "argus2",
      "Arguments2"
    }
  };

  gimp_install_procedure (
    "plug-in-pintar-ratlla4",
    "PintarRatlla4",
    "Pinta una ratlla amb el pinzell",
    "Joan Quintana (joanillo)",
    "Copyright Joan Quintana",
    "2012",
    "_Pintar Ratlla 4",
    "RGB*, GRAY*",
    GIMP_PLUGIN,
    G_N_ELEMENTS (args), 0,
    args, NULL);

  gimp_plugin_menu_register ("plug-in-pintar-ratlla4",
                             "<Image>/Filters/Blur");
}

static void
run (const gchar      *name,
     gint              nparams,
     const GimpParam  *param,
     gint             *nreturn_vals,
     GimpParam       **return_vals)
{
  static GimpParam  values[1];
  GimpPDBStatusType status = GIMP_PDB_SUCCESS;
  GimpRunMode       run_mode;
  GimpDrawable     *drawable;

	char *argus1; //representa la cadena d'arguments que seran números
	char *argus2; //representa la cadena d'arguments que seran strings

  /* Setting mandatory output values */
  *nreturn_vals = 1;
  *return_vals  = values;

  values[0].type = GIMP_PDB_STATUS;
  values[0].data.d_status = status;

  /* Getting run_mode - we won't display a dialog if
   * we are in NONINTERACTIVE mode
   */
  run_mode = param[0].data.d_int32;

  /*  Get the specified drawable  */
  drawable = gimp_drawable_get (param[2].data.d_drawable);

	argus1 = param[3].data.d_string;
	argus2 = param[4].data.d_string;
	//g_message ("%s %s",argus1, argus2);

	//anem ara a fer un split de tots els valors que hi ha a argus1 i argus2
    char* strCpy;
    char** split;
    int num;
    int i;
	 int intargs[num]; //aquí residiran els arguments, però ara ja numèrics
	 char *strargs[num]; //aquí residiran el segon grup d'arguments que són string

    strCpy = malloc( strlen( argus1 ) * sizeof( *strCpy ) );
    strcpy( strCpy, argus1 );

    split = str_split( strCpy, ',', &num ); //sé quants arguments hi ha

    if ( split == NULL )
    {
        puts( "str_split returned NULL" );
    }
    else
    {
        for ( i = 0; i < num; i++ )
        {
				intargs[i] = atoi(split[i]);
        }
    }

    free( split );
    free( strCpy );
	 i = 0;
	 num = 0;
    strCpy = malloc( strlen( argus2 ) * sizeof( *strCpy ) );
    strcpy( strCpy, argus2 );

    split = str_split( strCpy, ',', &num ); //sé quants arguments hi ha

    if ( split == NULL )
    {
        puts( "str_split returned NULL" );
    }
    else
    {
        for ( i = 0; i < num; i++ )
        {
				strargs[i] = split[i];
        }
    }
    //g_message ("%s",strargs[0]);

    //free( split ); //no puc fer free de split!!!, perquè strargs[i] = split[i]...
    //free( strCpy );

// -------------

  gimp_progress_init ("Pintant una ratlla...");

  pintar_ratlla (drawable, intargs, strargs);

  gimp_displays_flush ();
  gimp_drawable_detach (drawable);

  return;
}

static void
pintar_ratlla (GimpDrawable *drawable, int *argus1, char **argus2)
{
	gint x1, y1, longitud, separacio;
	gchar *nom_brush, *color_linia;
	//gchar *name_nou;
	//gint width, height;
	//gint mask_bpp;
	//gint color_bpp;

	x1=argus1[0];
	y1=argus1[1];
	longitud=argus1[2];
	separacio=argus1[3];
	nom_brush=argus2[0];
	color_linia=argus2[1];
	GimpRGB color;


	//Per duplicar un pinzell:
	//name_nou = gimp_brush_duplicate ("Circle (11)"); //Còpia de Circle (11)
	//g_message ("%s",name_nou);

	//gimp_brush_get_info ("Circle (11)", &width, &height, &mask_bpp, &color_bpp); //obtinc informació d'aquest pinzell
	//g_message ("%d",width);

	//anem a fer un pentagrama

	//canvi de pinzell
	gimp_brushes_set_brush (nom_brush);
	
	//canvi de color
	//gimp_rgb_set (&color, 0.0, 1.0, 1.0);
	color = convertir_color(color_linia);
	gimp_context_set_foreground (&color); 

	gdouble linia_pentagrama[5][4]= {{x1,y1,x1+longitud,y1},{x1,y1+separacio,x1+longitud,y1+separacio*1},{x1,y1+separacio*2,x1+longitud,y1+separacio*2},{x1,y1+separacio*3,x1+longitud,y1+separacio*3},{x1,y1+separacio*4,x1+longitud,y1+separacio*4}};
	gimp_paintbrush_default(drawable->drawable_id,4,linia_pentagrama[0]);
	gimp_paintbrush_default(drawable->drawable_id,4,linia_pentagrama[1]);
	gimp_paintbrush_default(drawable->drawable_id,4,linia_pentagrama[2]);
	gimp_paintbrush_default(drawable->drawable_id,4,linia_pentagrama[3]);
	gimp_paintbrush_default(drawable->drawable_id,4,linia_pentagrama[4]);

	gimp_drawable_flush (drawable);
	gimp_drawable_merge_shadow (drawable->drawable_id, TRUE);
	gimp_drawable_update (drawable->drawable_id,0,0,longitud+x1,separacio*5+y1);

	//canvi a color estàndar
	gimp_rgb_set (&color, 0.0, 0.0, 0.0);
	gimp_context_set_foreground (&color); 
}

char** str_split( char* str, char delim, int* numSplits )
{
    char** ret;
    int retLen;
    char* c;

    if ( ( str == NULL ) ||
        ( delim == '\0' ) )
    {
        /* Either of those will cause problems */
        ret = NULL;
        retLen = -1;
    }
    else
    {
        retLen = 0;
        c = str;

        /* Pre-calculate number of elements */
        do
        {
            if ( *c == delim )
            {
                retLen++;
            }

            c++;
        } while ( *c != '\0' );

        ret = malloc( ( retLen + 1 ) * sizeof( *ret ) );
        ret[retLen] = NULL;

        c = str;
        retLen = 1;
        ret[0] = str;

        do
        {
            if ( *c == delim )
            {
                ret[retLen++] = &c[1];
                *c = '\0';
            }

            c++;
        } while ( *c != '\0' );
    }

    if ( numSplits != NULL )
    {
        *numSplits = retLen;
    }

    return ret;
}

GimpRGB convertir_color (char *strcolor) {
	GimpRGB color;

	char hexbyte[3] = {0} ;
	int octets[3] ;
	float components_color[3] ;

	int d;
	for( d = 0; d < 6; d += 2 )
	{
		// Assemble a digit pair into the hexbyte string
		hexbyte[0] = strcolor[d] ;
		hexbyte[1] = strcolor[d+1] ;

		// Convert the hex pair to an integer
		sscanf( hexbyte, "%X", &octets[d/2] ) ;
		components_color[d/2] = octets[d/2] / 255.0;
	}
	gimp_rgb_set (&color, components_color[0], components_color[1], components_color[2]);

	return color;
}

