// compilar: $ gimptool-2.0 --install gimp_pintar_ratlla_v3.c
// per executar-lo des de la consola
//$ python servertest_v2.py localhost 10008 "(plug-in-pintar-ratlla3 RUN-NONINTERACTIVE 1 2 \"50,50,300,8\")"

//

//v2: afegeixo un altre paràmetre
//v3: el paràmetre que afegeixo (que és un string) en faig un split i els passo a números
//els paràmetres que passo són els valors per representar un pentagrama: a,b,c,d,e: 
//(a,b): coordenades d'on comença el pentagrama
//c: longitud
//d: separació
#include <libgimp/gimp.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

char** str_split( char*, char, int* );

static void query (void);
static void run   (const gchar      *name,
                   gint              nparams,
                   const GimpParam  *param,
                   gint             *nreturn_vals,
                   GimpParam       **return_vals);

static void pintar_ratlla  (GimpDrawable *drawable, int *);

GimpPlugInInfo PLUG_IN_INFO =
{
  NULL,
  NULL,
  query,
  run
};

MAIN()

static void
query (void)
{
  static GimpParamDef args[] =
  {
    {
      GIMP_PDB_INT32,
      "run-mode",
      "Run mode"
    },
    {
      GIMP_PDB_IMAGE,
      "image",
      "Input image"
    },
    {
      GIMP_PDB_DRAWABLE,
      "drawable",
      "Input drawable"
    },
    {
      GIMP_PDB_STRING,
      "argus",
      "Arguments"
    }
  };

  gimp_install_procedure (
    "plug-in-pintar-ratlla3",
    "PintarRatlla3",
    "Pinta una ratlla amb el pinzell",
    "Joan Quintana (joanillo)",
    "Copyright Joan Quintana",
    "2012",
    "_Pintar Ratlla 3",
    "RGB*, GRAY*",
    GIMP_PLUGIN,
    G_N_ELEMENTS (args), 0,
    args, NULL);

  gimp_plugin_menu_register ("plug-in-pintar-ratlla3",
                             "<Image>/Filters/Blur");
}

static void
run (const gchar      *name,
     gint              nparams,
     const GimpParam  *param,
     gint             *nreturn_vals,
     GimpParam       **return_vals)
{
  static GimpParam  values[1];
  GimpPDBStatusType status = GIMP_PDB_SUCCESS;
  GimpRunMode       run_mode;
  GimpDrawable     *drawable;

	char *argus; //representa la cadena d'arguments

  /* Setting mandatory output values */
  *nreturn_vals = 1;
  *return_vals  = values;

  values[0].type = GIMP_PDB_STATUS;
  values[0].data.d_status = status;

  /* Getting run_mode - we won't display a dialog if
   * we are in NONINTERACTIVE mode
   */
  run_mode = param[0].data.d_int32;

  /*  Get the specified drawable  */
  drawable = gimp_drawable_get (param[2].data.d_drawable);

  argus = param[3].data.d_string;
g_message ("%s",argus);

//anem ara a fer un split de tots els valors que hi ha a argus
    char* strCpy;
    char** split;
    int num;
    int i;
	 int intargs[num]; //aquí residiran els arguments, però ara ja numèrics

    strCpy = malloc( strlen( argus ) * sizeof( *strCpy ) );
    strcpy( strCpy, argus );

    split = str_split( strCpy, ',', &num ); //sé quants arguments hi ha

    if ( split == NULL )
    {
        puts( "str_split returned NULL" );
    }
    else
    {
        for ( i = 0; i < num; i++ )
        {
				intargs[i] = atoi(split[i]);
        }
    }

    free( split );
    free( strCpy );
// -------------

  gimp_progress_init ("Pintant una ratlla...");
	
  pintar_ratlla (drawable, intargs);

  gimp_displays_flush ();
  gimp_drawable_detach (drawable);

  return;
}

static void
pintar_ratlla (GimpDrawable *drawable, int *argus)
{
	gint x1, y1, longitud, separacio;
	gchar *name_nou;
	gint width, height;
	gint mask_bpp;
	gint color_bpp;

	x1=argus[0];
	y1=argus[1];
	longitud=argus[2];
	separacio=argus[3];

	//Per duplicar un pinzell:
	//name_nou = gimp_brush_duplicate ("Circle (11)"); //Còpia de Circle (11)
	//g_message ("%s",name_nou);

	gimp_brush_get_info ("Circle (11)", &width, &height, &mask_bpp, &color_bpp); //obtinc informació d'aquest pinzell
	//g_message ("%d",width);

	//anem a fer un pentagrama
	gimp_brushes_set_brush ("Calligraphic Brush#3"); //escullo aquest pinzell
	gdouble linia_pentagrama[5][4]= {{x1,y1,x1+longitud,y1},{x1,y1+separacio,x1+longitud,y1+separacio*1},{x1,y1+separacio*2,x1+longitud,y1+separacio*2},{x1,y1+separacio*3,x1+longitud,y1+separacio*3},{x1,y1+separacio*4,x1+longitud,y1+separacio*4}};
	gimp_paintbrush_default(drawable->drawable_id,4,linia_pentagrama[0]);
	gimp_paintbrush_default(drawable->drawable_id,4,linia_pentagrama[1]);
	gimp_paintbrush_default(drawable->drawable_id,4,linia_pentagrama[2]);
	gimp_paintbrush_default(drawable->drawable_id,4,linia_pentagrama[3]);
	gimp_paintbrush_default(drawable->drawable_id,4,linia_pentagrama[4]);

	gimp_drawable_flush (drawable);
	gimp_drawable_merge_shadow (drawable->drawable_id, TRUE);
	gimp_drawable_update (drawable->drawable_id,0,0,100,100);

}

char** str_split( char* str, char delim, int* numSplits )
{
    char** ret;
    int retLen;
    char* c;

    if ( ( str == NULL ) ||
        ( delim == '\0' ) )
    {
        /* Either of those will cause problems */
        ret = NULL;
        retLen = -1;
    }
    else
    {
        retLen = 0;
        c = str;

        /* Pre-calculate number of elements */
        do
        {
            if ( *c == delim )
            {
                retLen++;
            }

            c++;
        } while ( *c != '\0' );

        ret = malloc( ( retLen + 1 ) * sizeof( *ret ) );
        ret[retLen] = NULL;

        c = str;
        retLen = 1;
        ret[0] = str;

        do
        {
            if ( *c == delim )
            {
                ret[retLen++] = &c[1];
                *c = '\0';
            }

            c++;
        } while ( *c != '\0' );
    }

    if ( numSplits != NULL )
    {
        *numSplits = retLen;
    }

    return ret;
}
