#include "mycpu.h"

static void
cb_changed( GtkRange  *range,
            GtkWidget *cpu )
{
    my_cpu_set_percent( MY_CPU( cpu ), gtk_range_get_value( range ) );
}

int
main( int    argc,
      char **argv )
{
    GtkWidget *window,
              *hbox,
              *cpu,
              *scale;

    gtk_init( &argc, &argv );

    window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
    g_signal_connect( window, "destroy", G_CALLBACK( gtk_main_quit ), NULL );

    hbox = gtk_hbox_new( FALSE, 5 );
    gtk_container_add( GTK_CONTAINER( window ), hbox );

    cpu = my_cpu_new();
    gtk_box_pack_start( GTK_BOX( hbox ), cpu, FALSE, FALSE, 0 );

    scale = gtk_vscale_new_with_range( 0, 1, 0.05 );
    gtk_scale_set_draw_value( GTK_SCALE( scale ), FALSE );
    gtk_range_set_inverted( GTK_RANGE( scale ), TRUE );
    g_signal_connect( scale, "value-changed", G_CALLBACK( cb_changed ), cpu );
    gtk_box_pack_start( GTK_BOX( hbox ), scale, FALSE, FALSE, 0 );

    gtk_widget_show_all( window );

    gtk_main();

    return( 0 );
}
