var map;
var tipusMapa;

var vectorLayerIcones = [];

//https://stackoverflow.com/questions/27658280/layer-switching-in-openlayers-3
var layersToner = new ol.layer.Group({
	layers: [
		new ol.layer.Tile({
			source: new ol.source.Stamen({
				layer: 'toner'
			})
		})
	]
});



function setMapType(newType, filt) {

	tipusMapa = newType;
	map.setLayerGroup(layersToner);


	//finalment, aquesta Ã©s la lÃ­nia per eliminar tota la capa d'icones
	//sempre que cridem setMapType ja havÃ­em pintat les icones, i per tant, aquÃ­ Ã©s un bon lloc per fer-ho
	//aixÃ­ Ã©s com es fa amb OpenLayers 4
	//https://gis.stackexchange.com/questions/251770/how-can-i-clear-a-vector-layer-features-in-openlayers-4
	vectorLayericones.getSource().clear()

	vectorLayerIcones = [];
				init_layer(filt);

}

function init_mapa() {

	var tipusMapa = 'toner';

	var renderToner = [
		new ol.layer.Tile({
			source: new ol.source.Stamen({
				layer: 'toner'
			})
		})
	]

	map = new ol.Map({
		target: 'map',
		layers: renderToner,
		view: new ol.View({
			center: ol.proj.fromLonLat([2.2,41.7]),
			zoom: 9
		})
	});


	init_layer('');

}

function init_layer() {
	var points = [];
	for (let i=0;i<railways.elements.length;i++){
		if (railways.elements[i].type == 'node') {
			//console.log(railways.elements[i].type + ": " + railways.elements[i].id + " (" + railways.elements[i].lat + "," + railways.elements[i].lon + ")");
			let coord = [railways.elements[i].lon, railways.elements[i].lat];
			points.push(coord)
		}
	}

	for (var i = 0; i < points.length; i++) {
		 points[i] = ol.proj.transform(points[i], 'EPSG:4326', 'EPSG:3857');
	}

	var featureLine = new ol.Feature({
		 geometry: new ol.geom.LineString(points)
	});

	var vectorLine = new ol.source.Vector({});
	vectorLine.addFeature(featureLine);

	var vectorLineLayer = new ol.layer.Vector({
		 source: vectorLine,
		 style: new ol.style.Style({
		     fill: new ol.style.Fill({ color: '#0000ff', weight: 3 }),
		     stroke: new ol.style.Stroke({ color: '#0000ff', width: 3 })
		 })
	});

	map.addLayer(vectorLineLayer);
}




